/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.util.Map;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.Utils;
import org.knowm.xchart.internal.chartpart.Axis;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.PlotContent_;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.lines.SeriesLines;

public class PlotContent_XY<ST extends AxesChartStyler, S extends XYSeries>
extends PlotContent_<ST, S> {
    private final ST xyStyler;

    PlotContent_XY(Chart<ST, S> chart) {
        super(chart);
        this.xyStyler = (AxesChartStyler)chart.getStyler();
    }

    @Override
    public void doPaint(Graphics2D g) {
        double xTickSpace = ((Styler)this.xyStyler).getPlotContentSize() * this.getBounds().getWidth();
        double xLeftMargin = Utils.getTickStartOffset((int)this.getBounds().getWidth(), xTickSpace);
        double yTickSpace = ((Styler)this.xyStyler).getPlotContentSize() * this.getBounds().getHeight();
        double yTopMargin = Utils.getTickStartOffset((int)this.getBounds().getHeight(), yTickSpace);
        double xMin = this.chart.getXAxis().getMin();
        double xMax = this.chart.getXAxis().getMax();
        Line2D.Double line = new Line2D.Double();
        if (((AxesChartStyler)this.xyStyler).isXAxisLogarithmic()) {
            xMin = Math.log10(xMin);
            xMax = Math.log10(xMax);
        }
        Map map = this.chart.getSeriesMap();
        for (XYSeries series : map.values()) {
            if (!series.isEnabled()) continue;
            Axis yAxis = this.chart.getYAxis(series.getYAxisGroup());
            double yMin = yAxis.getMin();
            double yMax = yAxis.getMax();
            if (((AxesChartStyler)this.xyStyler).isYAxisLogarithmic()) {
                yMin = Math.log10(yMin);
                yMax = Math.log10(yMax);
            }
            double[] xData = series.getXData();
            double[] yData = series.getYData();
            double previousX = -1.7976931348623157E308;
            double previousY = -1.7976931348623157E308;
            double[] errorBars = series.getExtraValues();
            Path2D.Double path = null;
            boolean toolTipsEnabled = ((AxesChartStyler)this.chart.getStyler()).isToolTipsEnabled();
            String[] toolTips = series.getToolTips();
            boolean hasCustomToolTips = toolTips != null;
            for (int i = 0; i < xData.length; ++i) {
                boolean isSeriesStepLineOrStepArea;
                double next;
                double x = xData[i];
                if (((AxesChartStyler)this.xyStyler).isXAxisLogarithmic()) {
                    x = Math.log10(x);
                }
                if (Double.isNaN(next = yData[i])) {
                    this.closePath(g, path, previousX, this.getBounds(), yTopMargin);
                    path = null;
                    previousX = -1.7976931348623157E308;
                    previousY = -1.7976931348623157E308;
                    continue;
                }
                double yOrig = yData[i];
                double y = ((AxesChartStyler)this.xyStyler).isYAxisLogarithmic() ? Math.log10(yOrig) : yOrig;
                double xTransform = xLeftMargin + (x - xMin) / (xMax - xMin) * xTickSpace;
                double yTransform = this.getBounds().getHeight() - (yTopMargin + (y - yMin) / (yMax - yMin) * yTickSpace);
                if (Math.abs(xMax - xMin) / 5.0 == 0.0) {
                    xTransform = this.getBounds().getWidth() / 2.0;
                }
                if (Math.abs(yMax - yMin) / 5.0 == 0.0) {
                    yTransform = this.getBounds().getHeight() / 2.0;
                }
                double xOffset = this.getBounds().getX() + xTransform;
                double yOffset = this.getBounds().getY() + yTransform;
                boolean isSeriesLineOrArea = XYSeries.XYSeriesRenderStyle.Line == series.getXYSeriesRenderStyle() || XYSeries.XYSeriesRenderStyle.Area == series.getXYSeriesRenderStyle();
                boolean bl = isSeriesStepLineOrStepArea = XYSeries.XYSeriesRenderStyle.Step == series.getXYSeriesRenderStyle() || XYSeries.XYSeriesRenderStyle.StepArea == series.getXYSeriesRenderStyle();
                if ((isSeriesLineOrArea || isSeriesStepLineOrStepArea) && series.getLineStyle() != SeriesLines.NONE && previousX != -1.7976931348623157E308 && previousY != -1.7976931348623157E308) {
                    g.setColor(series.getLineColor());
                    g.setStroke(series.getLineStyle());
                    if (isSeriesLineOrArea) {
                        line.setLine(previousX, previousY, xOffset, yOffset);
                        g.draw(line);
                    } else {
                        if (previousX != xOffset) {
                            line.setLine(previousX, previousY, xOffset, previousY);
                            g.draw(line);
                        }
                        if (previousY != yOffset) {
                            line.setLine(xOffset, previousY, xOffset, yOffset);
                            g.draw(line);
                        }
                    }
                }
                if (XYSeries.XYSeriesRenderStyle.Area == series.getXYSeriesRenderStyle() || XYSeries.XYSeriesRenderStyle.StepArea == series.getXYSeriesRenderStyle()) {
                    if (previousX != -1.7976931348623157E308 && previousY != -1.7976931348623157E308) {
                        double yBottomOfArea = this.getBounds().getY() + this.getBounds().getHeight() - yTopMargin;
                        if (path == null) {
                            path = new Path2D.Double();
                            path.moveTo(previousX, yBottomOfArea);
                            path.lineTo(previousX, previousY);
                        }
                        if (XYSeries.XYSeriesRenderStyle.Area == series.getXYSeriesRenderStyle()) {
                            path.lineTo(xOffset, yOffset);
                        } else {
                            if (previousX != xOffset) {
                                path.lineTo(xOffset, previousY);
                            }
                            if (previousY != yOffset) {
                                path.lineTo(xOffset, yOffset);
                            }
                        }
                    }
                    if (xOffset < previousX) {
                        throw new RuntimeException("X-Data must be in ascending order for Area Charts!!!");
                    }
                }
                previousX = xOffset;
                previousY = yOffset;
                if (series.getMarker() != null) {
                    g.setColor(series.getMarkerColor());
                    series.getMarker().paint(g, xOffset, yOffset, ((AxesChartStyler)this.xyStyler).getMarkerSize());
                }
                if (errorBars != null) {
                    double bottomValue;
                    double topValue;
                    double eb = errorBars[i];
                    if (((AxesChartStyler)this.xyStyler).isErrorBarsColorSeriesColor()) {
                        g.setColor(series.getLineColor());
                    } else {
                        g.setColor(((AxesChartStyler)this.xyStyler).getErrorBarsColor());
                    }
                    g.setStroke(this.errorBarStroke);
                    if (((AxesChartStyler)this.xyStyler).isYAxisLogarithmic()) {
                        topValue = yOrig + eb;
                        topValue = Math.log10(topValue);
                    } else {
                        topValue = y + eb;
                    }
                    double topEBTransform = this.getBounds().getHeight() - (yTopMargin + (topValue - yMin) / (yMax - yMin) * yTickSpace);
                    double topEBOffset = this.getBounds().getY() + topEBTransform;
                    if (((AxesChartStyler)this.xyStyler).isYAxisLogarithmic()) {
                        bottomValue = yOrig - eb;
                        bottomValue = Math.log10(bottomValue);
                    } else {
                        bottomValue = y - eb;
                    }
                    double bottomEBTransform = this.getBounds().getHeight() - (yTopMargin + (bottomValue - yMin) / (yMax - yMin) * yTickSpace);
                    double bottomEBOffset = this.getBounds().getY() + bottomEBTransform;
                    line.setLine(xOffset, topEBOffset, xOffset, bottomEBOffset);
                    g.draw(line);
                    line.setLine(xOffset - 3.0, bottomEBOffset, xOffset + 3.0, bottomEBOffset);
                    g.draw(line);
                    line.setLine(xOffset - 3.0, topEBOffset, xOffset + 3.0, topEBOffset);
                    g.draw(line);
                }
                if (!toolTipsEnabled) continue;
                if (hasCustomToolTips) {
                    String tt = toolTips[i];
                    if (tt == null) continue;
                    this.chart.toolTips.addData(xOffset, yOffset, tt);
                    continue;
                }
                this.chart.toolTips.addData(xOffset, yOffset, this.chart.getXAxisFormat().format(x), this.chart.getYAxisFormat().format(yOrig));
            }
            g.setColor(series.getFillColor());
            this.closePath(g, path, previousX, this.getBounds(), yTopMargin);
        }
    }
}

