/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import ij.ImagePlus;
import ij.io.FileSaver;
import ini.trakem2.io.ImageSaver;

public class Saver {
    private final ASaver saver;
    private final String extension;

    public static final String[] formats() {
        return new String[]{".tif", ".tif.zip", ".png", ".jpg"};
    }

    public Saver(String extension) {
        String ext = extension.toLowerCase();
        if ('.' != ext.charAt(0)) {
            ext = "." + ext;
        }
        this.extension = ext;
        if (".jpeg".equals(ext) || ".jpg".equals(ext)) {
            this.saver = new JPEGSaver();
        } else if (".png".equals(ext)) {
            this.saver = new PNGSaver();
        } else if (".tiff".equals(ext) || ".tif".equals(ext)) {
            this.saver = new TIFFSaver();
        } else if (".tiff.zip".equals(ext) || ".tif.zip".equals(ext) || ".zip".equals(ext)) {
            this.saver = new ZIPSaver();
        } else {
            throw new RuntimeException("Unknown format '" + extension + "'");
        }
    }

    public void setQuality(float q) {
        this.saver.setQuality(q);
    }

    public boolean save(ImagePlus imp, String path) {
        if (!path.toLowerCase().endsWith(this.extension)) {
            path = path + this.extension;
        }
        return this.saver.save(imp, path);
    }

    public String getExtension() {
        return this.extension;
    }

    private class ZIPSaver
    extends ASaver {
        private ZIPSaver() {
        }

        @Override
        boolean save(ImagePlus imp, String path) {
            return ImageSaver.checkPath(path) && new FileSaver(imp).saveAsZip(path);
        }
    }

    private class TIFFSaver
    extends ASaver {
        private TIFFSaver() {
        }

        @Override
        boolean save(ImagePlus imp, String path) {
            return ImageSaver.checkPath(path) && new FileSaver(imp).saveAsTiff(path);
        }
    }

    private class PNGSaver
    extends ASaver {
        private PNGSaver() {
        }

        @Override
        boolean save(ImagePlus imp, String path) {
            return ImageSaver.checkPath(path) && new FileSaver(imp).saveAsPng(path);
        }
    }

    private class JPEGSaver
    extends ASaver {
        JPEGSaver() {
            this.q = (float)FileSaver.getJpegQuality() / 100.0f;
        }

        @Override
        boolean save(ImagePlus imp, String path) {
            return ImageSaver.saveAsJpeg(imp.getProcessor(), path, this.q, 4 != imp.getType());
        }
    }

    private abstract class ASaver {
        float q = 1.0f;

        private ASaver() {
        }

        abstract boolean save(ImagePlus var1, String var2);

        void setQuality(float q) {
            this.q = q;
        }
    }
}

