/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.align;

import ij.IJ;
import ij.gui.GenericDialog;
import ini.trakem2.display.Display;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Patch;
import ini.trakem2.parallel.ExecutorProvider;
import ini.trakem2.utils.Filter;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.FloatArray2DSIFT;
import mpicbg.models.AbstractAffineModel2D;
import mpicbg.models.Affine2D;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.HomographyModel2D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InterpolatedAffineModel2D;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel2D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.Tile;
import mpicbg.models.TileConfiguration;
import mpicbg.models.Transforms;
import mpicbg.models.TranslationModel2D;
import mpicbg.trakem2.align.AbstractLayerAlignmentParam;
import mpicbg.trakem2.align.AlignTask;
import mpicbg.trakem2.align.AlignmentUtils;
import mpicbg.trakem2.align.Util;
import mpicbg.trakem2.util.Triple;

public class RegularizedAffineLayerAlignment {
    static final Param p = new Param();

    /*
     * WARNING - void declaration
     */
    public final void exec(Param param, List<Layer> layerRange, Set<Layer> fixedLayers, Set<Layer> emptyLayers, Rectangle box, boolean propagateTransformBefore, boolean propagateTransformAfter, Filter<Patch> filter) throws Exception {
        void var23_39;
        void var22_29;
        double scale = Math.min(1.0, Math.min((double)param.ppm.sift.maxOctaveSize / (double)box.width, (double)param.ppm.sift.maxOctaveSize / (double)box.height));
        ExecutorService exec = ExecutorProvider.getExecutorService(1.0f / (float)param.maxNumThreads);
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        AbstractAffineModel2D m = (AbstractAffineModel2D)Util.createModel(param.desiredModelIndex);
        AbstractAffineModel2D r = (AbstractAffineModel2D)Util.createModel(param.regularizerIndex);
        for (int i = 0; i < layerRange.size(); ++i) {
            if (param.regularize) {
                tiles.add(new Tile((Model)new InterpolatedAffineModel2D(m.copy(), r.copy(), param.lambda)));
                continue;
            }
            tiles.add(new Tile(m.copy()));
        }
        ArrayList<Triple> pairs = new ArrayList<Triple>();
        try {
            AlignmentUtils.extractAndSaveLayerFeatures(layerRange, box, scale, filter, param.ppm.sift, param.ppm.clearCache, param.ppm.maxNumThreadsSift);
        }
        catch (Exception e) {
            e.printStackTrace();
            IJError.print(e);
            return;
        }
        int numFailures = 0;
        int lastA = 0;
        double pointMatchScale = 1.0 / scale;
        ArrayList<Future<Triple<Integer, Integer, Collection<PointMatch>>>> modelFutures = new ArrayList<Future<Triple<Integer, Integer, Collection<PointMatch>>>>();
        for (int i = 0; i < layerRange.size(); ++i) {
            int n = Math.min(layerRange.size(), i + param.maxNumNeighbors + 1);
            for (int j = i + 1; j < n; ++j) {
                modelFutures.add(exec.submit(new CorrespondenceCallable(param, layerRange.get(i), layerRange.get(j), pointMatchScale, i, j)));
            }
        }
        try {
            for (Future future : modelFutures) {
                Triple triple = (Triple)future.get();
                if (lastA != (Integer)triple.a) {
                    numFailures = 0;
                    lastA = (Integer)triple.a;
                }
                if (triple.c == null) {
                    ++numFailures;
                    continue;
                }
                if (numFailures >= param.maxNumFailures) continue;
                pairs.add(triple);
            }
        }
        catch (InterruptedException ie) {
            Utils.log("Establishing feature correspondences interrupted.");
            for (Future future : modelFutures) {
                future.cancel(true);
            }
            return;
        }
        TileConfiguration tileConfiguration = new TileConfiguration();
        for (Triple triple : pairs) {
            Tile t1 = (Tile)tiles.get((Integer)triple.a);
            Tile t2 = (Tile)tiles.get((Integer)triple.b);
            tileConfiguration.addTile(t1);
            tileConfiguration.addTile(t2);
            t2.connect(t1, (Collection)triple.c);
        }
        boolean bl = false;
        while (var22_29 < layerRange.size()) {
            Layer layer = layerRange.get((int)var22_29);
            if (fixedLayers.contains(layer)) {
                tileConfiguration.fixTile((Tile)tiles.get((int)var22_29));
            }
            ++var22_29;
        }
        List list = tileConfiguration.preAlign();
        IJ.log((String)("pre-aligned all but " + list.size() + " tiles"));
        tileConfiguration.optimize((double)param.maxEpsilon, param.maxIterationsOptimize, param.maxPlateauwidthOptimize);
        Utils.log(new StringBuffer("Successfully optimized configuration of ").append(tiles.size()).append(" tiles:").toString());
        Utils.log("  average displacement: " + String.format("%.3f", tileConfiguration.getError()) + "px");
        Utils.log("  minimal displacement: " + String.format("%.3f", tileConfiguration.getMinError()) + "px");
        Utils.log("  maximal displacement: " + String.format("%.3f", tileConfiguration.getMaxError()) + "px");
        if (propagateTransformBefore || propagateTransformAfter) {
            Layer layer = layerRange.get(0);
            ArrayList<Layer> layers = layer.getParent().getLayers();
            if (propagateTransformBefore) {
                AffineTransform b = RegularizedAffineLayerAlignment.translateAffine(box, ((Affine2D)((Tile)tiles.get(0)).getModel()).createAffine());
                int firstLayerIndex = layer.getParent().getLayerIndex(layer.getId());
                for (int i = 0; i < firstLayerIndex; ++i) {
                    RegularizedAffineLayerAlignment.applyTransformToLayer((Layer)layers.get(i), b, filter);
                }
            }
            if (propagateTransformAfter) {
                Layer last = layerRange.get(layerRange.size() - 1);
                AffineTransform b = RegularizedAffineLayerAlignment.translateAffine(box, ((Affine2D)((Tile)tiles.get(tiles.size() - 1)).getModel()).createAffine());
                int lastLayerIndex = last.getParent().getLayerIndex(last.getId());
                for (int i = lastLayerIndex + 1; i < layers.size(); ++i) {
                    RegularizedAffineLayerAlignment.applyTransformToLayer((Layer)layers.get(i), b, filter);
                }
            }
        }
        boolean bl2 = false;
        while (var23_39 < layerRange.size()) {
            AffineTransform b = RegularizedAffineLayerAlignment.translateAffine(box, ((Affine2D)((Tile)tiles.get((int)var23_39)).getModel()).createAffine());
            RegularizedAffineLayerAlignment.applyTransformToLayer(layerRange.get((int)var23_39), b, filter);
            ++var23_39;
        }
        Utils.log("Done.");
    }

    protected static final AffineTransform translateAffine(Rectangle box, AffineTransform affine) {
        AffineTransform b = new AffineTransform();
        b.translate(box.x, box.y);
        b.concatenate(affine);
        b.translate(-box.x, -box.y);
        return b;
    }

    protected static final void applyTransformToLayer(Layer layer, AffineTransform affine, Filter<Patch> filter) {
        AlignTask.transformPatchesAndVectorData(AlignmentUtils.filterPatches(layer, filter), affine);
        Display.repaint(layer);
    }

    public final void exec(List<Layer> layerRange, Set<Layer> fixedLayers, boolean propagateTransformBefore, boolean propagateTransformAfter, Rectangle fov, Filter<Patch> filter) throws Exception {
        Rectangle box = null;
        HashSet<Layer> emptyLayers = new HashSet<Layer>();
        for (Layer la : layerRange) {
            if (!la.contains(Patch.class, true)) {
                emptyLayers.add(la);
                continue;
            }
            if (null == box) {
                box = la.getMinimalBoundingBox(Patch.class, true);
                continue;
            }
            box = box.union(la.getMinimalBoundingBox(Patch.class, true));
        }
        if (box == null) {
            box = new Rectangle();
        }
        if (fov != null) {
            box = box.intersection(fov);
        }
        if (box.width <= 0 || box.height <= 0) {
            Utils.log("Bounding box empty.");
            return;
        }
        if (layerRange.size() == emptyLayers.size()) {
            Utils.log("All layers in range are empty!");
            return;
        }
        if (layerRange.size() - emptyLayers.size() < 2) {
            Utils.log("All except one layer in range are empty!");
            return;
        }
        if (!p.setup(box)) {
            return;
        }
        this.exec(p.clone(), layerRange, fixedLayers, emptyLayers, box, propagateTransformBefore, propagateTransformAfter, filter);
    }

    public final void exec(LayerSet layerSet, int firstIn, int lastIn, int ref, boolean propagateTransformBefore, boolean propagateTransformAfter, Rectangle fov, Filter<Patch> filter) throws Exception {
        int first = Math.min(firstIn, lastIn);
        int last = Math.max(firstIn, lastIn);
        List<Layer> layerRange = layerSet.getLayers(first, last);
        HashSet<Layer> fixedLayers = new HashSet<Layer>();
        if (ref - first >= 0) {
            fixedLayers.add(layerRange.get(ref - first));
        }
        Utils.log(layerRange.size() + "");
        this.exec(layerRange, fixedLayers, propagateTransformBefore, propagateTransformAfter, fov, filter);
    }

    public final void exec(LayerSet layerSet, int firstIn, int lastIn, int ref, boolean propagateTransform, Rectangle fov, Filter<Patch> filter) throws Exception {
        if (firstIn < lastIn) {
            this.exec(layerSet, firstIn, lastIn, ref, false, propagateTransform, fov, filter);
        } else {
            this.exec(layerSet, firstIn, lastIn, ref, propagateTransform, false, fov, filter);
        }
    }

    public final void exec(LayerSet layerSet, int firstIn, int lastIn, int ref1, int ref2, boolean propagateTransformBefore, boolean propagateTransformAfter, Rectangle fov, Filter<Patch> filter) throws Exception {
        int first = Math.min(firstIn, lastIn);
        int last = Math.max(firstIn, lastIn);
        List<Layer> layerRange = layerSet.getLayers(first, last);
        HashSet<Layer> fixedLayers = new HashSet<Layer>();
        if (ref1 - first >= 0) {
            fixedLayers.add(layerRange.get(ref1 - first));
        }
        if (ref2 - first >= 0) {
            fixedLayers.add(layerRange.get(ref2 - first));
        }
        Utils.log(layerRange.size() + "");
        this.exec(layerRange, fixedLayers, propagateTransformBefore, propagateTransformAfter, fov, filter);
    }

    private static class CorrespondenceCallable
    implements Callable<Triple<Integer, Integer, Collection<PointMatch>>>,
    Serializable {
        final Param param;
        final Layer layerA;
        final Layer layerB;
        final double pointMatchScale;
        final int sliceA;
        final int sliceB;

        public CorrespondenceCallable(Param param, Layer layerA, Layer layerB, double pointMatchScale, int sliceA, int sliceB) {
            this.param = param;
            this.layerA = layerA;
            this.layerB = layerB;
            this.pointMatchScale = pointMatchScale;
            this.sliceA = sliceA;
            this.sliceB = sliceB;
        }

        private static final double squareP1LocalWidth(List<PointMatch> matches) {
            double dMax = 0.0;
            for (int i = 0; i < matches.size(); ++i) {
                PointMatch m1 = matches.get(i);
                for (int j = i + 1; j < matches.size(); ++j) {
                    PointMatch m2 = matches.get(j);
                    double d = Point.squareLocalDistance((Point)m1.getP1(), (Point)m2.getP1());
                    if (!(d > dMax)) continue;
                    dMax = d;
                }
            }
            return dMax;
        }

        private static final int match(Param param, List<PointMatch> candidates, List<PointMatch> inliers, Model<?> model) {
            boolean again = false;
            int nHypotheses = 0;
            double maxWidth = 0.0;
            try {
                do {
                    again = false;
                    ArrayList<PointMatch> inliers2 = new ArrayList<PointMatch>();
                    boolean modelFound = model.filterRansac(candidates, inliers2, 1000, (double)param.maxEpsilon, (double)param.minInlierRatio, param.minNumInliers, 3.0);
                    if (!modelFound) continue;
                    candidates.removeAll(inliers2);
                    if (param.rejectIdentity) {
                        ArrayList points = new ArrayList();
                        PointMatch.sourcePoints(inliers2, points);
                        if (Transforms.isIdentity(model, points, (double)param.identityTolerance)) {
                            IJ.log((String)("Identity transform for " + inliers2.size() + " matches rejected."));
                            again = true;
                            continue;
                        }
                    }
                    ++nHypotheses;
                    if (param.widestSetOnly) {
                        double width = CorrespondenceCallable.squareP1LocalWidth(inliers2);
                        if (width > maxWidth) {
                            maxWidth = width;
                            inliers.clear();
                            inliers.addAll(inliers2);
                        }
                    } else {
                        inliers.addAll(inliers2);
                    }
                    again = param.multipleHypotheses | param.widestSetOnly;
                } while (again);
            }
            catch (NotEnoughDataPointsException notEnoughDataPointsException) {
                // empty catch block
            }
            return nHypotheses;
        }

        @Override
        public Triple<Integer, Integer, Collection<PointMatch>> call() throws Exception {
            TranslationModel2D model;
            String layerNameA = AlignmentUtils.layerName(this.layerA);
            String layerNameB = AlignmentUtils.layerName(this.layerB);
            Triple nullTriple = new Triple((Object)this.sliceA, (Object)this.sliceB, null);
            ArrayList<Object> candidates = null;
            if (!this.param.ppm.clearCache) {
                candidates = Util.deserializePointMatches(this.layerB.getProject(), this.param.ppm, "layer", this.layerB.getId(), this.layerA.getId());
            }
            if (null == candidates) {
                ArrayList<Feature> fs1 = Util.deserializeFeatures(this.layerA.getProject(), this.param.ppm.sift, "layer", this.layerA.getId());
                ArrayList<Feature> fs2 = Util.deserializeFeatures(this.layerB.getProject(), this.param.ppm.sift, "layer", this.layerB.getId());
                candidates = new ArrayList(FloatArray2DSIFT.createMatches(fs2, fs1, (float)this.param.ppm.rod));
                for (PointMatch pointMatch : candidates) {
                    Point p1 = pointMatch.getP1();
                    Point p2 = pointMatch.getP2();
                    double[] l1 = p1.getL();
                    double[] w1 = p1.getW();
                    double[] l2 = p2.getL();
                    double[] w2 = p2.getW();
                    l1[0] = l1[0] * this.pointMatchScale;
                    l1[1] = l1[1] * this.pointMatchScale;
                    w1[0] = w1[0] * this.pointMatchScale;
                    w1[1] = w1[1] * this.pointMatchScale;
                    l2[0] = l2[0] * this.pointMatchScale;
                    l2[1] = l2[1] * this.pointMatchScale;
                    w2[0] = w2[0] * this.pointMatchScale;
                    w2[1] = w2[1] * this.pointMatchScale;
                }
                if (!Util.serializePointMatches(this.layerB.getProject(), this.param.ppm, "layer", this.layerB.getId(), this.layerA.getId(), candidates)) {
                    Utils.log("Could not store point match candidates for layers " + layerNameB + " and " + layerNameA + ".");
                }
            }
            switch (this.param.expectedModelIndex) {
                case 0: {
                    model = new TranslationModel2D();
                    break;
                }
                case 1: {
                    model = new RigidModel2D();
                    break;
                }
                case 2: {
                    model = new SimilarityModel2D();
                    break;
                }
                case 3: {
                    model = new AffineModel2D();
                    break;
                }
                case 4: {
                    model = new HomographyModel2D();
                    break;
                }
                default: {
                    return nullTriple;
                }
            }
            ArrayList<PointMatch> inliers = new ArrayList<PointMatch>();
            int nHypotheses = CorrespondenceCallable.match(this.param, candidates, inliers, model);
            if (nHypotheses > 0 && this.param.multipleHypotheses | this.param.widestSetOnly) {
                try {
                    model.fit(inliers);
                    PointMatch.apply(inliers, (CoordinateTransform)model);
                }
                catch (NotEnoughDataPointsException notEnoughDataPointsException) {
                }
                catch (IllDefinedDataPointsException illDefinedDataPointsException) {
                    nHypotheses = 0;
                }
            }
            if (nHypotheses > 0) {
                Utils.log(layerNameB + " -> " + layerNameA + ": " + inliers.size() + " corresponding features with an average displacement of " + PointMatch.meanDistance(inliers) + "px identified.");
                Utils.log("Estimated transformation model: " + model + (this.param.multipleHypotheses ? " from " + nHypotheses + " hypotheses" : ""));
                return new Triple((Object)this.sliceA, (Object)this.sliceB, inliers);
            }
            Utils.log(layerNameB + " -> " + layerNameA + ": no correspondences found.");
            return nullTriple;
        }
    }

    public static final class Param
    extends AbstractLayerAlignmentParam
    implements Serializable {
        public boolean regularize = false;
        public int regularizerIndex = 1;
        public double lambda = 0.1;

        public boolean setup(Rectangle box) {
            if (!this.setupSIFT("Elastically align layers: ")) {
                return false;
            }
            GenericDialog gd = new GenericDialog("Align layers: Geometric filters");
            gd.addNumericField("maximal_alignment_error :", (double)this.maxEpsilon, 2, 6, "px");
            gd.addNumericField("minimal_inlier_ratio :", (double)this.minInlierRatio, 2);
            gd.addNumericField("minimal_number_of_inliers :", (double)this.minNumInliers, 0);
            gd.addChoice("expected_transformation :", modelStrings, modelStrings[this.expectedModelIndex]);
            gd.addCheckbox("test_multiple_hypotheses", this.multipleHypotheses);
            gd.addCheckbox("widest_set_only", this.widestSetOnly);
            gd.addCheckbox("ignore constant background", this.rejectIdentity);
            gd.addNumericField("tolerance :", (double)this.identityTolerance, 2, 6, "px");
            gd.addMessage("Layer neighbor range:");
            gd.addNumericField("test_maximally :", (double)this.maxNumNeighbors, 0, 6, "layers");
            gd.addNumericField("give_up_after :", (double)this.maxNumFailures, 0, 6, "failures");
            gd.showDialog();
            if (gd.wasCanceled()) {
                return false;
            }
            this.maxEpsilon = (float)gd.getNextNumber();
            this.minInlierRatio = (float)gd.getNextNumber();
            this.minNumInliers = (int)gd.getNextNumber();
            this.expectedModelIndex = gd.getNextChoiceIndex();
            this.multipleHypotheses = gd.getNextBoolean();
            this.widestSetOnly = gd.getNextBoolean();
            this.rejectIdentity = gd.getNextBoolean();
            this.identityTolerance = (float)gd.getNextNumber();
            this.maxNumNeighbors = (int)gd.getNextNumber();
            this.maxNumFailures = (int)gd.getNextNumber();
            GenericDialog gdOptimize = new GenericDialog("Align layers: Optimization");
            gdOptimize.addChoice("desired_transformation :", modelStrings, modelStrings[this.desiredModelIndex]);
            gdOptimize.addCheckbox("regularize model", this.regularize);
            gdOptimize.addMessage("Optimization:");
            gdOptimize.addNumericField("maximal_iterations :", (double)this.maxIterationsOptimize, 0);
            gdOptimize.addNumericField("maximal_plateauwidth :", (double)this.maxPlateauwidthOptimize, 0);
            gdOptimize.showDialog();
            if (gdOptimize.wasCanceled()) {
                return false;
            }
            this.desiredModelIndex = gdOptimize.getNextChoiceIndex();
            this.regularize = gdOptimize.getNextBoolean();
            this.maxIterationsOptimize = (int)gdOptimize.getNextNumber();
            this.maxPlateauwidthOptimize = (int)gdOptimize.getNextNumber();
            if (this.regularize) {
                GenericDialog gdRegularize = new GenericDialog("Align layers: Regularization");
                gdRegularize.addChoice("regularizer :", modelStrings, modelStrings[this.regularizerIndex]);
                gdRegularize.addNumericField("lambda :", this.lambda, 2);
                gdRegularize.showDialog();
                if (gdRegularize.wasCanceled()) {
                    return false;
                }
                this.regularizerIndex = gdRegularize.getNextChoiceIndex();
                this.lambda = gdRegularize.getNextNumber();
            }
            return true;
        }

        public Param() {
        }

        public Param(int SIFTfdBins, int SIFTfdSize, float SIFTinitialSigma, int SIFTmaxOctaveSize, int SIFTminOctaveSize, int SIFTsteps, boolean clearCache, int maxNumThreadsSift, float rod, int desiredModelIndex, int expectedModelIndex, float identityTolerance, double lambda, float maxEpsilon, int maxIterationsOptimize, int maxNumFailures, int maxNumNeighbors, int maxNumThreads, int maxPlateauwidthOptimize, float minInlierRatio, int minNumInliers, boolean multipleHypotheses, boolean widestSetOnly, boolean regularize, int regularizerIndex, boolean rejectIdentity, boolean visualize) {
            super(SIFTfdBins, SIFTfdSize, SIFTinitialSigma, SIFTmaxOctaveSize, SIFTminOctaveSize, SIFTsteps, clearCache, maxNumThreadsSift, rod, desiredModelIndex, expectedModelIndex, identityTolerance, maxEpsilon, maxIterationsOptimize, maxNumFailures, maxNumNeighbors, maxNumThreads, maxPlateauwidthOptimize, minInlierRatio, minNumInliers, multipleHypotheses, widestSetOnly, rejectIdentity, visualize);
            this.lambda = lambda;
            this.regularize = regularize;
            this.regularizerIndex = regularizerIndex;
        }

        @Override
        public Param clone() {
            return new Param(this.ppm.sift.fdBins, this.ppm.sift.fdSize, this.ppm.sift.initialSigma, this.ppm.sift.maxOctaveSize, this.ppm.sift.minOctaveSize, this.ppm.sift.steps, this.ppm.clearCache, this.ppm.maxNumThreadsSift, this.ppm.rod, this.desiredModelIndex, this.expectedModelIndex, this.identityTolerance, this.lambda, this.maxEpsilon, this.maxIterationsOptimize, this.maxNumFailures, this.maxNumNeighbors, this.maxNumThreads, this.maxPlateauwidthOptimize, this.minInlierRatio, this.minNumInliers, this.multipleHypotheses, this.widestSetOnly, this.regularize, this.regularizerIndex, this.rejectIdentity, this.visualize);
        }
    }
}

