/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.display.imagej;

import ij.ImagePlus;
import ij.ImageStack;
import ij.VirtualStack;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.TypedAxis;
import net.imglib2.Interval;
import net.imglib2.img.Img;
import net.imglib2.img.basictypeaccess.PlanarAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.display.imagej.AbstractVirtualStack;
import net.imglib2.img.display.imagej.CalibrationUtils;
import net.imglib2.img.display.imagej.ImageProcessorUtils;
import net.imglib2.img.display.imagej.ImgPlusViews;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Cast;
import net.imglib2.util.IntervalIndexer;

public class PlanarImgToVirtualStack
extends AbstractVirtualStack {
    private final PlanarAccess<? extends ArrayDataAccess<?>> img;
    private final IntUnaryOperator indexer;
    private static final List<AxisType> ALLOWED_AXES = Arrays.asList(Axes.X, Axes.Y, Axes.CHANNEL, Axes.Z, Axes.TIME);

    public static boolean isSupported(ImgPlus<?> imgPlus) {
        return (imgPlus = ImgPlusViews.fixAxes(imgPlus)).getImg() instanceof PlanarImg && PlanarImgToVirtualStack.checkAxisOrder(PlanarImgToVirtualStack.getAxes(imgPlus)) && ImageProcessorUtils.isSupported((NativeType)imgPlus.randomAccess().get());
    }

    public static ImagePlus wrap(ImgPlus<?> imgPlus) {
        Img img = (imgPlus = ImgPlusViews.fixAxes(imgPlus)).getImg();
        if (!(img instanceof PlanarImg)) {
            throw new IllegalArgumentException("Image must be a PlanarImg.");
        }
        IntUnaryOperator indexer = PlanarImgToVirtualStack.getIndexer(imgPlus);
        PlanarImgToVirtualStack stack = new PlanarImgToVirtualStack((PlanarImg)img, indexer);
        ImagePlus imagePlus = new ImagePlus(imgPlus.getName(), (ImageStack)stack);
        imagePlus.setDimensions(PlanarImgToVirtualStack.dimension(imgPlus, Axes.CHANNEL), PlanarImgToVirtualStack.dimension(imgPlus, Axes.Z), PlanarImgToVirtualStack.dimension(imgPlus, Axes.TIME));
        CalibrationUtils.copyCalibrationToImagePlus(imgPlus, imagePlus);
        return imagePlus;
    }

    private static int dimension(ImgPlus<?> imgPlus, AxisType axisType) {
        int index = imgPlus.dimensionIndex(axisType);
        return index < 0 ? 1 : (int)imgPlus.dimension(index);
    }

    public static VirtualStack wrap(PlanarImg<?, ?> img) {
        return new PlanarImgToVirtualStack(img, x -> x);
    }

    private PlanarImgToVirtualStack(PlanarImg<?, ?> img, IntUnaryOperator indexer) {
        super((int)img.dimension(0), (int)img.dimension(1), PlanarImgToVirtualStack.initSize(img), PlanarImgToVirtualStack.getBitDepth(img.randomAccess().get()));
        this.img = img;
        this.indexer = indexer;
    }

    private static int initSize(Interval interval) {
        return IntStream.range(2, interval.numDimensions()).map(x -> (int)interval.dimension(x)).reduce(1, (a, b) -> a * b);
    }

    @Override
    protected Object getPixelsZeroBasedIndex(int index) {
        return ((ArrayDataAccess)this.img.getPlane(this.indexer.applyAsInt(index))).getCurrentStorageArray();
    }

    @Override
    protected void setPixelsZeroBasedIndex(int index, Object pixels) {
        try {
            this.img.setPlane(this.indexer.applyAsInt(index), Cast.unchecked(this.wrapPixelsToAccess(pixels)));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private ArrayDataAccess<?> wrapPixelsToAccess(Object pixels) {
        if (pixels instanceof byte[]) {
            return new ByteArray((byte[])pixels);
        }
        if (pixels instanceof short[]) {
            return new ShortArray((short[])pixels);
        }
        if (pixels instanceof int[]) {
            return new IntArray((int[])pixels);
        }
        if (pixels instanceof float[]) {
            return new FloatArray((float[])pixels);
        }
        throw new UnsupportedOperationException();
    }

    private static int getBitDepth(Type<?> type) {
        if (type instanceof UnsignedByteType) {
            return 8;
        }
        if (type instanceof UnsignedShortType) {
            return 16;
        }
        if (type instanceof ARGBType) {
            return 24;
        }
        if (type instanceof FloatType) {
            return 32;
        }
        throw new IllegalArgumentException("unsupported type");
    }

    private static IntUnaryOperator getIndexer(ImgPlus<?> imgPlus) {
        List<AxisType> axes = PlanarImgToVirtualStack.getAxes(imgPlus);
        if (!PlanarImgToVirtualStack.checkAxisOrder(axes)) {
            throw new IllegalArgumentException("Unsupported axis order, first axis must be X, second axis must be Y, and then optionally, arbitrary ordered: channel, Z and time.");
        }
        if (PlanarImgToVirtualStack.inPreferredOrder(axes)) {
            return x -> x;
        }
        int[] stackSizes = new int[]{PlanarImgToVirtualStack.dimension(imgPlus, Axes.CHANNEL), PlanarImgToVirtualStack.dimension(imgPlus, Axes.Z), PlanarImgToVirtualStack.dimension(imgPlus, Axes.TIME)};
        int channelSkip = PlanarImgToVirtualStack.getSkip(imgPlus, Axes.CHANNEL);
        int zSkip = PlanarImgToVirtualStack.getSkip(imgPlus, Axes.Z);
        int timeSkip = PlanarImgToVirtualStack.getSkip(imgPlus, Axes.TIME);
        return stackIndex -> {
            int[] stackPosition = new int[3];
            IntervalIndexer.indexToPosition((int)stackIndex, (int[])stackSizes, (int[])stackPosition);
            return channelSkip * stackPosition[0] + zSkip * stackPosition[1] + timeSkip * stackPosition[2];
        };
    }

    private static List<AxisType> getAxes(ImgPlus<?> img) {
        return IntStream.range(0, img.numDimensions()).mapToObj(arg_0 -> img.axis(arg_0)).map(TypedAxis::type).collect(Collectors.toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkAxisOrder(List<AxisType> axes) {
        if (axes.size() < 2) return false;
        if (axes.size() > 5) return false;
        if (!PlanarImgToVirtualStack.testUnique(axes)) return false;
        if (axes.get(0) != Axes.X) return false;
        if (axes.get(1) != Axes.Y) return false;
        if (!axes.stream().allMatch(ALLOWED_AXES::contains)) return false;
        return true;
    }

    private static boolean inPreferredOrder(List<AxisType> axes) {
        for (int i = 0; i < axes.size() - 1; ++i) {
            if (PlanarImgToVirtualStack.preferredPosition(axes.get(i)) < PlanarImgToVirtualStack.preferredPosition(axes.get(i + 1))) continue;
            return false;
        }
        return true;
    }

    private static int preferredPosition(AxisType axisType) {
        if (axisType == Axes.X) {
            return 0;
        }
        if (axisType == Axes.Y) {
            return 1;
        }
        if (axisType == Axes.CHANNEL) {
            return 2;
        }
        if (axisType == Axes.Z) {
            return 3;
        }
        if (axisType == Axes.TIME) {
            return 4;
        }
        throw new IllegalArgumentException("unknown axis");
    }

    private static int getSkip(ImgPlus<?> imgPlus, AxisType axis) {
        int channelIndex = imgPlus.dimensionIndex(axis);
        return IntStream.range(2, channelIndex).map(i -> (int)imgPlus.dimension(i)).reduce(1, (a, b) -> a * b);
    }

    private static <T> boolean testUnique(List<T> list) {
        HashSet<T> set = new HashSet<T>(list);
        return set.size() == list.size();
    }
}

