/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kymographBuilder;

import ij.gui.Line;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.axis.Axes;
import net.imagej.axis.Axis;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultLinearAxis;
import net.imagej.ops.OpService;
import net.imagej.ops.Ops;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.Type;
import org.scijava.Context;
import org.scijava.convert.ConvertService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import sc.fiji.kymographBuilder.LinesBuilder;
import sc.fiji.kymographBuilder.Segment;

public class KymographCreator {
    @Parameter
    private ConvertService convert;
    @Parameter
    private LogService log;
    @Parameter
    private DatasetService dsService;
    @Parameter
    private OpService opService;
    private final Dataset dataset;
    private Dataset kymograph;
    private Dataset projectedKymograph;
    private final LinesBuilder linesBuilder;
    private RandomAccess<?> datasetCursor;
    private RandomAccess<?> kymographCursor;
    private final int zPosition;

    public KymographCreator(Context context, Dataset dataset, LinesBuilder linesBuilder, int zPosition) {
        context.inject((Object)this);
        this.linesBuilder = linesBuilder;
        this.dataset = dataset;
        this.zPosition = zPosition;
    }

    public Dataset getKymograph() {
        return this.kymograph;
    }

    public Dataset getProjectedKymograph() {
        return this.projectedKymograph;
    }

    public void build() {
        this.buildKymograph();
        this.projectKymograph();
    }

    private void buildKymograph() {
        long[] dimensions = new long[]{this.linesBuilder.getLines().size() == 1 ? (long)(this.linesBuilder.getTotalLength() - this.linesBuilder.getLines().size()) : (long)(this.linesBuilder.getTotalLength() - this.linesBuilder.getLines().size() + 1), this.dataset.dimension(this.dataset.dimensionIndex(Axes.TIME)), this.linesBuilder.getlineWidth(), this.dataset.dimension(this.dataset.dimensionIndex(Axes.CHANNEL))};
        AxisType[] axisTypes = new AxisType[]{Axes.X, Axes.Y, Axes.Z, Axes.CHANNEL};
        String title = this.dataset.getName() + " (Kymograph)";
        this.kymograph = this.dsService.create(dimensions, title, axisTypes, this.dataset.getValidBits(), this.dataset.isSigned(), !this.dataset.isInteger());
        this.datasetCursor = this.dataset.getImgPlus().randomAccess();
        this.kymographCursor = this.kymograph.getImgPlus().randomAccess();
        int offset = 0;
        for (int i = 0; i < this.linesBuilder.getLines().size(); ++i) {
            Segment line = this.linesBuilder.getLines().get(i);
            double[] vectorScaled = this.linesBuilder.getLinesVectorScaled().get(i);
            int length = this.linesBuilder.getLinesLength().get(i);
            this.fillKymograph(line, vectorScaled, offset);
            offset += length - 1;
        }
    }

    private <T extends Type<T>> void fillKymograph(Segment line, double[] vectorScaled, int offset) {
        double dx = vectorScaled[0];
        double dy = vectorScaled[1];
        int lineWidth = this.linesBuilder.getlineWidth();
        int timeDimension = (int)this.dataset.dimension(this.dataset.dimensionIndex(Axes.TIME));
        int xDimension = (int)this.dataset.dimension(this.dataset.dimensionIndex(Axes.X));
        int yDimension = (int)this.dataset.dimension(this.dataset.dimensionIndex(Axes.Y));
        int channelDimension = (int)this.dataset.dimension(this.dataset.dimensionIndex(Axes.CHANNEL));
        block0: for (int i = 0; i < lineWidth; ++i) {
            int n = i - lineWidth / 2;
            int new_xStart = (int)((double)line.xStart + (double)n * dy);
            int new_yStart = (int)((double)line.yStart - (double)n * dx);
            int new_xEnd = (int)((double)line.xEnd + (double)n * dy);
            int new_yEnd = (int)((double)line.yEnd - (double)n * dx);
            Line currentLine = new Line(new_xStart, new_yStart, new_xEnd, new_yEnd);
            float[] xpoints = currentLine.getInterpolatedPolygon().xpoints;
            float[] ypoints = currentLine.getInterpolatedPolygon().ypoints;
            int npoints = currentLine.getInterpolatedPolygon().npoints;
            for (int j = 0; j < npoints - 1; ++j) {
                int x = Math.round(xpoints[j]);
                int y = Math.round(ypoints[j]);
                if (j >= this.linesBuilder.getTotalLength() - this.linesBuilder.getLines().size()) continue block0;
                for (int t = 0; t < timeDimension; ++t) {
                    if (x <= 0 || x >= xDimension || y <= 0 || y >= yDimension) continue;
                    int channel = 0;
                    while (channel < channelDimension) {
                        this.datasetCursor.setPosition(x, this.dataset.dimensionIndex(Axes.X));
                        this.datasetCursor.setPosition(y, this.dataset.dimensionIndex(Axes.Y));
                        this.datasetCursor.setPosition(t, this.dataset.dimensionIndex(Axes.TIME));
                        if (this.dataset.dimensionIndex(Axes.Z) != -1) {
                            this.datasetCursor.setPosition(this.zPosition, this.dataset.dimensionIndex(Axes.Z));
                        }
                        if (this.dataset.dimensionIndex(Axes.CHANNEL) != -1) {
                            this.datasetCursor.setPosition(channel, this.dataset.dimensionIndex(Axes.CHANNEL));
                        }
                        this.kymographCursor.setPosition(new int[]{offset + j, t, i, channel++});
                        Type pixel = (Type)this.kymographCursor.get();
                        pixel.set((Type)this.datasetCursor.get());
                    }
                }
            }
        }
    }

    private void projectKymograph() {
        long xDimension = this.kymograph.dimension(this.kymograph.dimensionIndex(Axes.X));
        long yDimension = this.kymograph.dimension(this.kymograph.dimensionIndex(Axes.Y));
        long channelDimension = this.kymograph.dimension(this.kymograph.dimensionIndex(Axes.CHANNEL));
        long[] dimensions = new long[]{xDimension, yDimension, channelDimension};
        AxisType[] axisTypes = new AxisType[]{Axes.X, Axes.Y, Axes.CHANNEL};
        String title = this.dataset.getName() + " (Projected Kymograph)";
        this.projectedKymograph = this.dsService.create(dimensions, title, axisTypes, this.dataset.getValidBits(), this.dataset.isSigned(), !this.dataset.isInteger());
        CalibratedAxis positionAxis = ((CalibratedAxis)this.dataset.axis(this.dataset.dimensionIndex(Axes.X))).copy();
        this.projectedKymograph.setAxis((Axis)positionAxis, 0);
        DefaultLinearAxis timAxis = new DefaultLinearAxis(Axes.Y, ((CalibratedAxis)this.dataset.axis(this.dataset.dimensionIndex(Axes.TIME))).calibratedValue(1.0));
        this.projectedKymograph.setAxis((Axis)timAxis, 1);
        UnaryComputerOp maxOp = (UnaryComputerOp)this.opService.op(Ops.Stats.Max.class, new Object[]{this.kymograph.getImgPlus().getImg()});
        this.opService.transform().project((IterableInterval)this.projectedKymograph.getImgPlus().getImg(), (RandomAccessibleInterval)this.kymograph.getImgPlus(), maxOp, this.kymograph.dimensionIndex(Axes.Z));
    }
}

