/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.UIResource;
import org.jhotdraw.gui.plaf.palette.PaletteLazyActionMap;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;
import org.jhotdraw.gui.plaf.palette.PaletteToolBarBorder;

public class PaletteToolBarUI
extends ToolBarUI
implements SwingConstants {
    private static final boolean isFloatingAllowed = false;
    protected JToolBar toolBar;
    private boolean floating;
    private int floatingX;
    private int floatingY;
    private JFrame floatingFrame;
    @Nullable
    private RootPaneContainer floatingToolBar;
    @Nullable
    protected DragWindow dragWindow;
    @Nullable
    private Container dockingSource;
    private int dockingSensitivity = 0;
    protected int focusedCompIndex = -1;
    @Nullable
    protected Color dockingColor = null;
    @Nullable
    protected Color floatingColor = null;
    @Nullable
    protected Color dockingBorderColor = null;
    @Nullable
    protected Color floatingBorderColor = null;
    @Nullable
    protected MouseInputListener dockingListener;
    @Nullable
    protected PropertyChangeListener propertyListener;
    @Nullable
    protected ContainerListener toolBarContListener;
    @Nullable
    protected FocusListener toolBarFocusListener;
    @Nullable
    private Handler handler;
    protected Integer constraintBeforeFloating = 0;
    private static String IS_ROLLOVER = "JToolBar.isRollover";
    static String IS_DIVIDER_DRAWN = "Palette.ToolBar.isDividerDrawn";
    public static final String TOOLBAR_ICON_PROPERTY = "Palette.ToolBar.icon";
    public static final String TOOLBAR_TEXT_ICON_GAP_PROPERTY = "Palette.ToolBar.textIconGap";
    public static final String TOOLBAR_INSETS_OVERRIDE_PROPERTY = "Palette.ToolBar.insetsOverride";
    private static Border rolloverBorder;
    private static Border nonRolloverBorder;
    private static Border nonRolloverToggleBorder;
    private boolean rolloverBorders = false;
    private HashMap<AbstractButton, Border> borderTable = new HashMap();
    private Hashtable<AbstractButton, Boolean> rolloverTable = new Hashtable();
    @Deprecated
    protected KeyStroke upKey;
    @Deprecated
    protected KeyStroke downKey;
    @Deprecated
    protected KeyStroke leftKey;
    @Deprecated
    protected KeyStroke rightKey;
    private static String FOCUSED_COMP_INDEX;

    public static ComponentUI createUI(JComponent c) {
        return new PaletteToolBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.toolBar = (JToolBar)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
        this.dockingSensitivity = 0;
        this.floating = false;
        this.floatingY = 0;
        this.floatingX = 0;
        this.floatingToolBar = null;
        this.setOrientation(this.toolBar.getOrientation());
        LookAndFeel.installProperty(c, "opaque", Boolean.TRUE);
        if (c.getClientProperty(FOCUSED_COMP_INDEX) != null) {
            this.focusedCompIndex = (Integer)c.getClientProperty(FOCUSED_COMP_INDEX);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        if (this.isFloating()) {
            this.setFloating(false, null);
        }
        this.floatingToolBar = null;
        this.dragWindow = null;
        this.dockingSource = null;
        c.putClientProperty(FOCUSED_COMP_INDEX, this.focusedCompIndex);
    }

    protected void installDefaults() {
        Object rolloverProp;
        PaletteLookAndFeel.installBorder(this.toolBar, "ToolBar.border");
        PaletteLookAndFeel.installColorsAndFont(this.toolBar, "ToolBar.background", "ToolBar.foreground", "ToolBar.font");
        if (this.dockingColor == null || this.dockingColor instanceof UIResource) {
            this.dockingColor = UIManager.getColor("ToolBar.dockingBackground");
        }
        if (this.floatingColor == null || this.floatingColor instanceof UIResource) {
            this.floatingColor = UIManager.getColor("ToolBar.floatingBackground");
        }
        if (this.dockingBorderColor == null || this.dockingBorderColor instanceof UIResource) {
            this.dockingBorderColor = UIManager.getColor("ToolBar.dockingForeground");
        }
        if (this.floatingBorderColor == null || this.floatingBorderColor instanceof UIResource) {
            this.floatingBorderColor = UIManager.getColor("ToolBar.floatingForeground");
        }
        if ((rolloverProp = this.toolBar.getClientProperty(IS_ROLLOVER)) == null) {
            rolloverProp = UIManager.get("ToolBar.isRollover");
        }
        if (rolloverProp != null) {
            this.rolloverBorders = (Boolean)rolloverProp;
        }
        if (rolloverBorder == null) {
            rolloverBorder = this.createRolloverBorder();
        }
        if (nonRolloverBorder == null) {
            nonRolloverBorder = this.createNonRolloverBorder();
        }
        if (nonRolloverToggleBorder == null) {
            nonRolloverToggleBorder = this.createNonRolloverToggleBorder();
        }
        this.setRolloverBorders(this.isRolloverBorders());
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.toolBar);
        this.dockingColor = null;
        this.floatingColor = null;
        this.dockingBorderColor = null;
        this.floatingBorderColor = null;
        this.installNormalBorders(this.toolBar);
        rolloverBorder = null;
        nonRolloverBorder = null;
        nonRolloverToggleBorder = null;
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installListeners() {
        this.dockingListener = this.createDockingListener();
        if (this.dockingListener != null) {
            this.toolBar.addMouseMotionListener(this.dockingListener);
            this.toolBar.addMouseListener(this.dockingListener);
        }
        this.propertyListener = this.createPropertyListener();
        if (this.propertyListener != null) {
            this.toolBar.addPropertyChangeListener(this.propertyListener);
        }
        this.toolBarContListener = this.createToolBarContListener();
        if (this.toolBarContListener != null) {
            this.toolBar.addContainerListener(this.toolBarContListener);
        }
        this.toolBarFocusListener = this.createToolBarFocusListener();
        if (this.toolBarFocusListener != null) {
            Component[] components = this.toolBar.getComponents();
            for (int i = 0; i < components.length; ++i) {
                components[i].addFocusListener(this.toolBarFocusListener);
            }
        }
    }

    protected void uninstallListeners() {
        if (this.dockingListener != null) {
            this.toolBar.removeMouseMotionListener(this.dockingListener);
            this.toolBar.removeMouseListener(this.dockingListener);
            this.dockingListener = null;
        }
        if (this.propertyListener != null) {
            this.toolBar.removePropertyChangeListener(this.propertyListener);
            this.propertyListener = null;
        }
        if (this.toolBarContListener != null) {
            this.toolBar.removeContainerListener(this.toolBarContListener);
            this.toolBarContListener = null;
        }
        if (this.toolBarFocusListener != null) {
            Component[] components = this.toolBar.getComponents();
            for (int i = 0; i < components.length; ++i) {
                components[i].removeFocusListener(this.toolBarFocusListener);
            }
            this.toolBarFocusListener = null;
        }
        this.handler = null;
    }

    protected void installKeyboardActions() {
        InputMap km = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, km);
        PaletteLazyActionMap.installLazyActionMap(this.toolBar, PaletteToolBarUI.class, "ToolBar.actionMap");
    }

    @Nullable
    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)PaletteLookAndFeel.getInstance().get("ToolBar.ancestorInputMap");
        }
        return null;
    }

    static void loadActionMap(PaletteLazyActionMap map) {
        map.put(new Actions("navigateRight"));
        map.put(new Actions("navigateLeft"));
        map.put(new Actions("navigateUp"));
        map.put(new Actions("navigateDown"));
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.toolBar, null);
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, null);
    }

    protected void navigateFocusedComp(int direction) {
        int nComp = this.toolBar.getComponentCount();
        block0 : switch (direction) {
            case 3: 
            case 5: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= nComp) break;
                int j = this.focusedCompIndex + 1;
                while (j != this.focusedCompIndex) {
                    Component comp;
                    if (j >= nComp) {
                        j = 0;
                    }
                    if ((comp = this.toolBar.getComponentAtIndex(j++)) == null || !comp.isFocusable() || !comp.isEnabled()) continue;
                    comp.requestFocus();
                    break block0;
                }
                break;
            }
            case 1: 
            case 7: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= nComp) break;
                int j = this.focusedCompIndex - 1;
                while (j != this.focusedCompIndex) {
                    Component comp;
                    if (j < 0) {
                        j = nComp - 1;
                    }
                    if ((comp = this.toolBar.getComponentAtIndex(j--)) == null || !comp.isFocusable() || !comp.isEnabled()) continue;
                    comp.requestFocus();
                    break block0;
                }
                break;
            }
        }
    }

    protected Border createRolloverBorder() {
        Object border = UIManager.get("ToolBar.rolloverBorder");
        if (border != null) {
            return (Border)border;
        }
        return new EmptyBorder(0, 0, 0, 0);
    }

    protected Border createNonRolloverBorder() {
        Object border = UIManager.get("ToolBar.nonrolloverBorder");
        if (border != null) {
            return (Border)border;
        }
        return new EmptyBorder(0, 0, 0, 0);
    }

    private Border createNonRolloverToggleBorder() {
        return new EmptyBorder(0, 0, 0, 0);
    }

    protected JFrame createFloatingFrame(JToolBar toolbar) {
        Window window = SwingUtilities.getWindowAncestor(toolbar);
        JFrame frame = new JFrame(toolbar.getName(), window != null ? window.getGraphicsConfiguration() : null){

            @Override
            protected JRootPane createRootPane() {
                JRootPane rootPane = new JRootPane(){
                    private boolean packing = false;

                    @Override
                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.pack();
                            this.packing = false;
                        }
                    }
                };
                rootPane.setOpaque(true);
                return rootPane;
            }
        };
        frame.getRootPane().setName("ToolBar.FloatingFrame");
        frame.setResizable(false);
        WindowListener wl = this.createFrameListener();
        frame.addWindowListener(wl);
        return frame;
    }

    protected RootPaneContainer createFloatingWindow(JToolBar toolbar) {
        Window window = SwingUtilities.getWindowAncestor(toolbar);
        class ToolBarDialog
        extends JDialog {
            public ToolBarDialog(Frame owner, String title, boolean modal) {
                super(owner, title, modal);
            }

            public ToolBarDialog(Dialog owner, String title, boolean modal) {
                super(owner, title, modal);
            }

            @Override
            protected JRootPane createRootPane() {
                JRootPane rootPane = new JRootPane(){
                    private boolean packing = false;

                    @Override
                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.pack();
                            this.packing = false;
                        }
                    }
                };
                rootPane.setOpaque(true);
                return rootPane;
            }
        }
        ToolBarDialog dialog = window instanceof Frame ? new ToolBarDialog((Frame)window, toolbar.getName(), false) : (window instanceof Dialog ? new ToolBarDialog((Dialog)window, toolbar.getName(), false) : new ToolBarDialog((Frame)null, toolbar.getName(), false));
        dialog.getRootPane().setName("ToolBar.FloatingWindow");
        dialog.setTitle(toolbar.getName());
        dialog.setResizable(false);
        WindowListener wl = this.createFrameListener();
        dialog.addWindowListener(wl);
        return dialog;
    }

    protected DragWindow createDragWindow(JToolBar toolbar) {
        Window frame = null;
        if (this.toolBar != null) {
            Container p;
            for (p = this.toolBar.getParent(); p != null && !(p instanceof Window); p = p.getParent()) {
            }
            frame = (Window)p;
        }
        if (this.floatingToolBar == null) {
            this.floatingToolBar = this.createFloatingWindow(this.toolBar);
        }
        if (this.floatingToolBar instanceof Window) {
            frame = (Window)((Object)this.floatingToolBar);
        }
        DragWindow w = new DragWindow(frame);
        JRootPane rp = w.getRootPane();
        rp.putClientProperty("Window.alpha", new Float(0.6f));
        return w;
    }

    public boolean isRolloverBorders() {
        return this.rolloverBorders;
    }

    public void setRolloverBorders(boolean rollover) {
        this.rolloverBorders = rollover;
        if (this.rolloverBorders) {
            this.installRolloverBorders(this.toolBar);
        } else {
            this.installNonRolloverBorders(this.toolBar);
        }
    }

    protected void installRolloverBorders(JComponent c) {
        Component[] components = c.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JComponent)) continue;
            ((JComponent)components[i]).updateUI();
            this.setBorderToRollover(components[i]);
        }
    }

    protected void installNonRolloverBorders(JComponent c) {
        Component[] components = c.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JComponent)) continue;
            ((JComponent)components[i]).updateUI();
            this.setBorderToNonRollover(components[i]);
        }
    }

    protected void installNormalBorders(JComponent c) {
        Component[] components = c.getComponents();
        for (int i = 0; i < components.length; ++i) {
            this.setBorderToNormal(components[i]);
        }
    }

    protected void setBorderToRollover(Component c) {
    }

    @Nullable
    private Border getRolloverBorder(AbstractButton b) {
        Object borderProvider = UIManager.get("ToolBar.rolloverBorderProvider");
        if (borderProvider == null) {
            return rolloverBorder;
        }
        return null;
    }

    protected void setBorderToNonRollover(Component c) {
    }

    protected void setBorderToNormal(Component c) {
    }

    public void setFloatingLocation(int x, int y) {
        this.floatingX = x;
        this.floatingY = y;
    }

    public boolean isFloating() {
        return this.floating;
    }

    public void setFloating(boolean b, @Nullable Point p) {
        if (this.toolBar.isFloatable()) {
            if (this.dragWindow != null) {
                this.dragWindow.setVisible(false);
            }
            this.floating = b;
            if (b) {
                // empty if block
            }
            if (this.floatingToolBar == null) {
                this.floatingToolBar = this.createFloatingWindow(this.toolBar);
            }
            if (this.floatingToolBar instanceof Window) {
                ((Window)((Object)this.floatingToolBar)).setVisible(false);
            }
            this.floatingToolBar.getContentPane().remove(this.toolBar);
            Integer constraint = this.getDockingConstraint(this.dockingSource, p);
            if (constraint == null) {
                constraint = 0;
            }
            int orientation = this.mapConstraintToOrientation(constraint);
            this.setOrientation(orientation);
            if (this.dockingSource == null) {
                this.dockingSource = this.toolBar.getParent();
            }
            if (this.propertyListener != null) {
                UIManager.removePropertyChangeListener(this.propertyListener);
            }
            this.dockingSource.add((Component)this.toolBar, constraint);
            this.dockingSource.invalidate();
            Container dockingSourceParent = this.dockingSource.getParent();
            if (dockingSourceParent != null) {
                dockingSourceParent.validate();
            }
            this.dockingSource.repaint();
        }
    }

    private int mapConstraintToOrientation(Object constraint) {
        int orientation = this.toolBar.getOrientation();
        if (constraint != null) {
            if (constraint.equals("East") || constraint.equals("West")) {
                orientation = 1;
            } else if (constraint.equals("North") || constraint.equals("South")) {
                orientation = 0;
            }
        }
        return orientation;
    }

    public void setOrientation(int orientation) {
        this.toolBar.setOrientation(orientation);
        if (this.dragWindow != null) {
            this.dragWindow.setOrientation(orientation);
        }
    }

    public Color getDockingColor() {
        return this.dockingColor;
    }

    public void setDockingColor(Color c) {
        this.dockingColor = c;
    }

    public Color getFloatingColor() {
        return this.floatingColor;
    }

    public void setFloatingColor(Color c) {
        this.floatingColor = c;
    }

    private boolean isBlocked(Component comp, Object constraint) {
        Container cont;
        LayoutManager lm;
        if (comp instanceof Container && (lm = (cont = (Container)comp).getLayout()) instanceof BorderLayout) {
            BorderLayout blm = (BorderLayout)lm;
            Component c = blm.getLayoutComponent(cont, constraint);
            return c != null && c != this.toolBar;
        }
        return false;
    }

    public boolean canDock(Component c, Point p) {
        return p != null && this.getDockingConstraint(c, p) != null;
    }

    private Integer calculateConstraint() {
        Integer constraint = null;
        LayoutManager lm = this.dockingSource.getLayout();
        if (lm instanceof BoxLayout) {
            int n = this.dockingSource.getComponentCount();
            for (int i = 0; i < n; ++i) {
                if (this.dockingSource.getComponent(i) != this.toolBar) continue;
                constraint = i;
                break;
            }
        }
        return constraint != null ? constraint : this.constraintBeforeFloating;
    }

    @Nullable
    private Integer getDockingConstraint(Component c, Point p) {
        if (p == null) {
            return this.constraintBeforeFloating;
        }
        if (c.contains(p)) {
            int n = this.dockingSource.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Point childP;
                Component child = this.dockingSource.getComponent(i);
                if (!child.contains(childP = new Point(p.x - child.getX(), p.y - child.getY()))) continue;
                return Math.min(n - 1, childP.x <= child.getWidth() ? i : i + 1);
            }
            if (this.dockingSource.getComponentCount() == 0 || p.x < this.dockingSource.getComponent(0).getX()) {
                return 0;
            }
            return this.dockingSource.getComponentCount() - 1;
        }
        return null;
    }

    protected void dragTo(Point position, Point origin) {
        if (this.toolBar.isFloatable()) {
            try {
                Point offset;
                if (this.dragWindow == null) {
                    this.dragWindow = this.createDragWindow(this.toolBar);
                }
                if ((offset = this.dragWindow.getOffset()) == null) {
                    Dimension size = this.toolBar.getSize();
                    offset = new Point(size.width / 2, size.height / 2);
                    this.dragWindow.setOffset(offset);
                }
                Point global = new Point(origin.x + position.x, origin.y + position.y);
                Point dragPoint = new Point(global.x - offset.x, global.y - offset.y);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                this.constraintBeforeFloating = this.calculateConstraint();
                Point dockingPosition = this.dockingSource.getLocationOnScreen();
                Point comparisonPoint = new Point(global.x - dockingPosition.x, global.y - dockingPosition.y);
                if (this.canDock(this.dockingSource, comparisonPoint)) {
                    this.dragWindow.setBackground(this.getDockingColor());
                    Integer constraint = this.getDockingConstraint(this.dockingSource, comparisonPoint);
                    int orientation = this.mapConstraintToOrientation(constraint);
                    this.dragWindow.setOrientation(orientation);
                    this.dragWindow.setBorderColor(this.dockingBorderColor);
                } else {
                    this.dragWindow.setBackground(this.getFloatingColor());
                    this.dragWindow.setBorderColor(this.floatingBorderColor);
                }
                this.dragWindow.setLocation(dragPoint.x, dragPoint.y);
                if (!this.dragWindow.isVisible()) {
                    Dimension size = this.toolBar.getSize();
                    this.dragWindow.setSize(size.width, size.height);
                    this.dragWindow.setVisible(true);
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    protected void floatAt(Point position, Point origin) {
        if (this.toolBar.isFloatable()) {
            try {
                Point offset = this.dragWindow.getOffset();
                if (offset == null) {
                    offset = position;
                    this.dragWindow.setOffset(offset);
                }
                Point global = new Point(origin.x + position.x, origin.y + position.y);
                this.setFloatingLocation(global.x - offset.x, global.y - offset.y);
                if (this.dockingSource != null) {
                    Point dockingPosition = this.dockingSource.getLocationOnScreen();
                    Point comparisonPoint = new Point(global.x - dockingPosition.x, global.y - dockingPosition.y);
                    if (this.canDock(this.dockingSource, comparisonPoint)) {
                        this.setFloating(false, comparisonPoint);
                    } else {
                        this.setFloating(true, null);
                    }
                } else {
                    this.setFloating(true, null);
                }
                this.dragWindow.setOffset(null);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected ContainerListener createToolBarContListener() {
        return this.getHandler();
    }

    protected FocusListener createToolBarFocusListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyListener() {
        return this.getHandler();
    }

    protected MouseInputListener createDockingListener() {
        this.getHandler().tb = this.toolBar;
        return this.getHandler();
    }

    protected WindowListener createFrameListener() {
        return new FrameListener();
    }

    protected void paintDragWindow(Graphics g) {
        int w = this.dragWindow.getWidth();
        int h = this.dragWindow.getHeight();
        g.setColor(this.dragWindow.getBackground());
        g.fillRect(0, 0, w, h);
        boolean wasDoubleBuffered = false;
        if (this.toolBar.isDoubleBuffered()) {
            wasDoubleBuffered = true;
            this.toolBar.setDoubleBuffered(false);
        }
        Graphics g2 = g.create();
        this.toolBar.paintAll(g2);
        g2.dispose();
        g.setColor(this.dragWindow.getBorderColor());
        g.drawRect(0, 0, w - 1, h - 1);
        if (wasDoubleBuffered) {
            this.toolBar.setDoubleBuffered(true);
        }
    }

    static {
        FOCUSED_COMP_INDEX = "JToolBar.focusedCompIndex";
    }

    protected class DragWindow
    extends JWindow {
        Color borderColor;
        int orientation;
        @Nullable
        Point offset;

        DragWindow(Window w) {
            super(w);
            this.borderColor = Color.gray;
            this.orientation = PaletteToolBarUI.this.toolBar.getOrientation();
            this.getContentPane().add(new JPanel(){

                @Override
                public void paintComponent(Graphics g) {
                    PaletteToolBarUI.this.paintDragWindow(g);
                }
            });
        }

        public void setOrientation(int o) {
            if (this.isShowing()) {
                if (o == this.orientation) {
                    return;
                }
                this.orientation = o;
                Dimension size = this.getSize();
                this.setSize(new Dimension(size.height, size.width));
                if (this.offset != null) {
                    if (PaletteToolBarUI.this.toolBar.getComponentOrientation().isLeftToRight()) {
                        this.setOffset(new Point(this.offset.y, this.offset.x));
                    } else if (o == 0) {
                        this.setOffset(new Point(size.height - this.offset.y, this.offset.x));
                    } else {
                        this.setOffset(new Point(this.offset.y, size.width - this.offset.x));
                    }
                }
                this.repaint();
            }
        }

        @Nullable
        public Point getOffset() {
            return this.offset;
        }

        public void setOffset(@Nullable Point p) {
            this.offset = p;
        }

        public void setBorderColor(Color c) {
            if (this.borderColor == c) {
                return;
            }
            this.borderColor = c;
            this.repaint();
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        @Override
        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }
    }

    public class DockingListener
    implements MouseInputListener {
        protected JToolBar toolBar;
        protected boolean isDragging = false;
        @Nullable
        protected Point origin = null;

        public DockingListener(JToolBar t) {
            this.toolBar = t;
            ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().tb = t;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PaletteToolBarUI.this.getHandler().mouseClicked(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().tb = this.toolBar;
            PaletteToolBarUI.this.getHandler().mousePressed(e);
            this.isDragging = ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().isDragging;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().tb = this.toolBar;
            ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().isDragging = this.isDragging;
            ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().origin = this.origin;
            PaletteToolBarUI.this.getHandler().mouseReleased(e);
            this.isDragging = ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().isDragging;
            this.origin = ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().origin;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            PaletteToolBarUI.this.getHandler().mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            PaletteToolBarUI.this.getHandler().mouseExited(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().tb = this.toolBar;
            ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().origin = this.origin;
            PaletteToolBarUI.this.getHandler().mouseDragged(e);
            this.isDragging = ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().isDragging;
            this.origin = ((PaletteToolBarUI)PaletteToolBarUI.this).getHandler().origin;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            PaletteToolBarUI.this.getHandler().mouseMoved(e);
        }
    }

    protected class PropertyListener
    implements PropertyChangeListener {
        protected PropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            PaletteToolBarUI.this.getHandler().propertyChange(e);
        }
    }

    protected class ToolBarFocusListener
    implements FocusListener {
        protected ToolBarFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            PaletteToolBarUI.this.getHandler().focusGained(e);
        }

        @Override
        public void focusLost(FocusEvent e) {
            PaletteToolBarUI.this.getHandler().focusLost(e);
        }
    }

    protected class ToolBarContListener
    implements ContainerListener {
        protected ToolBarContListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            PaletteToolBarUI.this.getHandler().componentAdded(e);
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            PaletteToolBarUI.this.getHandler().componentRemoved(e);
        }
    }

    protected class FrameListener
    extends WindowAdapter {
        protected FrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent w) {
            if (PaletteToolBarUI.this.toolBar.isFloatable()) {
                if (PaletteToolBarUI.this.dragWindow != null) {
                    PaletteToolBarUI.this.dragWindow.setVisible(false);
                }
                PaletteToolBarUI.this.floating = false;
                if (PaletteToolBarUI.this.floatingToolBar == null) {
                    PaletteToolBarUI.this.floatingToolBar = PaletteToolBarUI.this.createFloatingWindow(PaletteToolBarUI.this.toolBar);
                }
                if (PaletteToolBarUI.this.floatingToolBar instanceof Window) {
                    ((Window)((Object)PaletteToolBarUI.this.floatingToolBar)).setVisible(false);
                }
                PaletteToolBarUI.this.floatingToolBar.getContentPane().remove(PaletteToolBarUI.this.toolBar);
                Integer constraint = PaletteToolBarUI.this.constraintBeforeFloating;
                if (PaletteToolBarUI.this.dockingSource == null) {
                    PaletteToolBarUI.this.dockingSource = PaletteToolBarUI.this.toolBar.getParent();
                }
                if (PaletteToolBarUI.this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(PaletteToolBarUI.this.propertyListener);
                }
                PaletteToolBarUI.this.dockingSource.add((Component)PaletteToolBarUI.this.toolBar, constraint);
                PaletteToolBarUI.this.dockingSource.invalidate();
                Container dockingSourceParent = PaletteToolBarUI.this.dockingSource.getParent();
                if (dockingSourceParent != null) {
                    dockingSourceParent.validate();
                }
                PaletteToolBarUI.this.dockingSource.repaint();
            }
        }
    }

    private class Handler
    implements ContainerListener,
    FocusListener,
    MouseInputListener,
    PropertyChangeListener {
        JToolBar tb;
        boolean isDragging = false;
        @Nullable
        Point origin = null;
        boolean isArmed = false;

        private Handler() {
        }

        @Override
        public void componentAdded(ContainerEvent evt) {
            Component c = evt.getChild();
            if (PaletteToolBarUI.this.toolBarFocusListener != null) {
                c.addFocusListener(PaletteToolBarUI.this.toolBarFocusListener);
            }
            if (PaletteToolBarUI.this.isRolloverBorders()) {
                PaletteToolBarUI.this.setBorderToRollover(c);
            } else {
                PaletteToolBarUI.this.setBorderToNonRollover(c);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent evt) {
            Component c = evt.getChild();
            if (PaletteToolBarUI.this.toolBarFocusListener != null) {
                c.removeFocusListener(PaletteToolBarUI.this.toolBarFocusListener);
            }
            PaletteToolBarUI.this.setBorderToNormal(c);
        }

        @Override
        public void focusGained(FocusEvent evt) {
            Component c = evt.getComponent();
            PaletteToolBarUI.this.focusedCompIndex = PaletteToolBarUI.this.toolBar.getComponentIndex(c);
        }

        @Override
        public void focusLost(FocusEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (!this.tb.isEnabled()) {
                return;
            }
            this.isDragging = false;
            if (evt.getSource() instanceof JToolBar) {
                JComponent c = (JComponent)evt.getSource();
                Insets insets = c.getBorder() instanceof PaletteToolBarBorder ? ((PaletteToolBarBorder)c.getBorder()).getDragInsets(c) : c.getInsets();
                this.isArmed = evt.getX() <= insets.left || evt.getX() >= c.getWidth() - insets.right || evt.getY() <= insets.top || evt.getY() >= c.getHeight() - insets.bottom;
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (!this.tb.isEnabled()) {
                return;
            }
            if (this.isDragging) {
                Point position = evt.getPoint();
                if (this.origin == null) {
                    this.origin = evt.getComponent().getLocationOnScreen();
                }
                PaletteToolBarUI.this.floatAt(position, this.origin);
            }
            this.origin = null;
            this.isDragging = false;
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (!this.tb.isEnabled()) {
                return;
            }
            if (!this.isArmed) {
                return;
            }
            this.isDragging = true;
            Point position = evt.getPoint();
            if (this.origin == null) {
                this.origin = evt.getComponent().getLocationOnScreen();
            }
            PaletteToolBarUI.this.dragTo(position, this.origin);
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName == "lookAndFeel") {
                PaletteToolBarUI.this.toolBar.updateUI();
            } else if (propertyName == "orientation") {
                Component[] components = PaletteToolBarUI.this.toolBar.getComponents();
                int orientation = (Integer)evt.getNewValue();
                for (int i = 0; i < components.length; ++i) {
                    if (!(components[i] instanceof JToolBar.Separator)) continue;
                    JToolBar.Separator separator = (JToolBar.Separator)components[i];
                    if (orientation == 0) {
                        separator.setOrientation(1);
                    } else {
                        separator.setOrientation(0);
                    }
                    Dimension size = separator.getSeparatorSize();
                    if (size == null || size.width == size.height) continue;
                    Dimension newSize = new Dimension(size.height, size.width);
                    separator.setSeparatorSize(newSize);
                }
            } else if (propertyName == IS_ROLLOVER) {
                PaletteToolBarUI.this.installNormalBorders(PaletteToolBarUI.this.toolBar);
                PaletteToolBarUI.this.setRolloverBorders((Boolean)evt.getNewValue());
            }
        }
    }

    private static class Actions
    extends AbstractAction {
        private static final String NAVIGATE_RIGHT = "navigateRight";
        private static final String NAVIGATE_LEFT = "navigateLeft";
        private static final String NAVIGATE_UP = "navigateUp";
        private static final String NAVIGATE_DOWN = "navigateDown";

        public Actions(String name) {
            super(name);
        }

        public String getName() {
            return (String)this.getValue("Name");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String key = this.getName();
            JToolBar toolBar = (JToolBar)evt.getSource();
            PaletteToolBarUI ui = (PaletteToolBarUI)PaletteLookAndFeel.getUIOfType(toolBar.getUI(), PaletteToolBarUI.class);
            if (NAVIGATE_RIGHT == key) {
                ui.navigateFocusedComp(3);
            } else if (NAVIGATE_LEFT == key) {
                ui.navigateFocusedComp(7);
            } else if (NAVIGATE_UP == key) {
                ui.navigateFocusedComp(1);
            } else if (NAVIGATE_DOWN == key) {
                ui.navigateFocusedComp(5);
            }
        }
    }
}

