/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation.utils;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;

public final class PrincipalComponentAnalysis {
    private PrincipalComponentAnalysis() throws InstantiationException {
        throw new InstantiationException("This class is not created for instantiation");
    }

    public static ImagePlus getPrincipalComponents(ImagePlus inputImage, int patchSize, int step) {
        int maxX = inputImage.getWidth() - patchSize;
        int maxY = inputImage.getHeight() - patchSize;
        int matrixHeight = patchSize * patchSize;
        int matrixWidth = (maxX / step + 1) * (maxY / step + 1) * inputImage.getImageStackSize();
        double[][] matrix = new double[matrixWidth][matrixHeight];
        int n = 0;
        for (int i = 1; i <= inputImage.getImageStack().getSize(); ++i) {
            ImageProcessor ip = inputImage.getImageStack().getProcessor(i).convertToFloat();
            for (int j = 0; j < maxX; j += step) {
                for (int k = 0; k < maxY; k += step) {
                    Roi roi = new Roi(j, k, patchSize, patchSize);
                    ip.setRoi(roi);
                    ImageProcessor patch = ip.crop();
                    float[] pixels = (float[])patch.getPixels();
                    for (int l = 0; l < matrixHeight; ++l) {
                        matrix[n][l] = pixels[l];
                    }
                    ++n;
                }
            }
        }
        Array2DRowRealMatrix m = new Array2DRowRealMatrix(matrix);
        long start = System.currentTimeMillis();
        SingularValueDecomposition svd = new SingularValueDecomposition((RealMatrix)m);
        RealMatrix v = svd.getV();
        long end = System.currentTimeMillis();
        IJ.log((String)("SVD took: " + (end - start) + "ms"));
        ImageStack result = new ImageStack(patchSize, patchSize);
        for (int i = 0; i < v.getRowDimension(); ++i) {
            double[] column = new double[v.getColumnDimension()];
            for (int j = 0; j < v.getColumnDimension(); ++j) {
                column[j] = v.getEntry(j, i);
            }
            result.addSlice("PCA " + i, (ImageProcessor)new FloatProcessor(patchSize, patchSize, column));
        }
        return new ImagePlus("PCA", result);
    }
}

