/*
 * Decompiled with CFR 0.152.
 */
package imglib.ops.operation;

import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;

public class MultiImageIterator<T extends RealType<T>> {
    private Image<T>[] images;
    private int[][] origins;
    private int[][] spans;
    private RegionOfInterestCursor<T>[] cursors;

    public MultiImageIterator(Image<T>[] images) {
        this.images = images;
        int totalImages = images.length;
        this.origins = new int[totalImages][];
        this.spans = new int[totalImages][];
        for (int i = 0; i < totalImages; ++i) {
            this.origins[i] = new int[images[i].getNumDimensions()];
            this.spans[i] = (int[])images[i].getDimensions().clone();
        }
        this.cursors = new RegionOfInterestCursor[totalImages];
    }

    public void setRegion(int i, int[] origin, int[] span) {
        this.origins[i] = origin;
        this.spans[i] = span;
    }

    public RegionOfInterestCursor<T>[] getSubcursors() {
        return this.cursors;
    }

    void initialize() {
        int i;
        long totalSamples = this.numInSpan(this.spans[0]);
        for (i = 1; i < this.spans.length; ++i) {
            if (this.numInSpan(this.spans[i]) == totalSamples) continue;
            throw new IllegalArgumentException("incompatible span shapes");
        }
        for (i = 0; i < this.images.length; ++i) {
            LocalizableByDimCursor<T> dimCursor = this.images[i].createLocalizableByDimCursor();
            this.cursors[i] = new RegionOfInterestCursor<T>(dimCursor, this.origins[i], this.spans[i]);
        }
    }

    public boolean hasNext() {
        boolean hasNext = this.cursors[0].hasNext();
        for (int i = 1; i < this.cursors.length; ++i) {
            if (hasNext == this.cursors[i].hasNext()) continue;
            throw new IllegalArgumentException("linked cursors are out of sync");
        }
        return hasNext;
    }

    public void fwd() {
        for (int i = 0; i < this.cursors.length; ++i) {
            this.cursors[i].fwd();
        }
    }

    private long numInSpan(int[] span) {
        long total = 1L;
        for (int axisLen : span) {
            total *= (long)axisLen;
        }
        return total;
    }
}

