/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.fft;

import edu.mines.jtk.dsp.FftComplex;
import edu.mines.jtk.dsp.FftReal;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.fft.FFTFunctions;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorExpWindowingFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.numeric.ComplexType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.util.Util;

public class FourierTransform<T extends RealType<T>, S extends ComplexType<S>>
implements MultiThreaded,
OutputAlgorithm<S>,
Benchmark {
    final Image<T> img;
    final int numDimensions;
    Image<S> fftImage;
    PreProcessing preProcessing;
    Rearrangement rearrangement;
    FFTOptimization fftOptimization;
    float relativeImageExtensionRatio;
    int[] imageExtension;
    float relativeFadeOutDistance;
    int minExtension;
    OutOfBoundsStrategyFactory<T> strategy;
    int[] originalSize;
    int[] originalOffset;
    int[] extendedSize;
    int[] extendedZeroPaddedSize;
    int[] inputSize = null;
    int[] inputSizeOffset = null;
    final S complexType;
    String errorMessage = "";
    int numThreads;
    long processingTime;

    public FourierTransform(Image<T> image, S complexType, PreProcessing preProcessing, Rearrangement rearrangement, FFTOptimization fftOptimization, float relativeImageExtension, float relativeFadeOutDistance, int minExtension) {
        this.img = image;
        this.complexType = complexType;
        this.numDimensions = this.img.getNumDimensions();
        this.extendedSize = new int[this.numDimensions];
        this.extendedZeroPaddedSize = new int[this.numDimensions];
        this.imageExtension = new int[this.numDimensions];
        this.setPreProcessing(preProcessing);
        this.setRearrangement(rearrangement);
        this.setFFTOptimization(fftOptimization);
        this.setRelativeFadeOutDistance(relativeFadeOutDistance);
        this.setRelativeImageExtension(relativeImageExtension);
        this.setMinExtension(minExtension);
        this.setCustomOutOfBoundsStrategy(null);
        this.originalSize = image.getDimensions();
        this.originalOffset = new int[this.numDimensions];
        this.processingTime = -1L;
        this.setNumThreads();
    }

    public FourierTransform(Image<T> image, S complexType) {
        this(image, complexType, PreProcessing.EXTEND_MIRROR_FADING, Rearrangement.REARRANGE_QUADRANTS, FFTOptimization.SPEED, 0.25f, 0.25f, 12);
    }

    public FourierTransform(Image<T> image, S complexType, Rearrangement rearrangement) {
        this(image, complexType);
        this.setRearrangement(rearrangement);
    }

    public FourierTransform(Image<T> image, S complexType, FFTOptimization fftOptimization) {
        this(image, complexType);
        this.setFFTOptimization(fftOptimization);
    }

    public FourierTransform(Image<T> image, S complexType, PreProcessing preProcessing) {
        this(image, complexType);
        this.setPreProcessing(preProcessing);
    }

    public FourierTransform(Image<T> image, S complexType, OutOfBoundsStrategyFactory<T> strategy) {
        this(image, complexType);
        this.setPreProcessing(PreProcessing.USE_GIVEN_OUTOFBOUNDSSTRATEGY);
        this.setCustomOutOfBoundsStrategy(strategy);
    }

    public void setPreProcessing(PreProcessing preProcessing) {
        this.preProcessing = preProcessing;
    }

    public void setRearrangement(Rearrangement rearrangement) {
        this.rearrangement = rearrangement;
    }

    public void setFFTOptimization(FFTOptimization fftOptimization) {
        this.fftOptimization = fftOptimization;
    }

    public void setRelativeFadeOutDistance(float relativeFadeOutDistance) {
        this.relativeFadeOutDistance = relativeFadeOutDistance;
    }

    public void setCustomOutOfBoundsStrategy(OutOfBoundsStrategyFactory<T> strategy) {
        this.strategy = strategy;
    }

    public void setMinExtension(int minExtension) {
        this.minExtension = minExtension;
    }

    public void setImageExtension(int[] imageExtension) {
        this.imageExtension = (int[])imageExtension.clone();
    }

    public boolean setExtendedOriginalImageSize(int[] inputSize) {
        for (int d = 0; d < this.numDimensions; ++d) {
            if (inputSize[d] >= this.originalSize[d]) continue;
            this.errorMessage = "Cannot set extended original image size smaller than image size";
            return false;
        }
        this.inputSize = (int[])inputSize.clone();
        this.inputSizeOffset = new int[this.numDimensions];
        this.setRelativeImageExtension(this.relativeImageExtensionRatio);
        return true;
    }

    public void setRelativeImageExtension(float extensionRatio) {
        this.relativeImageExtensionRatio = extensionRatio;
        for (int d = 0; d < this.img.getNumDimensions(); ++d) {
            this.imageExtension[d] = this.inputSize == null ? Util.round((float)this.img.getDimension(d) * (1.0f + extensionRatio)) - this.img.getDimension(d) : Util.round((float)this.inputSize[d] * (1.0f + extensionRatio)) - this.img.getDimension(d);
            if (this.imageExtension[d] < this.minExtension) {
                this.imageExtension[d] = this.minExtension;
            }
            this.extendedSize[d] = this.imageExtension[d] + this.img.getDimension(d);
        }
    }

    public T getImageType() {
        return (T)((RealType)this.img.createType());
    }

    public int[] getExtendedSize() {
        return (int[])this.extendedSize.clone();
    }

    public PreProcessing getPreProcessing() {
        return this.preProcessing;
    }

    public Rearrangement getRearrangement() {
        return this.rearrangement;
    }

    public FFTOptimization getFFOptimization() {
        return this.fftOptimization;
    }

    public float getRelativeImageExtension() {
        return this.relativeImageExtensionRatio;
    }

    public int[] getImageExtension() {
        return (int[])this.imageExtension.clone();
    }

    public float getRelativeFadeOutDistance() {
        return this.relativeFadeOutDistance;
    }

    public OutOfBoundsStrategyFactory<T> getCustomOutOfBoundsStrategy() {
        return this.strategy;
    }

    public int getMinExtension() {
        return this.minExtension;
    }

    public int[] getOriginalSize() {
        return (int[])this.originalSize.clone();
    }

    public int[] getOriginalOffset() {
        return (int[])this.originalOffset.clone();
    }

    public int[] getFFTInputOffset() {
        if (this.inputSize == null) {
            return this.originalOffset;
        }
        return this.inputSizeOffset;
    }

    public int[] getFFTInputSize() {
        if (this.inputSize == null) {
            return (int[])this.originalSize.clone();
        }
        return (int[])this.inputSize.clone();
    }

    @Override
    public boolean process() {
        OutOfBoundsStrategyFactory outOfBoundsFactory;
        long startTime = System.currentTimeMillis();
        switch (this.preProcessing) {
            case USE_GIVEN_OUTOFBOUNDSSTRATEGY: {
                if (this.strategy == null) {
                    this.errorMessage = "Custom OutOfBoundsStrategyFactory is null, cannot use custom strategy";
                    return false;
                }
                this.extendedZeroPaddedSize = this.getZeroPaddingSize(this.getExtendedImageSize(this.img, this.imageExtension), this.fftOptimization);
                outOfBoundsFactory = this.strategy;
                break;
            }
            case EXTEND_MIRROR: {
                this.extendedZeroPaddedSize = this.getZeroPaddingSize(this.getExtendedImageSize(this.img, this.imageExtension), this.fftOptimization);
                outOfBoundsFactory = new OutOfBoundsStrategyMirrorFactory();
                break;
            }
            case EXTEND_MIRROR_FADING: {
                this.extendedZeroPaddedSize = this.getZeroPaddingSize(this.getExtendedImageSize(this.img, this.imageExtension), this.fftOptimization);
                outOfBoundsFactory = new OutOfBoundsStrategyMirrorExpWindowingFactory(this.relativeFadeOutDistance);
                break;
            }
            default: {
                this.extendedZeroPaddedSize = this.inputSize == null ? this.getZeroPaddingSize(this.img.getDimensions(), this.fftOptimization) : this.getZeroPaddingSize(this.inputSize, this.fftOptimization);
                outOfBoundsFactory = new OutOfBoundsStrategyValueFactory<T>(this.img.createType());
            }
        }
        this.originalOffset = new int[this.numDimensions];
        for (int d = 0; d < this.numDimensions; ++d) {
            if (this.inputSize != null) {
                this.inputSizeOffset[d] = (this.extendedZeroPaddedSize[d] - this.inputSize[d]) / 2;
            }
            this.originalOffset[d] = (this.extendedZeroPaddedSize[d] - this.img.getDimension(d)) / 2;
        }
        this.fftImage = FFTFunctions.computeFFT(this.img, this.complexType, outOfBoundsFactory, this.originalOffset, this.extendedZeroPaddedSize, this.getNumThreads(), false);
        if (this.fftImage == null) {
            this.errorMessage = "Could not compute the FFT transformation, most likely out of memory";
            return false;
        }
        if (this.rearrangement == Rearrangement.REARRANGE_QUADRANTS) {
            FFTFunctions.rearrangeFFTQuadrants(this.fftImage, true, this.getNumThreads());
        }
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    protected int[] getExtendedImageSize(Image<?> img, int[] imageExtension) {
        int[] extendedSize = new int[img.getNumDimensions()];
        for (int d = 0; d < img.getNumDimensions(); ++d) {
            extendedSize[d] = imageExtension[d] + img.getDimension(d);
        }
        return extendedSize;
    }

    protected int[] getZeroPaddingSize(int[] imageSize, FFTOptimization fftOptimization) {
        int[] fftSize = new int[imageSize.length];
        fftSize[0] = fftOptimization == FFTOptimization.SPEED ? FftReal.nfftFast((int)imageSize[0]) : FftReal.nfftSmall((int)imageSize[0]);
        for (int d = 1; d < fftSize.length; ++d) {
            fftSize[d] = fftOptimization == FFTOptimization.SPEED ? FftComplex.nfftFast((int)imageSize[d]) : FftComplex.nfftSmall((int)imageSize[d]);
        }
        return fftSize;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    @Override
    public Image<S> getResult() {
        return this.fftImage;
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.img == null) {
            this.errorMessage = "Input image is null";
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static enum FFTOptimization {
        SPEED,
        MEMORY;

    }

    public static enum Rearrangement {
        REARRANGE_QUADRANTS,
        UNCHANGED;

    }

    public static enum PreProcessing {
        NONE,
        EXTEND_MIRROR,
        EXTEND_MIRROR_FADING,
        USE_GIVEN_OUTOFBOUNDSSTRATEGY;

    }
}

