/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.fft;

import mpicbg.imglib.algorithm.fft.FourierConvolution;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.complex.ComplexFloatType;

public class InverseFourierConvolution<T extends RealType<T>, S extends RealType<S>>
extends FourierConvolution<T, S> {
    public InverseFourierConvolution(Image<T> image, Image<S> kernel) {
        super(image, kernel);
    }

    @Override
    protected void multiply(Image<ComplexFloatType> a, Image<ComplexFloatType> b) {
        Cursor<ComplexFloatType> cursorA = a.createCursor();
        Cursor<ComplexFloatType> cursorB = b.createCursor();
        while (cursorA.hasNext()) {
            cursorA.fwd();
            cursorB.fwd();
            cursorA.getType().div(cursorB.getType());
        }
        cursorA.close();
        cursorB.close();
    }
}

