/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.transformation;

import java.util.ArrayList;
import mpicbg.imglib.algorithm.transformation.HoughTransform;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.integer.IntType;
import mpicbg.imglib.type.numeric.integer.LongType;
import mpicbg.imglib.type.numeric.integer.ShortType;
import mpicbg.imglib.util.Util;

public class HoughLineTransform<S extends RealType<S>, T extends Type<T> & Comparable<T>>
extends HoughTransform<S, T> {
    public static final int DEFAULT_THETA = 180;
    public final double dTheta;
    public final double dRho;
    private final T threshold;
    private final int nRho;
    private final int nTheta;
    private final double[] rho;
    private final double[] theta;
    private ArrayList<double[]> rtPeaks;

    public static int defaultRho(Image<?> inputImage) {
        return (int)(2.0f * Util.computeLength(inputImage.getDimensions()));
    }

    public static <T extends Type<T> & Comparable<T>> HoughLineTransform<ShortType, T> shortHoughLine(Image<T> inputImage) {
        return new HoughLineTransform<ShortType, T>(inputImage, new ShortType());
    }

    public static <T extends Type<T> & Comparable<T>> HoughLineTransform<IntType, T> integerHoughLine(Image<T> inputImage) {
        return new HoughLineTransform<IntType, T>(inputImage, new IntType());
    }

    public static <T extends Type<T> & Comparable<T>> HoughLineTransform<LongType, T> longHoughLine(Image<T> inputImage) {
        return new HoughLineTransform<LongType, T>(inputImage, new LongType());
    }

    public HoughLineTransform(Image<T> inputImage, S type) {
        this(inputImage, 180, type);
    }

    public HoughLineTransform(Image<T> inputImage, int theta, S type) {
        this(inputImage, HoughLineTransform.defaultRho(inputImage), 180, type);
    }

    public HoughLineTransform(Image<T> inputImage, int inNRho, int inNTheta, S type) {
        super(inputImage, new int[]{inNRho, inNTheta}, type);
        this.dTheta = Math.PI / (double)inNTheta;
        this.dRho = (double)(2.0f * Util.computeLength(inputImage.getDimensions())) / (double)inNRho;
        this.threshold = inputImage.createType();
        this.nRho = inNRho;
        this.nTheta = inNTheta;
        this.theta = new double[inNTheta];
        this.rho = new double[inNRho];
        this.rtPeaks = null;
    }

    public HoughLineTransform(Image<T> inputImage, ImageFactory<S> factory, int inNRho, int inNTheta) {
        super(inputImage, new int[]{inNRho, inNTheta}, factory);
        this.dTheta = Math.PI / (double)inNTheta;
        this.dRho = (double)(2.0f * Util.computeLength(inputImage.getDimensions())) / (double)inNRho;
        this.threshold = inputImage.createType();
        this.nRho = inNRho;
        this.nTheta = inNTheta;
        this.theta = new double[inNTheta];
        this.rho = new double[inNRho];
        this.rtPeaks = null;
    }

    public void setThreshold(T inThreshold) {
        this.threshold.set(inThreshold);
    }

    @Override
    public boolean process() {
        LocalizableCursor imageCursor = this.getImage().createLocalizableCursor();
        int[] position = new int[this.getImage().getDimensions().length];
        double minTheta = -1.5707963267948966;
        double minRho = -Util.computeLength(super.getImage().getDimensions());
        long sTime = System.currentTimeMillis();
        for (int t = 0; t < this.nTheta; ++t) {
            this.theta[t] = this.dTheta * (double)t + -1.5707963267948966;
        }
        for (int r = 0; r < this.nRho; ++r) {
            this.rho[r] = this.dRho * (double)r + minRho;
        }
        while (imageCursor.hasNext()) {
            int[] voteLoc = new int[2];
            imageCursor.fwd();
            imageCursor.getPosition(position);
            for (int t = 0; t < this.nTheta; ++t) {
                int r;
                if (((Comparable)imageCursor.getType()).compareTo(this.threshold) <= 0) continue;
                double fRho = Math.cos(this.theta[t]) * (double)position[0] + Math.sin(this.theta[t]) * (double)position[1];
                voteLoc[0] = r = Math.round((float)((fRho - minRho) / this.dRho));
                voteLoc[1] = t;
                try {
                    super.placeVote(voteLoc);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Tried to place vote at " + r + " " + t + " for theta " + this.theta[t] + ", and rho " + fRho);
                    return false;
                }
            }
        }
        boolean success = super.pickPeaks();
        this.pTime = System.currentTimeMillis() - sTime;
        return success;
    }

    public ArrayList<double[]> getTranslatedPeakList() {
        if (this.rtPeaks == null) {
            ArrayList<int[]> peaks = this.getPeakList();
            this.rtPeaks = new ArrayList(peaks.size());
            for (int[] irt : peaks) {
                double[] rt = new double[]{this.rho[irt[0]], this.theta[irt[2]]};
                this.rtPeaks.add(rt);
            }
        }
        return this.rtPeaks;
    }
}

