/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.image;

import ij.ImagePlus;
import ij.measure.Calibration;
import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.basictypecontainer.ByteAccess;
import mpicbg.imglib.container.basictypecontainer.ShortAccess;
import mpicbg.imglib.container.imageplus.ByteImagePlus;
import mpicbg.imglib.container.imageplus.FloatImagePlus;
import mpicbg.imglib.container.imageplus.ImagePlusContainerFactory;
import mpicbg.imglib.container.imageplus.IntImagePlus;
import mpicbg.imglib.container.imageplus.ShortImagePlus;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.TypeConverter;
import mpicbg.imglib.type.numeric.RGBALegacyType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.integer.UnsignedByteType;
import mpicbg.imglib.type.numeric.integer.UnsignedShortType;
import mpicbg.imglib.type.numeric.real.FloatType;

public class ImagePlusAdapter {
    public static <T extends RealType<T>> Image<T> wrap(ImagePlus imp) {
        return ImagePlusAdapter.wrapLocal(imp);
    }

    protected static Image<?> wrapLocal(ImagePlus imp) {
        switch (imp.getType()) {
            case 0: {
                return ImagePlusAdapter.wrapByte(imp);
            }
            case 1: {
                return ImagePlusAdapter.wrapShort(imp);
            }
            case 2: {
                return ImagePlusAdapter.wrapFloat(imp);
            }
            case 4: {
                return ImagePlusAdapter.wrapRGBA(imp);
            }
        }
        throw new RuntimeException("Only 8, 16, 32-bit and RGB supported!");
    }

    protected static void setCalibrationFromImagePlus(Image<?> image, ImagePlus imp) {
        int d = image.getNumDimensions();
        float[] spacing = new float[d];
        for (int i = 0; i < d; ++i) {
            spacing[i] = 1.0f;
        }
        Calibration c = imp.getCalibration();
        if (c != null) {
            if (d >= 1) {
                spacing[0] = (float)c.pixelWidth;
            }
            if (d >= 2) {
                spacing[1] = (float)c.pixelHeight;
            }
            if (d >= 3) {
                spacing[2] = (float)c.pixelDepth;
            }
            if (d >= 4) {
                spacing[3] = (float)c.frameInterval;
            }
        }
        image.setCalibration(spacing);
    }

    public static Image<UnsignedByteType> wrapByte(ImagePlus imp) {
        if (imp.getType() != 0) {
            return null;
        }
        ImagePlusContainerFactory containerFactory = new ImagePlusContainerFactory();
        ByteImagePlus<UnsignedByteType> container = new ByteImagePlus<UnsignedByteType>(imp, containerFactory);
        UnsignedByteType linkedType = new UnsignedByteType((DirectAccessContainer<UnsignedByteType, ? extends ByteAccess>)container);
        container.setLinkedType(linkedType);
        Image<UnsignedByteType> image = new Image<UnsignedByteType>(container, new UnsignedByteType(), imp.getTitle());
        ImagePlusAdapter.setCalibrationFromImagePlus(image, imp);
        return image;
    }

    public static Image<UnsignedShortType> wrapShort(ImagePlus imp) {
        if (imp.getType() != 1) {
            return null;
        }
        ImagePlusContainerFactory containerFactory = new ImagePlusContainerFactory();
        ShortImagePlus<UnsignedShortType> container = new ShortImagePlus<UnsignedShortType>(imp, containerFactory);
        UnsignedShortType linkedType = new UnsignedShortType((DirectAccessContainer<UnsignedShortType, ? extends ShortAccess>)container);
        container.setLinkedType(linkedType);
        Image<UnsignedShortType> image = new Image<UnsignedShortType>(container, new UnsignedShortType(), imp.getTitle());
        ImagePlusAdapter.setCalibrationFromImagePlus(image, imp);
        return image;
    }

    public static Image<RGBALegacyType> wrapRGBA(ImagePlus imp) {
        if (imp.getType() != 4) {
            return null;
        }
        ImagePlusContainerFactory containerFactory = new ImagePlusContainerFactory();
        IntImagePlus<RGBALegacyType> container = new IntImagePlus<RGBALegacyType>(imp, containerFactory);
        RGBALegacyType linkedType = new RGBALegacyType(container);
        container.setLinkedType(linkedType);
        Image<RGBALegacyType> image = new Image<RGBALegacyType>(container, new RGBALegacyType(), imp.getTitle());
        ImagePlusAdapter.setCalibrationFromImagePlus(image, imp);
        return image;
    }

    public static Image<FloatType> wrapFloat(ImagePlus imp) {
        if (imp.getType() != 2) {
            return null;
        }
        ImagePlusContainerFactory containerFactory = new ImagePlusContainerFactory();
        FloatImagePlus<FloatType> container = new FloatImagePlus<FloatType>(imp, containerFactory);
        FloatType linkedType = new FloatType(container);
        container.setLinkedType(linkedType);
        Image<FloatType> image = new Image<FloatType>(container, new FloatType(), imp.getTitle());
        ImagePlusAdapter.setCalibrationFromImagePlus(image, imp);
        return image;
    }

    public static Image<FloatType> convertFloat(ImagePlus imp) {
        if (imp.getType() != 2) {
            Image<?> img = ImagePlusAdapter.wrapLocal(imp);
            if (img == null) {
                return null;
            }
            return ImagePlusAdapter.convertToFloat(img);
        }
        return ImagePlusAdapter.wrapFloat(imp);
    }

    protected static <T extends Type<T>> Image<FloatType> convertToFloat(Image<T> input) {
        ImageFactory<FloatType> factory = new ImageFactory<FloatType>(new FloatType(), new ImagePlusContainerFactory());
        Image<FloatType> output = factory.createImage(input.getDimensions(), input.getName());
        Cursor<T> in = input.createCursor();
        Cursor<FloatType> out = output.createCursor();
        TypeConverter tc = TypeConverter.getTypeConverter(in.getType(), out.getType());
        if (tc == null) {
            System.out.println("Cannot convert from " + in.getType().getClass() + " to " + out.getType().getClass());
            output.close();
            return null;
        }
        while (in.hasNext()) {
            in.fwd();
            out.fwd();
            tc.convert();
        }
        return output;
    }
}

