/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.integer;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.ShortAccess;
import mpicbg.imglib.type.numeric.integer.GenericShortType;
import mpicbg.imglib.util.Util;

public class UnsignedShortType
extends GenericShortType<UnsignedShortType> {
    public UnsignedShortType(DirectAccessContainer<UnsignedShortType, ? extends ShortAccess> shortStorage) {
        super(shortStorage);
    }

    public UnsignedShortType(int value) {
        super(UnsignedShortType.getCodedSignedShortChecked(value));
    }

    public UnsignedShortType() {
        this(0);
    }

    public static short getCodedSignedShortChecked(int unsignedShort) {
        if (unsignedShort < 0) {
            unsignedShort = 0;
        } else if (unsignedShort > 65535) {
            unsignedShort = 65535;
        }
        return UnsignedShortType.getCodedSignedShort(unsignedShort);
    }

    public static short getCodedSignedShort(int unsignedShort) {
        return (short)(unsignedShort & 0xFFFF);
    }

    public static int getUnsignedShort(short signedShort) {
        return signedShort & 0xFFFF;
    }

    @Override
    public DirectAccessContainer<UnsignedShortType, ? extends ShortAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory storageFactory, int[] dim) {
        DirectAccessContainer<UnsignedShortType, ShortAccess> container = storageFactory.createShortInstance(dim, 1);
        UnsignedShortType linkedType = new UnsignedShortType((DirectAccessContainer<UnsignedShortType, ? extends ShortAccess>)container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public UnsignedShortType duplicateTypeOnSameDirectAccessContainer() {
        return new UnsignedShortType(this.storage);
    }

    @Override
    public void mul(float c) {
        int a = UnsignedShortType.getUnsignedShort(this.getValue());
        this.setValue(UnsignedShortType.getCodedSignedShort(Util.round((float)a * c)));
    }

    @Override
    public void mul(double c) {
        int a = UnsignedShortType.getUnsignedShort(this.getValue());
        this.setValue(UnsignedShortType.getCodedSignedShort((int)Util.round((double)a * c)));
    }

    public int get() {
        return UnsignedShortType.getUnsignedShort(this.getValue());
    }

    @Override
    public void set(int f) {
        this.setValue(UnsignedShortType.getCodedSignedShort(f));
    }

    @Override
    public int getInteger() {
        return this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public void setInteger(int f) {
        this.set(f);
    }

    @Override
    public void setInteger(long f) {
        this.set((int)f);
    }

    @Override
    public double getMaxValue() {
        return 65535.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public void div(UnsignedShortType c) {
        this.set(this.get() / c.get());
    }

    @Override
    public int compareTo(UnsignedShortType c) {
        int b;
        int a = this.get();
        if (a > (b = c.get())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    public UnsignedShortType[] createArray1D(int size1) {
        return new UnsignedShortType[size1];
    }

    public UnsignedShortType[][] createArray2D(int size1, int size2) {
        return new UnsignedShortType[size1][size2];
    }

    public UnsignedShortType[][][] createArray3D(int size1, int size2, int size3) {
        return new UnsignedShortType[size1][size2][size3];
    }

    @Override
    public UnsignedShortType createVariable() {
        return new UnsignedShortType(0);
    }

    @Override
    public UnsignedShortType copy() {
        return new UnsignedShortType(this.get());
    }
}

