/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.coloc.pValue;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.imagej.ops.Ops;
import net.imagej.ops.coloc.ShuffledView;
import net.imagej.ops.coloc.pValue.PValueResult;
import net.imagej.ops.special.computer.AbstractBinaryComputerOp;
import net.imagej.ops.special.function.BinaryFunctionOp;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.thread.ThreadService;

@Plugin(type=Ops.Coloc.PValue.class)
public class DefaultPValue<T extends RealType<T>, U extends RealType<U>>
extends AbstractBinaryComputerOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<U>, PValueResult>
implements Ops.Coloc.PValue {
    @Parameter
    private ThreadService ts;
    @Parameter
    private BinaryFunctionOp<Iterable<T>, Iterable<U>, Double> op;
    @Parameter(required=false)
    private int nrRandomizations = 100;
    @Parameter(required=false)
    private Dimensions psfSize;
    @Parameter(required=false)
    private long seed = 657924148L;

    @Override
    public void compute(RandomAccessibleInterval<T> image1, RandomAccessibleInterval<U> image2, PValueResult output) {
        int t;
        int[] blockSize = DefaultPValue.blockSize(image1, this.psfSize);
        RandomAccessibleInterval<T> trimmedImage1 = DefaultPValue.trim(image1, blockSize);
        RandomAccessibleInterval<U> trimmedImage2 = DefaultPValue.trim(image2, blockSize);
        RealType type1 = (RealType)Util.getTypeFromInterval(image1);
        double[] sampleDistribution = new double[this.nrRandomizations];
        IterableInterval iterableImage1 = Views.iterable(trimmedImage1);
        IterableInterval iterableImage2 = Views.iterable(trimmedImage2);
        double value = this.op.calculate((Iterable<T>)iterableImage1, (Iterable<U>)iterableImage2);
        int threadCount = this.ops().getMaxThreads();
        Random r = new Random(this.seed);
        long[] seeds = new long[this.nrRandomizations];
        for (int s = 0; s < this.nrRandomizations; ++s) {
            seeds[s] = r.nextLong();
        }
        ArrayList<Future> future = new ArrayList<Future>(threadCount);
        for (t = 0; t < threadCount; ++t) {
            int offset = t * this.nrRandomizations / threadCount;
            int count = (t + 1) * this.nrRandomizations / threadCount - offset;
            future.add(this.ts.run(() -> {
                int index;
                ShuffledView shuffled = new ShuffledView(trimmedImage1, blockSize, seeds[offset]);
                Img buffer = Util.getSuitableImgFactory(shuffled, (Object)type1).create(shuffled);
                for (int i = 0; i < count && (index = offset + i) < this.nrRandomizations; ++i) {
                    if (i > 0) {
                        shuffled.shuffleBlocks(seeds[index]);
                    }
                    this.copy(shuffled, buffer);
                    sampleDistribution[index] = this.op.calculate((Iterable<T>)buffer, (Iterable<U>)iterableImage2);
                }
            }));
        }
        try {
            for (t = 0; t < threadCount; ++t) {
                ((Future)future.get(t)).get();
            }
        }
        catch (InterruptedException | ExecutionException exc) {
            Throwable cause = exc.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(exc);
        }
        output.setColocValue(value);
        output.setColocValuesArray(sampleDistribution);
        output.setPValue(this.calculatePvalue(value, sampleDistribution));
    }

    private void copy(ShuffledView<T> shuffled, Img<T> buffer) {
        Cursor cursor = buffer.localizingCursor();
        RandomAccess<T> ra = shuffled.randomAccess();
        while (cursor.hasNext()) {
            RealType v = (RealType)cursor.next();
            ra.setPosition((Localizable)cursor);
            v.set((Type)ra.get());
        }
    }

    private double calculatePvalue(double input, double[] distribution) {
        double count = 0.0;
        for (int i = 0; i < distribution.length; ++i) {
            if (!(distribution[i] > input)) continue;
            count += 1.0;
        }
        double pval = count / (double)distribution.length;
        return pval;
    }

    private static int[] blockSize(Dimensions image, Dimensions psfSize) {
        if (psfSize != null) {
            return Intervals.dimensionsAsIntArray((Dimensions)psfSize);
        }
        int[] blockSize = new int[image.numDimensions()];
        for (int d = 0; d < blockSize.length; ++d) {
            long size = (long)Math.floor(Math.sqrt(image.dimension(d)));
            if (size > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Image dimension #" + d + " is too large: " + image.dimension(d));
            }
            blockSize[d] = (int)size;
        }
        return blockSize;
    }

    private static <V> RandomAccessibleInterval<V> trim(RandomAccessibleInterval<V> image, int[] blockSize) {
        long[] min = Intervals.minAsLongArray(image);
        long[] max = Intervals.maxAsLongArray(image);
        int d = 0;
        while (d < blockSize.length) {
            long trimSize = image.dimension(d) % (long)blockSize[d];
            long half = trimSize / 2L;
            int n = d;
            min[n] = min[n] + half;
            int n2 = d++;
            max[n2] = max[n2] - (trimSize - half);
        }
        return Views.interval(image, (long[])min, (long[])max);
    }
}

