/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.threshold;

import net.imagej.ops.Ops;
import net.imagej.ops.map.neighborhood.AbstractCenterAwareComputerOp;
import net.imagej.ops.special.computer.BinaryComputerOp;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.RealType;

public abstract class LocalThresholdMethodHistogram<T extends RealType<T>, O extends BooleanType<O>>
extends AbstractCenterAwareComputerOp<T, O> {
    protected UnaryFunctionOp<Iterable<T>, Histogram1d<T>> histCreator;
    protected UnaryComputerOp<Histogram1d<T>, T> thresholdComputer;
    protected BinaryComputerOp<T, T, O> applyThreshold;

    @Override
    public void initialize() {
        this.histCreator = Functions.unary(this.ops(), Ops.Image.Histogram.class, Histogram1d.class, this.in1() == null ? Iterable.class : this.in1(), new Object[0]);
        this.thresholdComputer = this.getThresholdComputer();
    }

    @Override
    public void compute(Iterable<T> neighborhood, T center, O output) {
        if (this.applyThreshold == null) {
            this.applyThreshold = Computers.binary(this.ops(), Ops.Threshold.Apply.class, output, center, center, new Object[0]);
        }
        Histogram1d<T> hist = this.histCreator.calculate(neighborhood);
        RealType computedThreshold = (RealType)center.createVariable();
        this.thresholdComputer.compute(hist, computedThreshold);
        this.applyThreshold.compute(center, computedThreshold, output);
    }

    protected abstract UnaryComputerOp<Histogram1d<T>, T> getThresholdComputer();
}

