/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.transform.project;

import java.util.Iterator;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.computer.AbstractUnaryComputerOp;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Transform.Project.class, priority=-100.0)
public class ProjectRAIToII<T, V>
extends AbstractUnaryComputerOp<RandomAccessibleInterval<T>, IterableInterval<V>>
implements Contingent,
Ops.Transform.Project {
    @Parameter
    private UnaryComputerOp<Iterable<T>, V> method;
    @Parameter
    private int dim;

    @Override
    public void compute(RandomAccessibleInterval<T> input, IterableInterval<V> output) {
        Cursor cursor = output.localizingCursor();
        RandomAccess access = input.randomAccess();
        while (cursor.hasNext()) {
            cursor.fwd();
            for (int d = 0; d < input.numDimensions(); ++d) {
                if (d == this.dim) continue;
                access.setPosition(cursor.getIntPosition(d - (d > this.dim ? -1 : 0)), d);
            }
            this.method.compute(new DimensionIterable(input.dimension(this.dim), access), cursor.get());
        }
    }

    @Override
    public boolean conforms() {
        return ((RandomAccessibleInterval)this.in()).numDimensions() == ((IterableInterval)this.out()).numDimensions() + 1 && ((RandomAccessibleInterval)this.in()).numDimensions() > this.dim;
    }

    final class DimensionIterable
    implements Iterable<T> {
        private final long size;
        private final RandomAccess<T> access;

        public DimensionIterable(long size, RandomAccess<T> access) {
            this.size = size;
            this.access = access;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                int k = -1;

                @Override
                public boolean hasNext() {
                    return (long)this.k < DimensionIterable.this.size - 1L;
                }

                @Override
                public T next() {
                    ++this.k;
                    DimensionIterable.this.access.setPosition(this.k, ProjectRAIToII.this.dim);
                    return DimensionIterable.this.access.get();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported");
                }
            };
        }
    }
}

