/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gpu.algorithms;

import java.util.HashMap;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.convolution.kernel.Kernel1D;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import sc.fiji.labkit.pixel_classification.gpu.algorithms.GpuNeighborhoodOperation;
import sc.fiji.labkit.pixel_classification.gpu.algorithms.GpuSeparableOperation;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuApi;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuImage;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuView;

public class GpuKernelConvolution
implements GpuNeighborhoodOperation {
    private final GpuApi gpu;
    private final Kernel1D kernel;
    private final int d;

    public GpuKernelConvolution(GpuApi gpu, Kernel1D kernel, int d) {
        this.gpu = gpu;
        this.kernel = kernel;
        this.d = d;
    }

    @Override
    public Interval getRequiredInputInterval(Interval targetInterval) {
        long[] min = Intervals.minAsLongArray((Interval)targetInterval);
        long[] max = Intervals.maxAsLongArray((Interval)targetInterval);
        int n = this.d;
        min[n] = min[n] + this.kernel.min();
        int n2 = this.d;
        max[n2] = max[n2] + this.kernel.max();
        return new FinalInterval(min, max);
    }

    @Override
    public void apply(GpuView input, GpuView output) {
        try (GpuApi scope = this.gpu.subScope();){
            ArrayImg kernelImage = ArrayImgs.floats((float[])this.floats(this.kernel.fullKernel()), (long[])new long[]{this.kernel.size()});
            GpuImage kernelBuffer = scope.push((RandomAccessibleInterval<? extends RealType<?>>)kernelImage);
            GpuKernelConvolution.convolve(scope, kernelBuffer, input, output, this.d);
        }
    }

    private float[] floats(double[] doubles) {
        float[] floats = new float[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            floats[i] = (float)doubles[i];
        }
        return floats;
    }

    static void convolve(GpuApi gpu, GpuImage kernel, GpuView input, GpuView output, int d) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("kernelValues", kernel);
        GpuSeparableOperation.run(gpu, "convolve1d.cl", kernel.getWidth(), parameters, input, output, d);
    }
}

