/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.scijava.Context;
import sc.fiji.labkit.pixel_classification.gui.FeatureInfo;
import sc.fiji.labkit.pixel_classification.gui.IconResources;
import sc.fiji.labkit.pixel_classification.gui.InfoDialog;
import sc.fiji.labkit.pixel_classification.gui.ParametersRow;
import sc.fiji.labkit.pixel_classification.gui.SelectableRow;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.FeatureSetting;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.FeatureSettings;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.GlobalSettings;

public class ParametrizedRow
extends JPanel
implements SelectableRow {
    private static final ImageIcon DUP_ICON = IconResources.getIcon("plus_icon_16px.png");
    private static final ImageIcon INFO_ICON = IconResources.getIcon("info_icon_16px.png");
    private Context context;
    private FeatureInfo featureInfo;
    private JCheckBox checkbox;
    private GridBagConstraints gbc;

    public ParametrizedRow(Context context, FeatureInfo featureInfo, FeatureSettings featureSettings) {
        this.context = context;
        this.featureInfo = featureInfo;
        this.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.gridx = 17;
        this.gbc.fill = 1;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.initUI(featureInfo, this.filterRelevantFeatureSettings(featureInfo, featureSettings));
        this.setGlobalSettings(featureSettings.globals());
    }

    private List<FeatureSetting> filterRelevantFeatureSettings(FeatureInfo featureInfo, FeatureSettings featureSettings) {
        return featureSettings.features().stream().filter(f -> featureInfo.pluginClass().equals(f.pluginClass())).collect(Collectors.toList());
    }

    private void initUI(FeatureInfo featureInfo, List<FeatureSetting> featureSettings) {
        JPanel titleRow = new JPanel();
        titleRow.setLayout(new BorderLayout());
        titleRow.add(Box.createHorizontalStrut(30), "West");
        this.checkbox = new JCheckBox(featureInfo.getName());
        this.checkbox.setSelected(!featureSettings.isEmpty());
        this.checkbox.addActionListener(this::checkForParameterRow);
        titleRow.add((Component)this.checkbox, "Center");
        JPanel btnPanel = this.createButtonPanel();
        titleRow.add((Component)btnPanel, "East");
        this.add((Component)titleRow, this.gbc);
        this.gbc.gridy = -1;
        for (FeatureSetting featureSetting : featureSettings) {
            this.add((Component)new ParametersRow(this.context, featureSetting), this.gbc);
        }
    }

    private JPanel createButtonPanel() {
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout(0));
        btnPanel.add(this.createButton(DUP_ICON, "Duplicate filter", this::duplicate));
        return btnPanel;
    }

    private JButton createButton(ImageIcon infoIcon, String filter_information, ActionListener showInfoDialog) {
        JButton infoButton = new JButton(infoIcon);
        infoButton.setFocusPainted(false);
        infoButton.setMargin(new Insets(0, 0, 0, 0));
        infoButton.setContentAreaFilled(false);
        infoButton.setBorderPainted(false);
        infoButton.setOpaque(false);
        infoButton.setToolTipText(filter_information);
        infoButton.addActionListener(showInfoDialog);
        return infoButton;
    }

    private void showInfoDialog(ActionEvent e) {
        InfoDialog docoDiag = new InfoDialog(this, "example", "If you use this filter you will do great things");
        docoDiag.setVisible(true);
    }

    private void duplicate(ActionEvent e) {
        this.add((Component)new ParametersRow(this.context, new FeatureSetting(this.featureInfo.pluginClass(), new Object[0])), this.gbc);
        this.revalidate();
        this.repaint();
    }

    private void checkForParameterRow(ActionEvent e) {
        if (this.checkbox.isSelected() && this.getComponents().length == 1) {
            this.duplicate(null);
        }
    }

    @Override
    public void remove(Component c) {
        super.remove(c);
        this.revalidate();
        this.repaint();
        if (this.getComponents().length == 1) {
            this.checkbox.setSelected(false);
        }
    }

    @Override
    public List<FeatureSetting> getSelectedFeatureSettings() {
        ArrayList<FeatureSetting> selected = new ArrayList<FeatureSetting>();
        if (this.checkbox.isSelected()) {
            Component[] children;
            for (Component child : children = this.getComponents()) {
                if (!(child instanceof ParametersRow)) continue;
                selected.add(((ParametersRow)child).getFeatureSetting());
            }
        }
        return selected;
    }

    @Override
    public void setGlobalSettings(GlobalSettings globalSettings) {
        try {
            boolean isValid = this.featureInfo.pluginClass().newInstance().checkGlobalSettings(globalSettings);
            ParametrizedRow.enableRecursively(this, isValid);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static void enableRecursively(Component component, boolean enabled) {
        component.setEnabled(enabled);
        if (component instanceof JPanel) {
            JPanel panel = (JPanel)component;
            for (Component child : panel.getComponents()) {
                ParametrizedRow.enableRecursively(child, enabled);
            }
        }
    }
}

