/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.filter.deprecated.hessian;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gradient.PartialDerivative;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.view.composite.Composite;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.labkit.pixel_classification.RevampUtils;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.AbstractFeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureInput;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.hessian.EigenValuesSymmetric3D;
import sc.fiji.labkit.pixel_classification.pixel_feature.settings.GlobalSettings;
import sc.fiji.labkit.pixel_classification.utils.views.FastViews;

@Deprecated
@Plugin(type=FeatureOp.class, label="Hessian")
public class SingleHessian3DFeature
extends AbstractFeatureOp {
    @Parameter
    double sigma = 4.0;
    @Parameter
    boolean absoluteValues = true;

    @Override
    public int count() {
        return 3;
    }

    @Override
    public List<String> attributeLabels() {
        return Stream.of("largest", "middle", "smallest").map(x -> "Hessian_" + x + "_" + this.sigma + "_" + this.absoluteValues).collect(Collectors.toList());
    }

    @Override
    public void apply(FeatureInput input, List<RandomAccessibleInterval<FloatType>> output) {
        this.calculateHessianOnChannel(input.original(), output, this.sigma);
    }

    @Override
    public boolean checkGlobalSettings(GlobalSettings globals) {
        return globals.numDimensions() == 3;
    }

    private void calculateHessianOnChannel(RandomAccessible<FloatType> image, List<RandomAccessibleInterval<FloatType>> output, double sigma) {
        double[] sigmas = new double[]{0.4 * sigma, 0.4 * sigma, 0.4 * sigma};
        Interval secondDerivativeInterval = (Interval)output.get(0);
        FinalInterval firstDerivativeInterval = Intervals.expand((Interval)secondDerivativeInterval, (long)1L);
        FinalInterval blurredInterval = Intervals.expand((Interval)firstDerivativeInterval, (long)1L);
        RandomAccessibleInterval<FloatType> blurred = RevampUtils.gauss(image, (Interval)blurredInterval, sigmas);
        RandomAccessibleInterval<FloatType> dx = this.derive((RandomAccessible<FloatType>)blurred, (Interval)firstDerivativeInterval, 0);
        RandomAccessibleInterval<FloatType> dy = this.derive((RandomAccessible<FloatType>)blurred, (Interval)firstDerivativeInterval, 1);
        RandomAccessibleInterval<FloatType> dz = this.derive((RandomAccessible<FloatType>)blurred, (Interval)firstDerivativeInterval, 2);
        RandomAccessibleInterval<Composite<FloatType>> secondDerivatives = this.calculateSecondDerivatives(secondDerivativeInterval, dx, dy, dz);
        RandomAccessibleInterval eigenValues = RevampUtils.vectorizeStack(output);
        EigenValuesSymmetric3D ev = new EigenValuesSymmetric3D();
        if (this.absoluteValues) {
            LoopBuilder.setImages(secondDerivatives, eigenValues).forEachPixel(ev::computeMagnitudeOfEigenvalues);
        } else {
            LoopBuilder.setImages(secondDerivatives, eigenValues).forEachPixel(ev::compute);
        }
    }

    private RandomAccessibleInterval<Composite<FloatType>> calculateSecondDerivatives(Interval secondDerivativeInterval, RandomAccessibleInterval<FloatType> dx, RandomAccessibleInterval<FloatType> dy, RandomAccessibleInterval<FloatType> dz) {
        RandomAccessibleInterval<FloatType> secondDerivatives = RevampUtils.createImage(RevampUtils.appendDimensionToInterval(secondDerivativeInterval, 0L, 5L), new FloatType());
        List<RandomAccessibleInterval<FloatType>> slices = RevampUtils.slices(secondDerivatives);
        PartialDerivative.gradientCentralDifference(dx, slices.get(0), (int)0);
        PartialDerivative.gradientCentralDifference(dx, slices.get(1), (int)1);
        PartialDerivative.gradientCentralDifference(dx, slices.get(2), (int)2);
        PartialDerivative.gradientCentralDifference(dy, slices.get(3), (int)1);
        PartialDerivative.gradientCentralDifference(dy, slices.get(4), (int)2);
        PartialDerivative.gradientCentralDifference(dz, slices.get(5), (int)2);
        return FastViews.collapse(secondDerivatives);
    }

    private RandomAccessibleInterval<FloatType> derive(RandomAccessible<FloatType> source, Interval interval, int dimension) {
        RandomAccessibleInterval<FloatType> target = RevampUtils.createImage(interval, new FloatType());
        PartialDerivative.gradientCentralDifference(source, target, (int)dimension);
        return target;
    }
}

