/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.lapack;

import edu.mines.jtk.lapack.DMatrix;
import edu.mines.jtk.lapack.DMatrixSvd;
import edu.mines.jtk.lapack.DMatrixTest;
import edu.mines.jtk.util.ArrayMath;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DMatrixSvdTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(DMatrixSvdTest.class);
        TestRunner.run((Test)suite);
    }

    public void testSimple() {
        this.test(new DMatrix(new double[][]{{1.0, 0.0}, {0.0, 2.0}, {0.0, 0.0}}));
        this.test(new DMatrix(new double[][]{{0.0, 2.0}, {3.0, 4.0}}));
        this.test(new DMatrix(new double[][]{{0.0, 2.0}, {3.0, 4.0}, {5.0, 6.0}}));
    }

    public void testRandom() {
        this.test(DMatrix.random(100, 100));
        this.test(DMatrix.random(10, 100));
        this.test(DMatrix.random(100, 10));
    }

    public void testCond() {
        DMatrix a = new DMatrix(new double[][]{{1.0, 3.0}, {7.0, 9.0}});
        int m = a.getM();
        int n = a.getN();
        DMatrixSvd svd = new DMatrixSvd(a);
        double[] s = svd.getSingularValues();
        double smax = ArrayMath.max(s);
        DMatrixTest.assertEqualExact(s[0], smax);
        double smin = ArrayMath.min(s);
        DMatrixTest.assertEqualExact(s[ArrayMath.min(m, n) - 1], smin);
        double cond = svd.cond();
        DMatrixTest.assertEqualExact(smax / smin, cond);
    }

    public void testRank() {
        DMatrix a = new DMatrix(new double[][]{{1.0, 3.0}, {7.0, 9.0}});
        DMatrixSvd svda = new DMatrixSvd(a);
        DMatrixTest.assertEqualExact(svda.rank(), 2.0);
        DMatrix b = new DMatrix(new double[][]{{1.0, 3.0}, {7.0, 9.0}, {0.0, 0.0}});
        DMatrixSvd svdb = new DMatrixSvd(b);
        DMatrixTest.assertEqualExact(svdb.rank(), 2.0);
        DMatrix c = new DMatrix(new double[][]{{1.0, 3.0, 0.0}, {7.0, 9.0, 0.0}});
        DMatrixSvd svdc = new DMatrixSvd(c);
        DMatrixTest.assertEqualExact(svdc.rank(), 2.0);
    }

    private void test(DMatrix a) {
        DMatrixSvd svd = new DMatrixSvd(a);
        DMatrix u = svd.getU();
        DMatrix s = svd.getS();
        DMatrix vt = svd.getVTranspose();
        DMatrix usvt = u.times(s).times(vt);
        DMatrixTest.assertEqualFuzzy(a, usvt);
    }
}

