/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.mosaic.IPanel;
import edu.mines.jtk.mosaic.Transcaler;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.io.IOException;
import javax.swing.JFrame;

public class IPanelTest {
    public static void main(String[] args) {
        IPanel mosaic = new IPanel();
        mosaic.setLayout(new GridLayout(2, 1));
        mosaic.add(new Title("A Sine Wave"));
        mosaic.add(new Wave(5.0));
        mosaic.setPreferredSize(new Dimension(800, 500));
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.add(mosaic);
        frame.pack();
        frame.setVisible(true);
        try {
            mosaic.paintToPng(1000.0, 3.0, "junk.png");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    static class Wave
    extends IPanel {
        private static final long serialVersionUID = 1L;
        private double _cycles;

        Wave(double cycles) {
            this._cycles = cycles;
        }

        @Override
        public void paintToRect(Graphics2D g2d, int x, int y, int w, int h) {
            g2d = this.createGraphics(g2d, x, y, w, h);
            double x1u = 0.0;
            double y1u = 1.0;
            double x2u = Math.PI * 2 * this._cycles;
            double y2u = -1.0;
            int x1d = 0;
            int y1d = 0;
            int x2d = w - 1;
            int y2d = h - 1;
            Transcaler ts = new Transcaler(x1u, y1u, x2u, y2u, x1d, y1d, x2d, y2d);
            int nx = 10000;
            double dx = (x2u - x1u) / (double)(nx - 1);
            double fx = 0.0;
            int x1 = ts.x(fx);
            int y1 = ts.y(Math.sin(fx));
            for (int ix = 1; ix < nx; ++ix) {
                double xi = fx + (double)ix * dx;
                int x2 = ts.x(xi);
                int y2 = ts.y(Math.sin(xi));
                g2d.drawLine(x1, y1, x2, y2);
                x1 = x2;
                y1 = y2;
            }
            g2d.dispose();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.paintToRect((Graphics2D)g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    static class Title
    extends IPanel {
        private static final long serialVersionUID = 1L;
        private String _text;

        Title(String text) {
            this._text = text;
            Font font = this.getFont();
            this.setFont(font.deriveFont(2.0f * font.getSize2D()));
        }

        @Override
        public void paintToRect(Graphics2D g2d, int x, int y, int w, int h) {
            g2d = this.createGraphics(g2d, x, y, w, h);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            FontMetrics fm = g2d.getFontMetrics();
            int wt = fm.stringWidth(this._text);
            int xt = Math.max(0, Math.min(w - wt, (w - wt) / 2));
            int yt = h / 2;
            g2d.drawString(this._text, xt, yt);
            g2d.dispose();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.paintToRect((Graphics2D)g, 0, 0, this.getWidth(), this.getHeight());
        }
    }
}

