/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.BrentMinFinder;
import edu.mines.jtk.util.MathPlus;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BrentMinFinderTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(BrentMinFinderTest.class);
        TestRunner.run((Test)suite);
    }

    public void testSimple() {
        BrentMinFinder bmf = new BrentMinFinder(new BrentMinFinder.Function(){

            @Override
            public double evaluate(double x) {
                return x * (x * x - 2.0) - 5.0;
            }
        });
        double xmin = bmf.findMin(0.0, 1.0, 1.0E-5);
        this.trace("xmin=" + xmin);
        BrentMinFinderTest.assertEquals((double)0.8165, (double)xmin, (double)1.0E-5);
    }

    private void trace(String s) {
    }

    public void testMinFinder() {
        MinFunc1 f1 = new MinFunc1();
        f1.findMin(0.0, 1.0);
        MinFunc2 f2 = new MinFunc2();
        f2.findMin(2.0, 3.0);
        MinFunc3 f3 = new MinFunc3();
        f3.findMin(-1.0, 3.0);
        MinFunc4 f4 = new MinFunc4();
        f4.findMin(-1.0, 3.0);
    }

    private static void assertEqual(double x, double y) {
        BrentMinFinderTest.assertTrue((String)(x + " = " + y), (boolean)BrentMinFinderTest.almostEqual(x, y));
    }

    private static boolean almostEqual(double x, double y) {
        double ax = MathPlus.abs(x);
        double ay = MathPlus.abs(y);
        return MathPlus.abs(x - y) <= 1.0E-4 * MathPlus.max(ax, ay);
    }

    class MinFunc4
    extends BrentTestFunc {
        MinFunc4() {
        }

        @Override
        double eval(double x) {
            return MathPlus.pow(MathPlus.sin(x) - x, 2.0) + 1.0;
        }

        @Override
        void checkMin(double x) {
            BrentMinFinderTest.assertEqual(x, -3.12582763E-4);
        }

        @Override
        void checkFunc(double y) {
            BrentMinFinderTest.assertEqual(y, 1.0);
        }

        @Override
        void checkCount(int count) {
            BrentMinFinderTest.assertEqual(count, 47.0);
        }
    }

    class MinFunc3
    extends BrentTestFunc {
        MinFunc3() {
        }

        @Override
        double eval(double x) {
            return MathPlus.pow(MathPlus.cos(x) - x, 2.0) - 2.0;
        }

        @Override
        void checkMin(double x) {
            BrentMinFinderTest.assertEqual(x, 0.7390851269);
        }

        @Override
        void checkFunc(double y) {
            BrentMinFinderTest.assertEqual(y, -2.0);
        }

        @Override
        void checkCount(int count) {
            BrentMinFinderTest.assertEqual(count, 13.0);
        }
    }

    class MinFunc2
    extends BrentTestFunc {
        MinFunc2() {
        }

        @Override
        double eval(double x) {
            return MathPlus.pow((MathPlus.pow(x, 2.0) - 2.0) * x - 5.0, 2.0);
        }

        @Override
        void checkMin(double x) {
            BrentMinFinderTest.assertEqual(x, 2.094551483);
        }

        @Override
        void checkFunc(double y) {
            BrentMinFinderTest.assertEqual(y, 2.7186E-16);
        }

        @Override
        void checkCount(int count) {
            BrentMinFinderTest.assertEqual(count, 13.0);
        }
    }

    class MinFunc1
    extends BrentTestFunc {
        MinFunc1() {
        }

        @Override
        double eval(double x) {
            return (MathPlus.pow(x, 2.0) - 2.0) * x - 5.0;
        }

        @Override
        void checkMin(double x) {
            BrentMinFinderTest.assertEqual(x, 0.8164965811);
        }

        @Override
        void checkFunc(double y) {
            BrentMinFinderTest.assertEqual(y, -6.0887);
        }

        @Override
        void checkCount(int count) {
            BrentMinFinderTest.assertEqual(count, 11.0);
        }
    }

    abstract class BrentTestFunc
    implements BrentMinFinder.Function {
        private int _count;

        BrentTestFunc() {
        }

        void findMin(double a, double b) {
            this._count = 0;
            BrentMinFinder minFinder = new BrentMinFinder(this);
            double xmin = minFinder.findMin(a, b, 2.220446049250313E-16);
            double ymin = this.eval(xmin);
            this.checkMin(xmin);
            this.checkFunc(ymin);
            this.checkCount(this._count);
        }

        @Override
        public double evaluate(double x) {
            ++this._count;
            return this.eval(x);
        }

        abstract double eval(double var1);

        abstract void checkMin(double var1);

        abstract void checkFunc(double var1);

        abstract void checkCount(int var1);
    }
}

