/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.FeatureModel;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.features.spot.SpotAnalyzer;
import fiji.plugin.trackmate.features.spot.SpotAnalyzerFactory;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.util.TMUtils;
import ij.gui.Roi;
import ij.plugin.frame.RoiManager;
import ij.process.FloatPolygon;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import javax.swing.ImageIcon;
import net.imagej.ImgPlus;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

public class ComputeDistanceToRoiAction
extends AbstractTMAction {
    private static final String INFO_TEXT = "<html>Computes the distance from each spot to the closest ROI in the current frame.<p>The distances are stored in a new spot feature and the distances are reported using physical distance units. <p>The ROIs are taken from the Roi Manager window currently opened. All the ROIs from the current time-point are considered, so the frame position of the ROIs must be properly set. If the frame position of a ROI is not set, it will be considered as being present for <i>all</i> time-points. The Z position of the ROIs is not taken into account. That is: the distances are calculated as if all the ROIs would be in the Z plane of the spot. </html>";
    private static final String NAME = "Compute distance to ROIs";
    private static final String KEY = "COMPUTE_DIST_TO_ROI";

    @Override
    public void execute(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings, Frame parent) {
        double[] calibration;
        this.logger.log("Computing distance from visible spots to closest ROI.\n");
        RoiManager rm = RoiManager.getInstance();
        if (rm == null) {
            this.logger.error("The Roi Manager window is not opened. Aborting.\n");
            return;
        }
        if (trackmate.getSettings() != null) {
            Settings settings = trackmate.getSettings();
            if (settings.imp != null) {
                calibration = TMUtils.getSpatialCalibration(settings.imp);
                this.logger.log("Using pixel size from the target image.\n");
            } else {
                calibration = new double[]{settings.dx, settings.dy, settings.dz};
                this.logger.log("Using pixel size stored in the settings.\n");
            }
        } else {
            calibration = new double[]{1.0, 1.0, 1.0};
            this.logger.log("No image nor settings found. Using pixel distance.\n");
        }
        Model model = trackmate.getModel();
        ComputeDistanceToRoiAction.computeDistance(model, rm, calibration);
        this.logger.log("Done.\n");
    }

    public static void computeDistance(Model model, RoiManager rm, double[] calibration) {
        Roi[] rois = rm.getRoisAsArray();
        ComputeDistanceToRoiAction.computeDistance(model, rois, calibration);
    }

    public static void computeDistance(Model model, Roi[] rois, double[] calibration) {
        FeatureModel fm = model.getFeatureModel();
        fm.declareSpotFeatures(DistanceToRoiFeature.FEATURES, DistanceToRoiFeature.FEATURE_NAMES, DistanceToRoiFeature.FEATURE_SHORT_NAMES, DistanceToRoiFeature.FEATURE_DIMENSIONS, DistanceToRoiFeature.IS_INT);
        SpotCollection spots = model.getSpots();
        NavigableSet<Integer> timepoints = spots.keySet();
        for (Integer tp : timepoints) {
            int frame = tp;
            ArrayList<Roi> list = new ArrayList<Roi>();
            for (Roi roi : rois) {
                if (roi.getTPosition() != 0 && roi.getTPosition() != frame + 1) continue;
                list.add(roi);
            }
            for (Spot spot : spots.iterable(frame, true)) {
                double d = ComputeDistanceToRoiAction.distance(spot, list, calibration);
                spot.putFeature("DISTANCE_TO_ROI", d);
            }
        }
        model.notifyFeaturesComputed();
    }

    public static double distance(Spot spot, List<Roi> list, double[] calibration) {
        double distance = Double.POSITIVE_INFINITY;
        for (Roi roi : list) {
            double d = ComputeDistanceToRoiAction.distance(spot, roi, calibration);
            if (!(d < distance)) continue;
            distance = d;
        }
        return distance;
    }

    public static double distance(Spot spot, Roi roi, double[] calibration) {
        double min2 = Double.POSITIVE_INFINITY;
        FloatPolygon polygon = roi.getInterpolatedPolygon();
        for (int i = 0; i < polygon.npoints; ++i) {
            double x = (double)polygon.xpoints[i] * calibration[0];
            double dx = spot.getDoublePosition(0) - x;
            double y = (double)polygon.ypoints[i] * calibration[1];
            double dy = spot.getDoublePosition(1) - y;
            double dd = dx * dx + dy * dy;
            if (!(dd < min2)) continue;
            min2 = dd;
        }
        return Math.sqrt(min2);
    }

    public static class DistanceToRoiFeature<T extends RealType<T> & NativeType<T>>
    implements SpotAnalyzerFactory<T> {
        public static final String FEATURE = "DISTANCE_TO_ROI";
        public static final String NAME = "Distance to ROI";
        static final List<String> FEATURES = Collections.singletonList("DISTANCE_TO_ROI");
        static final Map<String, String> FEATURE_SHORT_NAMES = Collections.singletonMap("DISTANCE_TO_ROI", "Dist to ROI");
        static final Map<String, String> FEATURE_NAMES = Collections.singletonMap("DISTANCE_TO_ROI", "Distance to ROI");
        static final Map<String, Dimension> FEATURE_DIMENSIONS = Collections.singletonMap("DISTANCE_TO_ROI", Dimension.LENGTH);
        static final Map<String, Boolean> IS_INT = Collections.singletonMap("DISTANCE_TO_ROI", Boolean.FALSE);
        static final String INFO_TEXT = "<html>A dummy analyzer for the feature that stores the distance from a spot to a ROI.</html>";

        @Override
        public String getKey() {
            return NAME;
        }

        @Override
        public List<String> getFeatures() {
            return FEATURES;
        }

        @Override
        public Map<String, String> getFeatureShortNames() {
            return FEATURE_SHORT_NAMES;
        }

        @Override
        public Map<String, String> getFeatureNames() {
            return FEATURE_NAMES;
        }

        @Override
        public Map<String, Dimension> getFeatureDimensions() {
            return FEATURE_DIMENSIONS;
        }

        @Override
        public String getInfoText() {
            return INFO_TEXT;
        }

        @Override
        public Map<String, Boolean> getIsIntFeature() {
            return IS_INT;
        }

        @Override
        public boolean isManualFeature() {
            return true;
        }

        @Override
        public ImageIcon getIcon() {
            return null;
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public SpotAnalyzer<T> getAnalyzer(ImgPlus<T> img, int frame, int channel) {
            return SpotAnalyzer.dummyAnalyzer();
        }
    }

    @Plugin(type=TrackMateActionFactory.class)
    public static class Factory
    implements TrackMateActionFactory {
        @Override
        public String getInfoText() {
            return ComputeDistanceToRoiAction.INFO_TEXT;
        }

        @Override
        public String getName() {
            return ComputeDistanceToRoiAction.NAME;
        }

        @Override
        public String getKey() {
            return ComputeDistanceToRoiAction.KEY;
        }

        @Override
        public ImageIcon getIcon() {
            return Icons.VECTOR_ICON;
        }

        @Override
        public TrackMateAction create() {
            return new ComputeDistanceToRoiAction();
        }
    }
}

