/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.detection.semiauto;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.detection.semiauto.AbstractSemiAutoTracker;
import fiji.plugin.trackmate.util.TMUtils;
import ij.ImagePlus;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;

public class SemiAutoTracker<T extends RealType<T> & NativeType<T>>
extends AbstractSemiAutoTracker<T> {
    protected final ImgPlus<T> img;
    private final double dt;
    private final ImagePlus imp;

    public SemiAutoTracker(Model model, SelectionModel selectionModel, ImagePlus imp, Logger logger) {
        super(model, selectionModel, logger);
        this.imp = imp;
        this.img = TMUtils.rawWraps(imp);
        double ldt = imp.getCalibration().frameInterval;
        this.dt = ldt == 0.0 ? 1.0 : ldt;
    }

    @Override
    protected AbstractSemiAutoTracker.SearchRegion<T> getNeighborhood(Spot spot, int frame) {
        long[] max;
        long[] min;
        double radius = spot.getFeature("RADIUS");
        int tindex = this.img.dimensionIndex(Axes.TIME);
        int cindex = this.img.dimensionIndex(Axes.CHANNEL);
        if ((long)frame >= this.img.dimension(tindex)) {
            this.logger.log("Spot: " + spot + ": No more time-points.\n");
            return null;
        }
        double[] cal = TMUtils.getSpatialCalibration(this.img);
        double dx = cal[0];
        double dy = cal[1];
        double dz = cal[2];
        double neighborhoodFactor = Math.max(2.0, this.distanceTolerance + 1.0);
        double[] location = new double[3];
        spot.localize(location);
        long x = Math.round(location[0] / dx);
        long y = Math.round(location[1] / dy);
        long z = Math.round(location[2] / dz);
        long r = (long)Math.ceil(neighborhoodFactor * radius / dx);
        long rz = (long)Math.abs(Math.ceil(neighborhoodFactor * radius / dz));
        int targetChannel = this.imp.getC() - 1;
        long width = this.img.dimension(0);
        long height = this.img.dimension(1);
        long x0 = Math.max(0L, x - r);
        long y0 = Math.max(0L, y - r);
        long x1 = Math.min(width - 1L, x + r);
        long y1 = Math.min(height - 1L, y + r);
        if (this.img.dimensionIndex(Axes.Z) >= 0) {
            long depth = this.img.dimension(this.img.dimensionIndex(Axes.Z));
            long z0 = Math.max(0L, z - rz);
            long z1 = Math.min(depth - 1L, z + rz);
            min = new long[]{x0, y0, z0};
            max = new long[]{x1, y1, z1};
        } else {
            min = new long[]{x0, y0};
            max = new long[]{x1, y1};
        }
        FinalInterval interval = new FinalInterval(min, max);
        AffineTransform3D transform = new AffineTransform3D();
        AbstractSemiAutoTracker.SearchRegion sn = new AbstractSemiAutoTracker.SearchRegion();
        MixedTransformView source = this.img;
        if (tindex >= 0) {
            source = Views.hyperSlice(source, (int)tindex, (long)frame);
        }
        if (cindex >= 0) {
            source = Views.hyperSlice((RandomAccessible)source, (int)cindex, (long)targetChannel);
        }
        sn.source = source;
        sn.transform = transform;
        sn.interval = interval;
        sn.calibration = cal;
        return sn;
    }

    @Override
    protected void exposeSpot(Spot newSpot, Spot previousSpot) {
        int frame = previousSpot.getFeature("FRAME").intValue() + 1;
        newSpot.putFeature("POSITION_T", (double)frame * this.dt);
    }
}

