/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.editor;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.editor.labkit.component.TMLabKitFrame;
import fiji.plugin.trackmate.gui.editor.labkit.model.TMLabKitModel;
import fiji.plugin.trackmate.io.TmXmlReader;
import fiji.plugin.trackmate.util.EverythingDisablerAndReenabler;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.visualization.ViewUtils;
import fiji.plugin.trackmate.visualization.hyperstack.HyperStackDisplayer;
import ij.ImagePlus;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.Interval;
import org.scijava.Context;
import org.scijava.ui.behaviour.util.AbstractNamedAction;
import sc.fiji.labkit.ui.labeling.Labeling;

public class LabkitLauncher {
    private static final boolean ENABLE_SPOT_EDITOR = true;
    private static boolean simplify = true;

    public static final TMLabKitFrame launch(TrackMate trackmate, DisplaySettings displaySettings, int timepoint) {
        Model model = trackmate.getModel();
        ImagePlus imp = trackmate.getSettings().imp;
        if (null == imp) {
            imp = ViewUtils.makeEmpytImagePlus(model);
        }
        Interval interval = TMUtils.createROIInterval(imp);
        Context context = TMUtils.getContext();
        TMLabKitModel lbModel = TMLabKitModel.create(model, imp, interval, displaySettings, timepoint, context);
        TMLabKitFrame labkit = new TMLabKitFrame(lbModel);
        GuiUtils.positionWindow(labkit, (Component)imp.getWindow());
        labkit.setDefaultCloseOperation(2);
        labkit.onCloseListeners().addListener(() -> LabkitLauncher.reimport(lbModel, timepoint));
        labkit.setIconImage(Icons.SEGMENTATION_EDITOR_ICON.getImage());
        labkit.setSize(1000, 800);
        GuiUtils.positionWindow(labkit, (Component)imp.getWindow());
        labkit.setTitle("TrackMate editor on " + imp.getShortTitle());
        labkit.setVisible(true);
        return labkit;
    }

    private static void reimport(final TMLabKitModel lbModel, final int timepoint) {
        new Thread("TrackMate-LabKit-Importer-thread"){

            @Override
            public void run() {
                try {
                    if (!lbModel.hasChanges()) {
                        return;
                    }
                    boolean isSingleTimePoint = true;
                    Labeling labeling = (Labeling)lbModel.imageLabelingModel().labeling().get();
                    for (CalibratedAxis axis : labeling.axes()) {
                        if (!axis.type().equals(Axes.TIME)) continue;
                        isSingleTimePoint = false;
                    }
                    String msg = isSingleTimePoint ? "Commit the changes made to the\nsegmentation in the image?" : (timepoint < 0 ? "Commit the changes made to the\nsegmentation in whole movie?" : "Commit the changes made to the\nsegmentation in frame " + (timepoint + 1) + "?");
                    String title = "Commit edits to TrackMate";
                    JCheckBox chkbox = new JCheckBox("Simplify the contours of modified spots");
                    chkbox.setSelected(simplify);
                    Object[] objs = new Object[]{msg, new JSeparator(), chkbox};
                    int returnedValue = JOptionPane.showConfirmDialog(null, objs, "Commit edits to TrackMate", 0, 3, Icons.SEGMENTATION_EDITOR_ICON_64x64);
                    if (returnedValue != 0) {
                        return;
                    }
                    simplify = chkbox.isSelected();
                    lbModel.updateTrackMateModel(simplify, timepoint);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public static final AbstractNamedAction getLaunchAction(final TrackMate trackmate, final DisplaySettings ds) {
        AbstractNamedAction action = new AbstractNamedAction("launch labkit editor"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(final ActionEvent ae) {
                new Thread("TrackMate editor thread"){

                    @Override
                    public void run() {
                        JRootPane parent = SwingUtilities.getRootPane((Component)ae.getSource());
                        EverythingDisablerAndReenabler disabler = new EverythingDisablerAndReenabler(parent, new Class[]{JLabel.class});
                        disabler.disable();
                        try {
                            int mod = ae.getModifiers();
                            boolean shiftPressed = (mod & 1) > 0;
                            boolean singleTimepoint = !shiftPressed;
                            ImagePlus imp = trackmate.getSettings().imp;
                            int timepoint = imp == null ? -1 : (singleTimepoint ? imp.getFrame() - 1 : -1);
                            TMLabKitFrame labKitFrame = LabkitLauncher.launch(trackmate, ds, timepoint);
                            labKitFrame.onCloseListeners().addListener(disabler::reenable);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            disabler.reenable();
                        }
                    }
                }.start();
            }
        };
        if (!DetectionUtils.is2D(trackmate.getSettings().imp)) {
            action.setEnabled(false);
        } else {
            action.setEnabled(true);
        }
        return action;
    }

    public static void main(String[] args) {
        String filename = "samples/221031_Stat_Stage55_561nm_part1Conf_crop_f4.xml";
        TmXmlReader reader = new TmXmlReader(new File("samples/221031_Stat_Stage55_561nm_part1Conf_crop_f4.xml"));
        if (!reader.isReadingOk()) {
            System.out.println(reader.getErrorMessage());
            return;
        }
        Model model = reader.getModel();
        ImagePlus imp = reader.readImage();
        Settings settings = reader.readSettings(imp);
        DisplaySettings ds = reader.getDisplaySettings();
        TrackMate trackmate = new TrackMate(model, settings);
        SelectionModel selectionModel = new SelectionModel(model);
        HyperStackDisplayer displayer = new HyperStackDisplayer(model, selectionModel, settings.imp, ds);
        displayer.render();
        imp.setSlice(7);
        LabkitLauncher.launch(trackmate, ds, 6);
    }
}

