/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.editor.labkit.component;

import fiji.plugin.trackmate.gui.editor.labkit.component.TMFloodFillController;
import fiji.plugin.trackmate.gui.editor.labkit.component.TMLabKitFrame;
import fiji.plugin.trackmate.gui.editor.labkit.component.TMLabelBrushController;
import fiji.plugin.trackmate.gui.editor.labkit.component.TMSelectLabelController;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.function.BooleanConsumer;
import org.scijava.plugin.Plugin;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionProvider;
import org.scijava.ui.behaviour.io.gui.CommandDescriptions;
import org.scijava.ui.behaviour.util.Actions;

public class TMLabelToolsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Color OPTIONS_BORDER = new Color(220, 220, 220);
    private static final Color OPTIONS_BACKGROUND = new Color(230, 230, 230);
    private static final String MOVE_TOOL_TIP = "<html><b>Move</b><br><small>Keyboard shortcuts:<br>- <b>Left Click</b> on the image and drag, to rotate the image.<br>- <b>Right Click</b> on the image, to move around.<br>- <b>Mouse Wheel</b> or <b>+ / -</b> to zoom in and out.<br>- <b>\u2190 / \u2192</b> or <b>F / G</b> to move through time.<br>- <b>Shift + R</b> to reset the view.</small></html>";
    private static final String DRAW_TOOL_TIP = "<html><b>Add</b><br><small>Keyboard shortcuts:<br>- Hold down the <b>A</b> key and <b>Left Click</b> on the image to draw the selected label.<br>- Hold down the <b>A</b> key and use the <b>Mouse Wheel</b> to change the brush diameter.<br>- You can also change the brush diameter with the <b>Q /E</b> (shift to go faster).<br></small></html>";
    private static final String ERASE_TOOL_TIP = "<html><b>Delete</b><br><small>Keyboard shortcuts:<br>- Hold down the <b>D</b> key and <b>Left Click</b> on the image to delete the selected label.<br>- Hold down the <b>D</b> key and use the <b>Mouse Wheel</b> to change the brush diameter.<br></small></html>";
    private static final String FLOOD_FILL_TOOL_TIP = "<html><b>Flood Fill</b><br><small>Keyboard shortcuts:<br>- Hold down the <b>L</b> key and <b>Left Click</b> on the image to flood fill with the selected label.<br></small></html>";
    private static final String FLOOD_ERASE_TOOL_TIP = "<html><b>Remove Connected Component</b><br><small>Keyboard shortcuts:<br>- Hold down the <b>R</b> key and <b>Left Click</b> on the image to remove connected component.<br></small></html>";
    private static final String SELECT_LABEL_TOOL_TIP = "<html><b>Select Label</b><br><small>Keyboard shortcuts:<br>- Hold down the <b>Shift</b> key and <b>Left Click</b> on the image<br>  to select the label under the cursor.</small></html>";
    private final TMFloodFillController floodFillController;
    private final TMLabelBrushController brushController;
    private final TMSelectLabelController selectLabelController;
    private final ButtonGroup group = new ButtonGroup();
    private Mode mode = ignore -> {};
    private final JToggleButton moveBtn;
    private final JToggleButton drawBtn;
    private final JToggleButton floodFillBtn;
    private final JToggleButton eraseBtn;
    private final JToggleButton floodEraseBtn;
    private final JToggleButton selectLabelBtn;
    private final JPanel brushOptionsPanel;
    private final JPanel paintModePanel;
    private final JPanel eraseModePanel;
    private final JPanel floodFillModePanel;
    private final JPanel floodEraseModePanel;
    private JComboBox<TMLabelBrushController.PaintBrushMode> paintModeCombo;
    private JComboBox<TMLabelBrushController.EraseBrushMode> eraseModeCombo;
    private JComboBox<TMFloodFillController.FloodFillMode> floodFillModeCombo;
    private JComboBox<TMFloodFillController.FloodEraseMode> floodEraseModeCombo;
    private static final String SELECT_PAN_TOOL = "pan tool";
    private static final String SELECT_DRAW_TOOL = "paint tool";
    private static final String SELECT_FLOOD_FILL_TOOL = "flood fill tool";
    private static final String SELECT_ERASE_TOOL = "erase tool";
    private static final String SELECT_ERASE_FILL_TOOL = "erase fill tool";
    private static final String SELECT_LABEL_TOOL = "select label tool";
    private static final String[] SELECT_PAN_TOOL_KEYS = new String[]{"F1"};
    private static final String[] SELECT_DRAW_TOOL_KEYS = new String[]{"F2"};
    private static final String[] SELECT_ERASE_TOOL_KEYS = new String[]{"F3"};
    private static final String[] SELECT_FLOOD_FILL_TOOL_KEYS = new String[]{"F4"};
    private static final String[] SELECT_ERASE_FILL_TOOL_KEYS = new String[]{"F5"};
    private static final String[] SELECT_LABEL_KEYS = new String[]{"F6"};

    public TMLabelToolsPanel(TMLabelBrushController brushController, TMFloodFillController floodFillController, TMSelectLabelController selectLabelController) {
        this.brushController = brushController;
        this.floodFillController = floodFillController;
        this.selectLabelController = selectLabelController;
        this.moveBtn = this.addActionButton(MOVE_TOOL_TIP, ignore -> {}, false, "/images/move.png");
        this.drawBtn = this.addActionButton(DRAW_TOOL_TIP, brushController::setBrushActive, true, "/images/draw.png");
        this.floodFillBtn = this.addActionButton(FLOOD_FILL_TOOL_TIP, floodFillController::setFloodFillActive, false, "/images/fill.png");
        this.eraseBtn = this.addActionButton(ERASE_TOOL_TIP, brushController::setEraserActive, true, "/images/erase.png");
        this.floodEraseBtn = this.addActionButton(FLOOD_ERASE_TOOL_TIP, floodFillController::setRemoveBlobActive, false, "/images/flooderase.png");
        this.selectLabelBtn = this.addActionButton(SELECT_LABEL_TOOL_TIP, selectLabelController::setActive, false, "/images/pipette.png");
        this.brushOptionsPanel = this.initBrushSizePanel();
        this.paintModePanel = this.initPaintModePanel();
        this.eraseModePanel = this.initEraseModePanel();
        this.floodFillModePanel = this.initFloodFillModePanel();
        this.floodEraseModePanel = this.initFloodEraseModePanel();
        this.setLayout((LayoutManager)new MigLayout("insets 0, gap 4", "", "[]"));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        JPanel toolsPanel = new JPanel((LayoutManager)new MigLayout("insets 0, gap 2", "", ""));
        toolsPanel.add(this.moveBtn);
        toolsPanel.add(this.drawBtn);
        toolsPanel.add(this.eraseBtn);
        toolsPanel.add(this.floodFillBtn);
        toolsPanel.add(this.floodEraseBtn);
        toolsPanel.add(this.selectLabelBtn);
        this.add(toolsPanel);
        this.add((Component)this.brushOptionsPanel, "hidemode 3, h 32!");
        this.add((Component)this.paintModePanel, "hidemode 3, h 32!");
        this.add((Component)this.eraseModePanel, "hidemode 3, h 32!");
        this.add((Component)this.floodFillModePanel, "hidemode 3, h 32!");
        this.add((Component)this.floodEraseModePanel, "hidemode 3, h 32!");
        this.moveBtn.doClick();
    }

    private JPanel initFloodFillModePanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 4 8 4 8, gap 4", "", "[center]"));
        JLabel floodModeLabel = new JLabel("Flood mode:");
        this.floodFillModeCombo = new JComboBox<TMFloodFillController.FloodFillMode>(TMFloodFillController.FloodFillMode.values());
        this.floodFillModeCombo.setSelectedItem((Object)TMFloodFillController.FloodFillMode.REPLACE);
        this.floodFillModeCombo.setFocusable(false);
        this.floodFillModeCombo.setPreferredSize(new Dimension(130, 20));
        this.floodFillModeCombo.addActionListener(e -> {
            TMFloodFillController.FloodFillMode mode = (TMFloodFillController.FloodFillMode)((Object)((Object)this.floodFillModeCombo.getSelectedItem()));
            if (mode != null) {
                this.floodFillController.setFloodFillMode(mode);
                panel.setToolTipText(mode.getTooltip());
                this.floodFillModeCombo.setToolTipText(mode.getTooltip());
            }
        });
        this.floodFillModeCombo.setSelectedItem((Object)this.floodFillController.getFloodFillMode());
        panel.add((Component)floodModeLabel, "aligny center");
        panel.add(this.floodFillModeCombo, "aligny center");
        panel.setBackground(OPTIONS_BACKGROUND);
        panel.setBorder(BorderFactory.createLineBorder(OPTIONS_BORDER));
        return panel;
    }

    private JPanel initFloodEraseModePanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 4 8 4 8, gap 4", "", "[center]"));
        JLabel floodEraseModeLabel = new JLabel("Flood erase:");
        this.floodEraseModeCombo = new JComboBox<TMFloodFillController.FloodEraseMode>(TMFloodFillController.FloodEraseMode.values());
        this.floodEraseModeCombo.setSelectedItem((Object)TMFloodFillController.FloodEraseMode.REMOVE_ALL);
        this.floodEraseModeCombo.setFocusable(false);
        this.floodEraseModeCombo.setPreferredSize(new Dimension(130, 20));
        this.floodEraseModeCombo.addActionListener(e -> {
            TMFloodFillController.FloodEraseMode mode = (TMFloodFillController.FloodEraseMode)((Object)((Object)this.floodEraseModeCombo.getSelectedItem()));
            if (mode != null) {
                this.floodFillController.setFloodEraseMode(mode);
                panel.setToolTipText(mode.getTooltip());
                this.floodEraseModeCombo.setToolTipText(mode.getTooltip());
            }
        });
        this.floodEraseModeCombo.setSelectedItem((Object)this.floodFillController.getFloodEraseMode());
        panel.add((Component)floodEraseModeLabel, "aligny center");
        panel.add(this.floodEraseModeCombo, "aligny center");
        panel.setBackground(OPTIONS_BACKGROUND);
        panel.setBorder(BorderFactory.createLineBorder(OPTIONS_BORDER));
        return panel;
    }

    private JToggleButton addActionButton(String toolTipText, Mode mode, boolean visibility, String iconPath) {
        JToggleButton button = new JToggleButton();
        button.setIcon(this.getIcon(iconPath));
        button.setToolTipText(toolTipText);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setFocusable(false);
        button.addItemListener(ev -> {
            if (ev.getStateChange() == 1) {
                this.setMode(mode);
                if (this.brushOptionsPanel != null) {
                    this.brushOptionsPanel.setVisible(visibility);
                }
                if (this.paintModePanel != null && this.eraseModePanel != null && this.floodFillModePanel != null && this.floodEraseModePanel != null) {
                    this.paintModePanel.setVisible(false);
                    this.eraseModePanel.setVisible(false);
                    this.floodFillModePanel.setVisible(false);
                    this.floodEraseModePanel.setVisible(false);
                    if (button == this.drawBtn) {
                        this.paintModePanel.setVisible(true);
                    } else if (button == this.eraseBtn) {
                        this.eraseModePanel.setVisible(true);
                    } else if (button == this.floodFillBtn) {
                        this.floodFillModePanel.setVisible(true);
                    } else if (button == this.floodEraseBtn) {
                        this.floodEraseModePanel.setVisible(true);
                    }
                }
            }
        });
        this.group.add(button);
        return button;
    }

    private JPanel initBrushSizePanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 4 8 4 8, gap 4, aligny center", "", ""));
        JLabel label = new JLabel("Brush size:");
        JSlider brushSizeSlider = this.initBrushSizeSlider();
        JLabel valueLabel = this.initSliderValueLabel(brushSizeSlider);
        panel.add((Component)label, "aligny center");
        panel.add((Component)brushSizeSlider, "width 100:150:200, aligny center");
        panel.add((Component)valueLabel, "width 20:25:30, aligny center");
        panel.setBackground(OPTIONS_BACKGROUND);
        panel.setBorder(BorderFactory.createLineBorder(OPTIONS_BORDER));
        return panel;
    }

    private JPanel initPaintModePanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 4 8 4 8, gap 4", "", "[center]"));
        JLabel paintModeLabel = new JLabel("Paint mode:");
        this.paintModeCombo = new JComboBox<TMLabelBrushController.PaintBrushMode>(TMLabelBrushController.PaintBrushMode.values());
        this.paintModeCombo.setToolTipText("");
        this.paintModeCombo.setFocusable(false);
        this.paintModeCombo.setMaximumRowCount(5);
        this.paintModeCombo.addActionListener(e -> {
            TMLabelBrushController.PaintBrushMode mode = (TMLabelBrushController.PaintBrushMode)((Object)((Object)this.paintModeCombo.getSelectedItem()));
            if (mode != null) {
                this.brushController.setPaintBrushMode(mode);
                panel.setToolTipText(mode.getTooltip());
                this.paintModeCombo.setToolTipText(mode.getTooltip());
            }
        });
        this.paintModeCombo.setSelectedItem((Object)this.brushController.getPaintBrushMode());
        panel.add(paintModeLabel);
        panel.add(this.paintModeCombo, "width 100:120:150");
        panel.setBackground(OPTIONS_BACKGROUND);
        panel.setBorder(BorderFactory.createLineBorder(OPTIONS_BORDER));
        return panel;
    }

    private JPanel initEraseModePanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 4 8 4 8, gap 4", "", "[center]"));
        JLabel eraseModeLabel = new JLabel("Erase mode:");
        this.eraseModeCombo = new JComboBox<TMLabelBrushController.EraseBrushMode>(TMLabelBrushController.EraseBrushMode.values());
        this.eraseModeCombo.setFocusable(false);
        this.eraseModeCombo.setMaximumRowCount(5);
        this.eraseModeCombo.addActionListener(e -> {
            TMLabelBrushController.EraseBrushMode mode = (TMLabelBrushController.EraseBrushMode)((Object)((Object)this.eraseModeCombo.getSelectedItem()));
            if (mode != null) {
                this.brushController.setEraseBrushMode((TMLabelBrushController.EraseBrushMode)((Object)((Object)this.eraseModeCombo.getSelectedItem())));
                panel.setToolTipText(mode.getTooltip());
                this.eraseModeCombo.setToolTipText(mode.getTooltip());
            }
        });
        this.eraseModeCombo.setSelectedItem((Object)this.brushController.getEraseBrushMode());
        panel.add(eraseModeLabel);
        panel.add(this.eraseModeCombo, "width 100:120:150");
        panel.setBackground(OPTIONS_BACKGROUND);
        panel.setBorder(BorderFactory.createLineBorder(OPTIONS_BORDER));
        return panel;
    }

    private void setMode(Mode mode) {
        this.mode.setActive(false);
        this.mode = mode;
        this.mode.setActive(true);
    }

    private ImageIcon getIcon(String iconPath) {
        return new ImageIcon(this.getClass().getResource(iconPath));
    }

    private JSlider initBrushSizeSlider() {
        JSlider brushSize = new JSlider(1, 50, (int)this.brushController.getBrushDiameter());
        brushSize.setFocusable(false);
        brushSize.setPaintTrack(true);
        brushSize.addChangeListener(e -> this.brushController.setBrushDiameter(brushSize.getValue()));
        brushSize.setOpaque(false);
        this.brushController.brushDiameterListeners().addListener(() -> {
            double diameter = this.brushController.getBrushDiameter();
            brushSize.setValue((int)diameter);
        });
        return brushSize;
    }

    private JLabel initSliderValueLabel(JSlider brushSize) {
        JLabel valLabel = new JLabel(String.valueOf(brushSize.getValue()));
        brushSize.addChangeListener(e -> valLabel.setText(String.valueOf(brushSize.getValue())));
        return valLabel;
    }

    public void install(Actions actions) {
        Mode panActive = this.createMode(ignore -> {}, this.moveBtn);
        Mode brushActive = this.createMode(this.brushController::setBrushActive, this.drawBtn);
        Mode eraserActive = this.createMode(this.brushController::setEraserActive, this.eraseBtn);
        Mode floodFillActive = this.createMode(this.floodFillController::setFloodFillActive, this.floodFillBtn);
        Mode fillEraseActive = this.createMode(this.floodFillController::setRemoveBlobActive, this.floodEraseBtn);
        Mode selectLabelActive = this.createMode(this.selectLabelController::setActive, this.selectLabelBtn);
        actions.runnableAction(() -> this.setMode(panActive), SELECT_PAN_TOOL, SELECT_PAN_TOOL_KEYS);
        actions.runnableAction(() -> this.setMode(brushActive), SELECT_DRAW_TOOL, SELECT_DRAW_TOOL_KEYS);
        actions.runnableAction(() -> this.setMode(eraserActive), SELECT_ERASE_TOOL, SELECT_ERASE_TOOL_KEYS);
        actions.runnableAction(() -> this.setMode(floodFillActive), SELECT_FLOOD_FILL_TOOL, SELECT_FLOOD_FILL_TOOL_KEYS);
        actions.runnableAction(() -> this.setMode(fillEraseActive), SELECT_ERASE_FILL_TOOL, SELECT_ERASE_FILL_TOOL_KEYS);
        actions.runnableAction(() -> this.setMode(selectLabelActive), SELECT_LABEL_TOOL, SELECT_LABEL_KEYS);
    }

    private Mode createMode(final BooleanConsumer runnable, final JToggleButton btn) {
        return new Mode(){

            @Override
            public void setActive(boolean active) {
                runnable.accept(active);
                btn.setSelected(active);
            }
        };
    }

    @Plugin(type=CommandDescriptionProvider.class)
    public static class Descriptions
    extends CommandDescriptionProvider {
        public Descriptions() {
            super(TMLabKitFrame.KEY_CONFIG_SCOPE, new String[]{"trackmate-labkit"});
        }

        public void getCommandDescriptions(CommandDescriptions descriptions) {
            descriptions.add(TMLabelToolsPanel.SELECT_PAN_TOOL, SELECT_PAN_TOOL_KEYS, "Make the pan tool active.");
            descriptions.add(TMLabelToolsPanel.SELECT_DRAW_TOOL, SELECT_DRAW_TOOL_KEYS, "Make the draw tool active.");
            descriptions.add(TMLabelToolsPanel.SELECT_FLOOD_FILL_TOOL, SELECT_FLOOD_FILL_TOOL_KEYS, "Make the flood fill tool active.");
            descriptions.add(TMLabelToolsPanel.SELECT_ERASE_TOOL, SELECT_ERASE_TOOL_KEYS, "Make the erase tool active.");
            descriptions.add(TMLabelToolsPanel.SELECT_ERASE_FILL_TOOL, SELECT_ERASE_FILL_TOOL_KEYS, "Make the erase fill tool active.");
            descriptions.add(TMLabelToolsPanel.SELECT_LABEL_TOOL, SELECT_LABEL_KEYS, "Make the select label tool active.");
        }
    }

    private static interface Mode {
        public void setActive(boolean var1);
    }
}

