/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.trackscheme;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxICell;
import com.mxgraph.swing.util.mxGraphActions;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.view.mxGraph;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.visualization.trackscheme.JGraphXAdapter;
import fiji.plugin.trackmate.visualization.trackscheme.TrackSchemeGraphComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;

public class TrackSchemeActions {
    private static final int PAN_AMOUNT = 100;
    private static Action zoomInAction = mxGraphActions.getZoomInAction();
    private static Action zoomOutAction;

    private TrackSchemeActions() {
    }

    public static Action getEditAction(TrackSchemeGraphComponent graphComponent) {
        return new EditAction("edit", Icons.EDIT_ICON, graphComponent);
    }

    public static Action getHomeAction(TrackSchemeGraphComponent graphComponent) {
        return new HomeAction("home", Icons.HOME_ICON, graphComponent);
    }

    public static Action getEndAction(TrackSchemeGraphComponent graphComponent) {
        return new EndAction("end", Icons.END_ICON, graphComponent);
    }

    public static Action getResetZoomAction(TrackSchemeGraphComponent graphComponent) {
        return new ResetZoomAction("resetZoom", Icons.RESET_ZOOM_ICON, graphComponent);
    }

    public static Action getZoomInAction(final TrackSchemeGraphComponent graphComponent) {
        return new AbstractAction("zoomIn", Icons.ZOOM_IN_ICON){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                graphComponent.zoomIn();
            }
        };
    }

    public static Action getZoomOutAction(final TrackSchemeGraphComponent graphComponent) {
        return new AbstractAction("zoomOut", Icons.ZOOM_OUT_ICON){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                graphComponent.zoomOut();
            }
        };
    }

    public static Action getSelectNoneAction() {
        return mxGraphActions.getSelectNoneAction();
    }

    public static Action getSelectAllAction() {
        return mxGraphActions.getSelectAllAction();
    }

    public static Action getPanDownAction(TrackSchemeGraphComponent graphComponent) {
        return new PanAction("panDown", Icons.ARROW_DOWN_ICON, graphComponent, 0, 100);
    }

    public static Action getPanLeftAction(TrackSchemeGraphComponent graphComponent) {
        return new PanAction("panLeft", Icons.ARROW_LEFT_ICON, graphComponent, -100, 0);
    }

    public static Action getPanRightAction(TrackSchemeGraphComponent graphComponent) {
        return new PanAction("panRight", Icons.ARROW_RIGHT_ICON, graphComponent, 100, 0);
    }

    public static Action getPanUpAction(TrackSchemeGraphComponent graphComponent) {
        return new PanAction("panUp", Icons.ARROW_UP_ICON, graphComponent, 0, -100);
    }

    public static Action getPanDownLeftAction(TrackSchemeGraphComponent graphComponent) {
        return new PanAction("panDownLeft", Icons.ARROW_DOWNLEFT_ICON, graphComponent, -100, 100);
    }

    public static Action getPanDownRightAction(TrackSchemeGraphComponent graphComponent) {
        return new PanAction("panDownRight", Icons.ARROW_DOWNRIGHT_ICON, graphComponent, 100, 100);
    }

    public static Action getPanUpLeftAction(TrackSchemeGraphComponent graphComponent) {
        return new PanAction("panUpLeft", Icons.ARROW_UPLEFT_ICON, graphComponent, -100, -100);
    }

    public static Action getPanUpRightAction(TrackSchemeGraphComponent graphComponent) {
        return new PanAction("panUpRight", Icons.ARROW_UPRIGHT_ICON, graphComponent, 100, -100);
    }

    private static List<mxCell> getSelectionVertices(mxGraph graph) {
        Object[] selection = graph.getSelectionCells();
        ArrayList<mxCell> vertices = new ArrayList<mxCell>();
        for (Object obj : selection) {
            mxCell cell = (mxCell)obj;
            if (!cell.isVertex()) continue;
            vertices.add(cell);
        }
        return vertices;
    }

    private static List<mxCell> getSelectionEdges(mxGraph graph) {
        Object[] selection = graph.getSelectionCells();
        ArrayList<mxCell> edges = new ArrayList<mxCell>();
        for (Object obj : selection) {
            mxCell cell = (mxCell)obj;
            if (!cell.isEdge()) continue;
            edges.add(cell);
        }
        return edges;
    }

    static {
        zoomInAction.putValue("SmallIcon", Icons.ZOOM_IN_ICON);
        zoomOutAction = mxGraphActions.getZoomOutAction();
        zoomOutAction.putValue("SmallIcon", Icons.ZOOM_OUT_ICON);
    }

    public static class EditAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final TrackSchemeGraphComponent graphComponent;

        public EditAction(String name, Icon icon, TrackSchemeGraphComponent graphComponent) {
            super(name, icon);
            this.graphComponent = graphComponent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.multiEditSpotName(this.graphComponent, e);
        }

        private void multiEditSpotName(final TrackSchemeGraphComponent lGraphComponent, ActionEvent triggerEvent) {
            final JGraphXAdapter graph = lGraphComponent.getGraph();
            final List vertices = TrackSchemeActions.getSelectionVertices(graph);
            if (vertices.isEmpty()) {
                return;
            }
            Point mousePosition = lGraphComponent.getMousePosition();
            final mxCell tc = null != mousePosition ? this.getClosestCell(vertices, mousePosition) : (mxCell)vertices.get(0);
            vertices.remove(tc);
            lGraphComponent.startEditingAtCell(tc, triggerEvent);
            lGraphComponent.addListener("labelChanged", new mxEventSource.mxIEventListener(){

                public void invoke(Object sender, mxEventObject evt) {
                    for (mxCell cell : vertices) {
                        cell.setValue(tc.getValue());
                        graph.getSpotFor((mxICell)cell).setName(tc.getValue().toString());
                    }
                    lGraphComponent.refresh();
                    lGraphComponent.removeListener(this);
                }
            });
        }

        private mxCell getClosestCell(Iterable<mxCell> vertices, Point2D point) {
            double min_dist = Double.POSITIVE_INFINITY;
            mxCell target_cell = null;
            for (mxCell cell : vertices) {
                Point location = cell.getGeometry().getPoint();
                double dist = location.distanceSq(point);
                if (!(dist < min_dist)) continue;
                min_dist = dist;
                target_cell = cell;
            }
            return target_cell;
        }
    }

    private static class EndAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final TrackSchemeGraphComponent graphComponent;

        public EndAction(String name, Icon icon, TrackSchemeGraphComponent graphComponent) {
            super(name, icon);
            this.graphComponent = graphComponent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxCell cell = null;
            JGraphXAdapter graph = this.graphComponent.getGraph();
            List vertices = TrackSchemeActions.getSelectionVertices(graph);
            if (!vertices.isEmpty()) {
                int maxFrame = Integer.MIN_VALUE;
                for (mxCell mxCell2 : vertices) {
                    int frame = graph.getSpotFor((mxICell)mxCell2).getFeature("FRAME").intValue();
                    if (frame <= maxFrame) continue;
                    maxFrame = frame;
                    cell = mxCell2;
                }
            } else {
                List edges = TrackSchemeActions.getSelectionEdges(graph);
                if (!edges.isEmpty()) {
                    int maxFrame = Integer.MIN_VALUE;
                    for (mxCell mxCell3 : edges) {
                        mxICell target = mxCell3.getTarget();
                        int frame = graph.getSpotFor(target).getFeature("FRAME").intValue();
                        if (frame <= maxFrame) continue;
                        maxFrame = frame;
                        cell = mxCell3;
                    }
                    cell = (mxCell)edges.get(edges.size() - 1);
                } else {
                    return;
                }
            }
            this.graphComponent.scrollCellToVisible(cell, true);
        }
    }

    private static class HomeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final TrackSchemeGraphComponent graphComponent;

        public HomeAction(String name, Icon icon, TrackSchemeGraphComponent graphComponent) {
            super(name, icon);
            this.graphComponent = graphComponent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            mxCell cell = null;
            JGraphXAdapter graph = this.graphComponent.getGraph();
            List vertices = TrackSchemeActions.getSelectionVertices(graph);
            if (!vertices.isEmpty()) {
                int minFrame = Integer.MAX_VALUE;
                for (mxCell mxCell2 : vertices) {
                    int frame = graph.getSpotFor((mxICell)mxCell2).getFeature("FRAME").intValue();
                    if (frame >= minFrame) continue;
                    minFrame = frame;
                    cell = mxCell2;
                }
            } else {
                List edges = TrackSchemeActions.getSelectionEdges(graph);
                if (!edges.isEmpty()) {
                    int minFrame = Integer.MAX_VALUE;
                    for (mxCell mxCell3 : edges) {
                        mxICell target = mxCell3.getTarget();
                        int frame = graph.getSpotFor(target).getFeature("FRAME").intValue();
                        if (frame >= minFrame) continue;
                        minFrame = frame;
                        cell = mxCell3;
                    }
                    cell = (mxCell)edges.get(edges.size() - 1);
                } else {
                    return;
                }
            }
            this.graphComponent.scrollCellToVisible(cell, true);
        }
    }

    private static class ResetZoomAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final TrackSchemeGraphComponent graphComponent;

        public ResetZoomAction(String name, Icon icon, TrackSchemeGraphComponent graphComponent) {
            super(name, icon);
            this.graphComponent = graphComponent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.graphComponent.zoomTo(1.0, false);
        }
    }

    private static class PanAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final int amountx;
        private final int amounty;
        private final TrackSchemeGraphComponent graphComponent;

        public PanAction(String name, Icon icon, TrackSchemeGraphComponent graphComponent, int amountx, int amounty) {
            super(name, icon);
            this.graphComponent = graphComponent;
            this.amountx = amountx;
            this.amounty = amounty;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Rectangle r = this.graphComponent.getViewport().getViewRect();
            int right = r.x + (this.amountx < 0 ? 0 : r.width) + this.amountx;
            int bottom = r.y + (this.amounty < 0 ? 0 : r.height) + this.amounty;
            this.graphComponent.getGraphControl().scrollRectToVisible(new Rectangle(right, bottom, 0, 0));
        }
    }
}

