/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.codec.JPEGTileDecoder;
import io.scif.config.SCIFIOConfig;
import io.scif.util.FormatTools;
import java.io.IOException;
import net.imagej.axis.Axes;
import net.imglib2.Interval;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;
import org.scijava.plugin.Plugin;

@Plugin(type=Format.class, name="Tile JPEG", priority=-100.0)
public class JPEGTileFormat
extends AbstractFormat {
    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"jpg", "jpeg"};
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Override
        protected String[] createDomainArray() {
            return new String[]{"Graphics"};
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
            Metadata meta = (Metadata)this.getMetadata();
            byte[] buf = plane.getBytes();
            int xIndex = meta.get(imageIndex).getAxisIndex(Axes.X);
            int yIndex = meta.get(imageIndex).getAxisIndex(Axes.Y);
            int x = (int)bounds.min(xIndex);
            int y = (int)bounds.min(yIndex);
            int w = (int)bounds.dimension(xIndex);
            int h = (int)bounds.dimension(yIndex);
            FormatTools.checkPlaneForReading(meta, imageIndex, planeIndex, buf.length, bounds);
            int c = (int)meta.get(imageIndex).getAxisLength(Axes.CHANNEL);
            for (int ty = y; ty < y + h; ++ty) {
                byte[] scanline = meta.getDecoder().getScanline(ty);
                if (scanline == null) {
                    meta.getDecoder().initialize(this.getHandle(), 0);
                    scanline = meta.getDecoder().getScanline(ty);
                }
                System.arraycopy(scanline, c * x, buf, (ty - y) * c * w, c * w);
            }
            return plane;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        @Override
        protected void typedParse(DataHandle<Location> handle, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            if (!handle.exists() || handle.length() == 0L) {
                throw new FormatException("Trying to read from non-existing file!");
            }
            JPEGTileDecoder decoder = new JPEGTileDecoder(this.getContext());
            meta.setDecoder(decoder);
            decoder.initialize(this.getSource(), 0, 1);
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        private JPEGTileDecoder decoder;

        public JPEGTileDecoder getDecoder() {
            return this.decoder;
        }

        public void setDecoder(JPEGTileDecoder decoder) {
            this.decoder = decoder;
        }

        @Override
        public void populateImageMetadata() {
            this.createImageMetadata(1);
            ImageMetadata iMeta = this.get(0);
            iMeta.setAxisTypes(Axes.CHANNEL, Axes.X, Axes.Y);
            iMeta.setPlanarAxisCount(3);
            iMeta.setLittleEndian(false);
            iMeta.setAxisLength(Axes.X, (long)this.decoder.getWidth());
            iMeta.setAxisLength(Axes.Y, (long)this.decoder.getHeight());
            iMeta.setAxisLength(Axes.CHANNEL, (long)this.decoder.getScanline(0).length / iMeta.getAxisLength(Axes.X));
            iMeta.setPixelType(1);
            iMeta.setMetadataComplete(true);
            iMeta.setIndexed(false);
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            if (!fileOnly) {
                if (this.decoder != null) {
                    this.decoder.close();
                }
                this.decoder = null;
            }
            super.close(fileOnly);
        }
    }
}

