/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.WindowManager;
import ij.io.FileInfo;
import ij.io.FileSaver;
import ij.io.SaveDialog;
import ij.io.TiffEncoder;
import ij.plugin.PlugIn;
import java.awt.image.ColorModel;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import sc.fiji.i5d.Image5D;
import sc.fiji.i5d.cal.ChannelCalibration;
import sc.fiji.i5d.cal.ChannelDisplayProperties;

public class Save_Image5D
implements PlugIn {
    public void run(String arg) {
        if (IJ.versionLessThan((String)"1.35c")) {
            return;
        }
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.error((String)"No Image selected.");
            return;
        }
        if (!(imp instanceof Image5D)) {
            // empty if block
        }
        String name = imp.getTitle();
        SaveDialog sd = new SaveDialog("Save as Image5D", name, ".tif");
        if ((name = sd.getFileName()) == null) {
            return;
        }
        String directory = sd.getDirectory();
        imp.startTiming();
        this.saveAsImage5D(imp, name, directory);
    }

    public boolean saveAsImage5D(ImagePlus imp, String name, String directory) {
        if (imp == null) {
            return false;
        }
        String path = directory + name;
        FileInfo fi = imp.getFileInfo();
        Object info = imp.getProperty("Info");
        if (info != null && info instanceof String) {
            fi.info = (String)info;
        }
        if (fi.pixels == null && imp.getStack().isVirtual()) {
            IJ.error((String)"Save As Tiff", (String)"Virtual stacks not supported.");
            return false;
        }
        String description = new FileSaver(imp).getDescriptionString();
        fi.sliceLabels = imp.getImageStack().getSliceLabels();
        if (imp instanceof Image5D) {
            Image5D i5d = (Image5D)imp;
            LookUpTable lut = new LookUpTable(LookUpTable.createGrayscaleColorModel((boolean)false));
            fi.lutSize = lut.getMapSize();
            fi.reds = lut.getReds();
            fi.greens = lut.getGreens();
            fi.blues = lut.getBlues();
            description = description.substring(0, description.length() - 1);
            description = description + "Image5D=" + "1.2.6-DEV" + "\n";
            fi.description = description = description + "\u0000";
            int nChannelEntries = 7;
            int metadataSize = 7 * i5d.getNChannels();
            int[] metaDataTypes = new int[metadataSize];
            byte[][] metaData = new byte[metadataSize][];
            i5d.storeCurrentChannelProperties();
            int metadataCounter = 0;
            try {
                for (int c = 1; c <= i5d.getNChannels(); ++c) {
                    int v;
                    ByteArrayOutputStream bs = new ByteArrayOutputStream();
                    DataOutputStream ds = new DataOutputStream(bs);
                    ChannelCalibration chCalibration = i5d.getChannelCalibration(c);
                    ChannelDisplayProperties chDispProps = i5d.getChannelDisplayProperties(c);
                    metaDataTypes[metadataCounter] = 0x4C5554;
                    ds.writeInt(1);
                    ds.writeInt(c);
                    ColorModel cm = chDispProps.getColorModel();
                    for (v = 0; v <= 255; ++v) {
                        ds.writeByte(cm.getRed(v));
                    }
                    for (v = 0; v <= 255; ++v) {
                        ds.writeByte(cm.getGreen(v));
                    }
                    for (v = 0; v <= 255; ++v) {
                        ds.writeByte(cm.getBlue(v));
                    }
                    ds.flush();
                    metaData[metadataCounter] = bs.toByteArray();
                    bs.reset();
                    metaDataTypes[++metadataCounter] = 4400706;
                    ds.writeInt(1);
                    ds.writeInt(c);
                    ds.writeDouble(chDispProps.getMinValue());
                    ds.writeDouble(chDispProps.getMaxValue());
                    ds.flush();
                    metaData[metadataCounter] = bs.toByteArray();
                    bs.reset();
                    metaDataTypes[++metadataCounter] = 5523538;
                    ds.writeInt(1);
                    ds.writeInt(c);
                    ds.writeDouble(chDispProps.getMinThreshold());
                    ds.writeDouble(chDispProps.getMaxThreshold());
                    ds.writeInt(chDispProps.getLutUpdateMode());
                    ds.flush();
                    metaData[metadataCounter] = bs.toByteArray();
                    bs.reset();
                    metaDataTypes[++metadataCounter] = 4674113;
                    ds.writeInt(1);
                    ds.writeInt(c);
                    ds.writeBoolean(chDispProps.isDisplayedGray());
                    ds.flush();
                    metaData[metadataCounter] = bs.toByteArray();
                    bs.reset();
                    metaDataTypes[++metadataCounter] = 5199436;
                    ds.writeInt(1);
                    ds.writeInt(c);
                    ds.writeBoolean(chDispProps.isDisplayedInOverlay());
                    ds.flush();
                    metaData[metadataCounter] = bs.toByteArray();
                    ++metadataCounter;
                    bs.reset();
                    if (chCalibration.getLabel() != null && chCalibration.getLabel() != "") {
                        metaDataTypes[metadataCounter] = 0x4C424C;
                        ds.writeInt(1);
                        ds.writeInt(c);
                        ds.write(chCalibration.getLabel().getBytes());
                        ds.flush();
                        metaData[metadataCounter] = bs.toByteArray();
                        ++metadataCounter;
                        bs.reset();
                    }
                    if (chCalibration.getFunction() != 20) {
                        boolean coefficientsNull;
                        metaDataTypes[metadataCounter] = 4407628;
                        ds.writeInt(1);
                        ds.writeInt(c);
                        ds.writeInt(chCalibration.getFunction());
                        boolean bl = coefficientsNull = chCalibration.getCoefficients() == null;
                        if (!coefficientsNull) {
                            ds.writeInt(chCalibration.getCoefficients().length);
                            for (int n = 0; n < chCalibration.getCoefficients().length; ++n) {
                                ds.writeDouble(chCalibration.getCoefficients()[n]);
                            }
                        } else {
                            ds.writeInt(0);
                        }
                        ds.writeBoolean(chCalibration.isZeroClip());
                        ds.write(chCalibration.getValueUnit().getBytes());
                        ds.flush();
                        metaData[metadataCounter] = bs.toByteArray();
                        ++metadataCounter;
                        bs.reset();
                    }
                    bs.close();
                }
            }
            catch (IOException c) {
                // empty catch block
            }
            fi.metaDataTypes = new int[metadataCounter];
            fi.metaData = new byte[metadataCounter][];
            for (int n = 0; n < metadataCounter; ++n) {
                fi.metaDataTypes[n] = metaDataTypes[n];
                fi.metaData[n] = metaData[n];
            }
        }
        try {
            TiffEncoder file = new TiffEncoder(fi);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
            file.write(out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        this.updateImp(imp, fi, name, directory, 2);
        return true;
    }

    private void updateImp(ImagePlus imp, FileInfo fi, String name, String directory, int fileFormat) {
        imp.changes = false;
        if (name != null) {
            fi.fileFormat = fileFormat;
            fi.fileName = name;
            fi.directory = directory;
            if (fileFormat == 2) {
                fi.offset = 768;
            }
            fi.description = null;
            imp.setTitle(name);
            imp.setFileInfo(fi);
        }
    }

    void showErrorMessage(IOException e) {
        IJ.error((String)("An error occured writing the file.\n \n" + e));
    }
}

