/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.dirgra;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.jruby.dirgra.DataIterable;
import org.jruby.dirgra.DirectedGraph;
import org.jruby.dirgra.Edge;
import org.jruby.dirgra.EdgeTypeIterable;
import org.jruby.dirgra.ExplicitVertexID;

public class Vertex<T extends ExplicitVertexID>
implements Comparable<Vertex<T>> {
    private static final Edge[] EMPTY_EDGE_LIST = new Edge[0];
    private DirectedGraph graph;
    private T data;
    private Edge<T>[] incoming = EMPTY_EDGE_LIST;
    private int incomingLength = 0;
    private Edge<T>[] outgoing = EMPTY_EDGE_LIST;
    private int outgoingLength = 0;
    int id;

    public Vertex(DirectedGraph graph, T data, int id) {
        this.graph = graph;
        this.data = data;
        this.id = id;
    }

    public void addEdgeTo(Vertex destination) {
        this.addEdgeTo(destination, (Object)null);
    }

    public void addEdgeTo(Vertex destination, Object type) {
        Edge newEdge = this.graph.addEdge(new Edge(this, destination, type));
        this.addOutgoingEdge(newEdge);
        destination.addIncomingEdge(newEdge);
    }

    public void addEdgeTo(T destination) {
        this.addEdgeTo(destination, null);
    }

    public void addEdgeTo(T destination, Object type) {
        Vertex<T> destinationVertex = this.graph.findOrCreateVertexFor(destination);
        this.addEdgeTo(destinationVertex, type);
    }

    public boolean removeEdgeTo(Vertex destination) {
        for (int i = 0; i < this.outgoingLength; ++i) {
            Edge<T> edge = this.outgoing[i];
            if (edge.getDestination() != destination) continue;
            this.graph.removeEdge(edge);
            return true;
        }
        return false;
    }

    protected void addOutgoingEdge(Edge<T> newEdge) {
        for (int i = 0; i < this.outgoingLength; ++i) {
            if (!this.outgoing[i].equals(newEdge)) continue;
            return;
        }
        if (this.outgoingLength >= this.outgoing.length) {
            this.outgoing = this.graph.growEdges(this.outgoing, this.outgoingLength);
        }
        this.outgoing[this.outgoingLength++] = newEdge;
    }

    protected void addIncomingEdge(Edge<T> newEdge) {
        for (int i = 0; i < this.incomingLength; ++i) {
            if (this.incoming[i] != newEdge) continue;
            return;
        }
        if (this.incomingLength >= this.incoming.length) {
            this.incoming = this.graph.growEdges(this.incoming, this.incomingLength);
        }
        this.incoming[this.incomingLength++] = newEdge;
    }

    protected void removeOutgoingEdge(Edge<T> edge) {
        int splitIndex = -1;
        for (int i = 0; i < this.outgoingLength; ++i) {
            if (!this.outgoing[i].equals(edge)) continue;
            splitIndex = i;
            break;
        }
        if (splitIndex == -1) {
            return;
        }
        if (splitIndex != this.outgoingLength - 1) {
            System.arraycopy(this.outgoing, splitIndex + 1, this.outgoing, splitIndex, this.outgoingLength - 1 - splitIndex);
        }
        this.outgoing[this.outgoingLength - 1] = null;
        --this.outgoingLength;
    }

    protected void removeIncomingEdge(Edge<T> edge) {
        int splitIndex = -1;
        for (int i = 0; i < this.incomingLength; ++i) {
            if (!this.incoming[i].equals(edge)) continue;
            splitIndex = i;
            break;
        }
        if (splitIndex == -1) {
            return;
        }
        if (splitIndex != this.incomingLength - 1) {
            System.arraycopy(this.incoming, splitIndex + 1, this.incoming, splitIndex, this.incomingLength - 1 - splitIndex);
        }
        this.incoming[this.incomingLength - 1] = null;
        --this.incomingLength;
    }

    public void removeAllIncomingEdges() {
        while (this.incomingLength > 0) {
            this.graph.removeEdge(this.incoming[0]);
        }
        this.incoming = EMPTY_EDGE_LIST;
    }

    public void removeAllOutgoingEdges() {
        while (this.outgoingLength > 0) {
            this.graph.removeEdge(this.outgoing[0]);
        }
        this.outgoing = EMPTY_EDGE_LIST;
    }

    public void removeAllEdges() {
        this.removeAllIncomingEdges();
        this.removeAllOutgoingEdges();
    }

    public int inDegree() {
        return this.incomingLength;
    }

    public int outDegree() {
        return this.outgoingLength;
    }

    public Iterable<Edge<T>> getIncomingEdgesOfType(Object type) {
        return new EdgeTypeIterable<T>(this.incoming, this.incomingLength, type);
    }

    public Iterable<Edge<T>> getIncomingEdgesNotOfType(Object type) {
        return new EdgeTypeIterable<T>(this.incoming, this.incomingLength, type, true);
    }

    public Iterable<Edge<T>> getOutgoingEdgesOfType(Object type) {
        return new EdgeTypeIterable<T>(this.outgoing, this.outgoingLength, type);
    }

    public T getIncomingSourceData() {
        Edge<T> edge = this.getFirstEdge(this.getIncomingEdges().iterator());
        return edge == null ? null : (T)edge.getSource().getData();
    }

    public T getIncomingSourceDataOfType(Object type) {
        Edge<T> edge = this.getFirstEdge(this.getIncomingEdgesOfType(type).iterator());
        return edge == null ? null : (T)edge.getSource().getData();
    }

    public Iterable<T> getIncomingSourcesData() {
        return new DataIterable<T>(this.incoming, this.incomingLength, null, true, true);
    }

    public Iterable<T> getIncomingSourcesDataOfType(Object type) {
        return new DataIterable<T>(this.incoming, this.incomingLength, type, true, false);
    }

    public Iterable<T> getIncomingSourcesDataNotOfType(Object type) {
        return new DataIterable<T>(this.incoming, this.incomingLength, type, true, true);
    }

    public Iterable<Edge<T>> getOutgoingEdgesNotOfType(Object type) {
        return new EdgeTypeIterable<T>(this.outgoing, this.outgoingLength, type, true);
    }

    public Iterable<T> getOutgoingDestinationsData() {
        return new DataIterable<T>(this.outgoing, this.outgoingLength, null, false, true);
    }

    public Iterable<T> getOutgoingDestinationsDataOfType(Object type) {
        return new DataIterable<T>(this.outgoing, this.outgoingLength, type, false, false);
    }

    public Iterable<T> getOutgoingDestinationsDataNotOfType(Object type) {
        return new DataIterable<T>(this.outgoing, this.outgoingLength, type, false, true);
    }

    public T getOutgoingDestinationData() {
        Edge<T> edge = this.getFirstEdge(this.getOutgoingEdges().iterator());
        return edge == null ? null : (T)edge.getDestination().getData();
    }

    public T getOutgoingDestinationDataOfType(Object type) {
        Edge<T> edge = this.getFirstEdge(this.getOutgoingEdgesOfType(type).iterator());
        return edge == null ? null : (T)edge.getDestination().getData();
    }

    private Edge<T> getFirstEdge(Iterator<Edge<T>> iterator) {
        return iterator.hasNext() ? iterator.next() : null;
    }

    public Edge<T> getIncomingEdgeOfType(Object type) {
        return this.getFirstEdge(this.getIncomingEdgesOfType(type).iterator());
    }

    public Edge<T> getOutgoingEdgeOfType(Object type) {
        return this.getFirstEdge(this.getOutgoingEdgesOfType(type).iterator());
    }

    public Edge<T> getIncomingEdge() {
        return this.getFirstEdge(this.getIncomingEdgesNotOfType(null).iterator());
    }

    public Edge<T> getOutgoingEdge() {
        return this.getFirstEdge(this.getOutgoingEdgesNotOfType(null).iterator());
    }

    public Collection<Edge<T>> getIncomingEdges() {
        return Arrays.asList(Arrays.copyOf(this.incoming, this.incomingLength));
    }

    public Collection<Edge<T>> getOutgoingEdges() {
        return Arrays.asList(Arrays.copyOf(this.outgoing, this.outgoingLength));
    }

    public T getData() {
        return this.data;
    }

    public int getID() {
        return this.data.getID();
    }

    public String toString() {
        int i;
        ArrayList<Edge<T>> e;
        boolean found = false;
        StringBuilder buf = new StringBuilder(this.data.toString());
        buf.append(":");
        Collection<Edge<T>> edges = this.getOutgoingEdges();
        int size = edges.size();
        if (size > 0) {
            found = true;
            buf.append(">[");
            e = new ArrayList<Edge<T>>(edges);
            Collections.sort(e, new DestinationCompare());
            for (i = 0; i < size - 1; ++i) {
                buf.append(((Edge)e.get(i)).getDestination().getID()).append(",");
            }
            buf.append(((Edge)e.get(size - 1)).getDestination().getID()).append("]");
        }
        if ((size = (edges = this.getIncomingEdges()).size()) > 0) {
            if (found) {
                buf.append(", ");
            }
            buf.append("<[");
            e = new ArrayList<Edge<T>>(edges);
            Collections.sort(e, new SourceCompare());
            for (i = 0; i < size - 1; ++i) {
                buf.append(((Edge)e.get(i)).getSource().getID()).append(",");
            }
            buf.append(((Edge)e.get(size - 1)).getSource().getID()).append("]");
        }
        buf.append("\n");
        return buf.toString();
    }

    @Override
    public int compareTo(Vertex<T> that) {
        if (this.getID() == that.getID()) {
            return 0;
        }
        if (this.getID() < that.getID()) {
            return -1;
        }
        return 1;
    }

    class DestinationCompare
    implements Comparator<Edge<T>> {
        DestinationCompare() {
        }

        @Override
        public int compare(Edge<T> o1, Edge<T> o2) {
            int i2;
            int i1 = o1.getDestination().getID();
            if (i1 == (i2 = o2.getDestination().getID())) {
                return 0;
            }
            return i1 < i2 ? -1 : 1;
        }
    }

    class SourceCompare
    implements Comparator<Edge<T>> {
        SourceCompare() {
        }

        @Override
        public int compare(Edge<T> o1, Edge<T> o2) {
            int i2;
            int i1 = o1.getSource().getID();
            if (i1 == (i2 = o2.getSource().getID())) {
                return 0;
            }
            return i1 < i2 ? -1 : 1;
        }
    }
}

