/*
 * Decompiled with CFR 0.152.
 */
package selection;

import ij.IJ;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import selection.ExtendedPointMatch;

public class SaveListener
implements ActionListener {
    final ArrayList<ExtendedPointMatch> matches;
    final Frame frame;

    public SaveListener(Frame frame, ArrayList<ExtendedPointMatch> matches) {
        this.matches = matches;
        this.frame = frame;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.matches.size() == 0) {
            IJ.log((String)"List is empty.");
            return;
        }
        String filename = File.separator + "txt";
        JFileChooser fc = new JFileChooser(new File(filename));
        fc.showSaveDialog(this.frame);
        File file = fc.getSelectedFile();
        IJ.log((String)("Saving to '" + file + "' ..."));
        PrintWriter out = SaveListener.openFileWrite(file);
        for (ExtendedPointMatch pm : this.matches) {
            out.println(pm.getP1().getL()[0] + "\t" + pm.getP1().getL()[1] + "\t" + pm.getP1().getL()[2] + "\t" + pm.getP1().getW()[0] + "\t" + pm.getP1().getW()[1] + "\t" + pm.getP1().getW()[2] + "\t" + pm.radius1L + "\t" + pm.radius1W + "\t" + pm.getP2().getL()[0] + "\t" + pm.getP2().getL()[1] + "\t" + pm.getP2().getL()[2] + "\t" + pm.getP2().getW()[0] + "\t" + pm.getP2().getW()[1] + "\t" + pm.getP2().getW()[2] + "\t" + pm.radius2L + "\t" + pm.radius2W);
        }
        out.close();
    }

    private static PrintWriter openFileWrite(File file) {
        PrintWriter outputFile;
        try {
            outputFile = new PrintWriter(new FileWriter(file));
        }
        catch (IOException e) {
            System.out.println("TextFileAccess.openFileWrite(): " + e);
            outputFile = null;
        }
        return outputFile;
    }
}

