/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.cfg;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.renjin.compiler.cfg.BasicBlock;
import org.renjin.compiler.cfg.ControlFlowGraph;
import org.renjin.compiler.cfg.DominanceEdge;

public class DominanceTree {
    private final ControlFlowGraph cfg;
    private final HashMultimap<BasicBlock, BasicBlock> Dom = HashMultimap.create();
    private final Graph<BasicBlock, DominanceEdge> tree = new DirectedSparseGraph();
    private final Multimap<BasicBlock, BasicBlock> dominanceFrontier = HashMultimap.create();

    public DominanceTree(ControlFlowGraph cfg) {
        this.cfg = cfg;
        this.computeDominators();
        this.buildTree();
        this.calculateDominanceFrontiers();
    }

    private void computeDominators() {
        boolean changes;
        this.Dom.put((Object)this.cfg.getEntry(), (Object)this.cfg.getEntry());
        for (BasicBlock n : Iterables.filter(this.cfg.getLiveBasicBlocks(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)this.cfg.getEntry())))) {
            this.Dom.putAll((Object)n, this.cfg.getLiveBasicBlocks());
        }
        do {
            changes = false;
            for (BasicBlock n : Iterables.filter(this.cfg.getLiveBasicBlocks(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)this.cfg.getEntry())))) {
                Sets.SetView newDom = Sets.union(Collections.singleton(n), this.intersection(Iterables.transform((Iterable)this.cfg.getGraph().getPredecessors((Object)n), (Function)new Function<BasicBlock, Set<BasicBlock>>(){

                    public Set<BasicBlock> apply(BasicBlock input) {
                        return DominanceTree.this.Dom.get((Object)input);
                    }
                })));
                Set original = this.Dom.get((Object)n);
                if (original.equals(newDom)) continue;
                this.Dom.replaceValues((Object)n, (Iterable)newDom);
                changes = true;
            }
        } while (changes);
    }

    private void buildTree() {
        for (BasicBlock n : this.cfg.getBasicBlocks()) {
            BasicBlock d = this.calculateImmediateDominator(n);
            if (d == null) continue;
            this.tree.addEdge((Object)new DominanceEdge(), (Object)d, (Object)n, EdgeType.DIRECTED);
        }
    }

    private BasicBlock calculateImmediateDominator(BasicBlock n) {
        for (BasicBlock d : this.strictDominators(n)) {
            if (!this.dominatesImmediately(d, n)) continue;
            return d;
        }
        return null;
    }

    public BasicBlock getImmediateDominator(BasicBlock n) {
        Collection parent2 = this.tree.getPredecessors((Object)n);
        if (parent2.size() != 1) {
            throw new IllegalArgumentException(n.toString());
        }
        return (BasicBlock)parent2.iterator().next();
    }

    public boolean dominatesImmediately(BasicBlock d, BasicBlock n) {
        for (BasicBlock otherDominator : this.strictDominators(n)) {
            if (!this.strictlyDominates(d, otherDominator)) continue;
            return false;
        }
        return true;
    }

    private boolean strictlyDominates(BasicBlock d, BasicBlock n) {
        return !d.equals(n) && this.dominates(d, n);
    }

    private boolean dominates(BasicBlock d, BasicBlock n) {
        return this.Dom.containsEntry((Object)n, (Object)d);
    }

    private Set<BasicBlock> dominators(BasicBlock n) {
        return this.Dom.get((Object)n);
    }

    private Iterable<BasicBlock> strictDominators(BasicBlock n) {
        return Iterables.filter((Iterable)this.Dom.get((Object)n), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)n)));
    }

    private Set<BasicBlock> intersection(Iterable<Set<BasicBlock>> sets) {
        Sets.SetView intersection = null;
        for (Sets.SetView setView : sets) {
            if (intersection == null) {
                intersection = setView;
                continue;
            }
            intersection = Sets.intersection(intersection, setView);
        }
        return intersection == null ? Collections.emptySet() : intersection;
    }

    private void calculateDominanceFrontiers() {
        this.calculateDominanceFrontier(this.cfg.getEntry());
    }

    private void calculateDominanceFrontier(BasicBlock X) {
        for (BasicBlock child : this.tree.getSuccessors((Object)X)) {
            this.calculateDominanceFrontier(child);
        }
        for (BasicBlock Y : this.cfg.getGraph().getSuccessors((Object)X)) {
            if (this.getImmediateDominator(Y) == X) continue;
            this.dominanceFrontier.put((Object)X, (Object)Y);
        }
        for (BasicBlock Z : this.tree.getSuccessors((Object)X)) {
            for (BasicBlock Y : this.dominanceFrontier.get((Object)Z)) {
                if (this.getImmediateDominator(Y) == X) continue;
                this.dominanceFrontier.put((Object)X, (Object)Y);
            }
        }
    }

    public Collection<BasicBlock> getFrontier(BasicBlock bb) {
        return this.dominanceFrontier.get((Object)bb);
    }

    public Collection<BasicBlock> getChildren(BasicBlock x) {
        return this.tree.getSuccessors((Object)x);
    }

    public String toString() {
        return this.tree.toString();
    }
}

