/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.ExpressionVisitor;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.eval.Context;
import org.renjin.sexp.SEXP;

public class LocalVariable
implements Variable {
    private final String name;
    private final int offset;

    public LocalVariable(String name, int offset) {
        this.name = name;
        this.offset = offset;
    }

    @Override
    public void setValue(Context context, Object[] temp, Object value) {
        temp[this.offset] = value;
    }

    @Override
    public Variable replaceVariable(Variable name, Variable newName) {
        return this.equals(name) ? newName : this;
    }

    @Override
    public Object retrieveValue(Context context, Object[] temps) {
        return temps[this.offset];
    }

    @Override
    public Set<Variable> variables() {
        return Collections.singleton(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalVariable other = (LocalVariable)obj;
        return this.name.equals(other.name);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void setChild(int i, Expression expr) {
        throw new IllegalArgumentException();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitLocalVariable(this);
    }

    @Override
    public SEXP getSExpression() {
        throw new UnsupportedOperationException();
    }
}

