/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.statements;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.SimpleExpression;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.compiler.ir.tac.statements.BasicBlockEndingStatement;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.compiler.ir.tac.statements.StatementVisitor;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.SEXP;

public class IfStatement
implements Statement,
BasicBlockEndingStatement {
    private Expression condition;
    private IRLabel trueTarget;
    private IRLabel falseTarget;
    private IRLabel naTarget;

    public IfStatement(Expression condition, IRLabel trueTarget, IRLabel falseTarget, IRLabel naTarget) {
        this.condition = condition;
        this.trueTarget = trueTarget;
        this.falseTarget = falseTarget;
        this.naTarget = naTarget;
    }

    public IfStatement(Expression condition, IRLabel trueTarget, IRLabel falseTarget) {
        this.condition = condition;
        this.trueTarget = trueTarget;
        this.falseTarget = falseTarget;
        this.naTarget = null;
    }

    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public Expression getRHS() {
        return this.condition;
    }

    public IRLabel getTrueTarget() {
        return this.trueTarget;
    }

    public IRLabel getFalseTarget() {
        return this.falseTarget;
    }

    public IfStatement setTrueTarget(IRLabel label) {
        return new IfStatement(this.condition, label, this.falseTarget, this.naTarget);
    }

    public IfStatement setFalseTarget(IRLabel label) {
        return new IfStatement(this.condition, this.trueTarget, label, this.naTarget);
    }

    @Override
    public Iterable<IRLabel> possibleTargets() {
        if (this.naTarget == null) {
            return Arrays.asList(this.trueTarget, this.falseTarget);
        }
        return Arrays.asList(this.trueTarget, this.falseTarget, this.naTarget);
    }

    @Override
    public Object interpret(Context context, Object[] temp) {
        Logical value = this.toLogical(this.condition.retrieveValue(context, temp));
        switch (value) {
            case TRUE: {
                return this.trueTarget;
            }
            case FALSE: {
                return this.falseTarget;
            }
        }
        if (this.naTarget == null) {
            throw new EvalException("missing value where TRUE/FALSE needed", new Object[0]);
        }
        return this.naTarget;
    }

    @Override
    public Set<Variable> variables() {
        return this.condition.variables();
    }

    @Override
    public Statement withRHS(Expression newRHS) {
        if (!(newRHS instanceof SimpleExpression)) {
            throw new IllegalArgumentException("if statement requires simple rhs");
        }
        return new IfStatement((SimpleExpression)newRHS, this.trueTarget, this.falseTarget, this.naTarget);
    }

    private Logical toLogical(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? Logical.TRUE : Logical.FALSE;
        }
        if (obj instanceof SEXP) {
            SEXP s = (SEXP)obj;
            if (s.length() == 0) {
                throw new EvalException("argument is of length zero", new Object[0]);
            }
            if (s instanceof DoubleVector || s instanceof ComplexVector || s instanceof IntVector || s instanceof LogicalVector) {
                return ((SEXP)obj).asLogical();
            }
        }
        throw new EvalException("invalid type where logical expected", new Object[0]);
    }

    public String toString() {
        return "if " + this.condition + " => TRUE:" + this.trueTarget + ", FALSE:" + this.falseTarget + ", NA:" + (this.naTarget == null ? "ERROR" : this.naTarget);
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.singletonList(this.condition);
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        if (childIndex != 0) {
            throw new IllegalArgumentException();
        }
        this.condition = child;
    }

    @Override
    public void accept(StatementVisitor visitor) {
        visitor.visitIf(this);
    }
}

