/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection.converters;

import org.renjin.invoke.reflection.converters.Converter;
import org.renjin.invoke.reflection.converters.PrimitiveScalarConverter;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.LongArrayVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class LongConverter
extends PrimitiveScalarConverter<Number> {
    public static final Converter INSTANCE = new LongConverter();

    private LongConverter() {
    }

    @Override
    public SEXP convertToR(Number value) {
        if (value == null) {
            return new DoubleArrayVector(DoubleVector.NA);
        }
        return new LongArrayVector(value.longValue());
    }

    public static boolean accept(Class clazz) {
        return clazz == Long.TYPE || clazz == Long.class;
    }

    @Override
    protected Object getFirstElement(Vector value) {
        if (value instanceof LongArrayVector) {
            return ((LongArrayVector)value).getElementAsLong(0);
        }
        return (long)value.getElementAsDouble(0);
    }

    @Override
    public boolean acceptsSEXP(SEXP exp2) {
        return exp2 instanceof DoubleVector || exp2 instanceof IntVector || exp2 instanceof LogicalVector;
    }

    @Override
    public int getSpecificity() {
        return 3;
    }
}

