/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.sequence;

import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class RepStringVector
extends StringVector {
    public Vector source;
    private int sourceLength;
    private int length;
    private int each;

    public RepStringVector(Vector source, int length2, int each, AttributeMap attributes2) {
        super(attributes2);
        this.source = source;
        this.sourceLength = source.length();
        this.length = length2;
        this.each = each;
    }

    private RepStringVector(String constant, int length2) {
        super(AttributeMap.EMPTY);
        this.source = StringVector.valueOf(constant);
        this.sourceLength = this.source.length();
        this.length = length2;
        this.each = 1;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    protected StringVector cloneWithNewAttributes(AttributeMap attributes2) {
        return new RepStringVector(this.source, this.length, this.each, attributes2);
    }

    @Override
    public String getElementAsString(int index) {
        this.sourceLength = this.source.length();
        return this.source.getElementAsString(index / this.each % this.sourceLength);
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    public static StringVector createConstantVector(String constant, int length2) {
        if (length2 <= 0) {
            return StringVector.EMPTY;
        }
        return new RepStringVector(constant, length2);
    }
}

