/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals;

import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.BetaDistributionImpl;
import org.apache.commons.math.distribution.BinomialDistributionImpl;
import org.apache.commons.math.distribution.CauchyDistributionImpl;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;
import org.apache.commons.math.distribution.ContinuousDistribution;
import org.apache.commons.math.distribution.Distribution;
import org.apache.commons.math.distribution.ExponentialDistributionImpl;
import org.apache.commons.math.distribution.FDistributionImpl;
import org.apache.commons.math.distribution.GammaDistributionImpl;
import org.apache.commons.math.distribution.HypergeometricDistributionImpl;
import org.apache.commons.math.distribution.IntegerDistribution;
import org.apache.commons.math.distribution.NormalDistributionImpl;
import org.apache.commons.math.distribution.PascalDistributionImpl;
import org.apache.commons.math.distribution.PoissonDistributionImpl;
import org.apache.commons.math.distribution.TDistributionImpl;
import org.apache.commons.math.distribution.WeibullDistributionImpl;
import org.renjin.invoke.annotations.DataParallel;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.Recycle;
import org.renjin.stats.internals.distributions.Beta;
import org.renjin.stats.internals.distributions.Binom;
import org.renjin.stats.internals.distributions.ChiSquare;
import org.renjin.stats.internals.distributions.ChisquareZeroDfDistribution;
import org.renjin.stats.internals.distributions.F;
import org.renjin.stats.internals.distributions.Geometric;
import org.renjin.stats.internals.distributions.LNorm;
import org.renjin.stats.internals.distributions.LogisticDistribution;
import org.renjin.stats.internals.distributions.SignRank;
import org.renjin.stats.internals.distributions.StudentsT;
import org.renjin.stats.internals.distributions.Tukey;
import org.renjin.stats.internals.distributions.UniformDistribution;
import org.renjin.stats.internals.distributions.Wilcox;

public class Distributions {
    private Distributions() {
    }

    private static double d(AbstractContinuousDistribution dist, double x, boolean log3) {
        double d = dist.density(x);
        if (log3) {
            d = Math.log(d);
        }
        return d;
    }

    private static double d(IntegerDistribution dist, double x, boolean log3) {
        double d = dist.probability(x);
        if (log3) {
            d = Math.log(d);
        }
        return d;
    }

    private static double p(Distribution dist, double q, boolean lowerTail, boolean logP) {
        double p;
        try {
            p = dist.cumulativeProbability(q);
        }
        catch (MathException e) {
            return Double.NaN;
        }
        catch (MathRuntimeException e) {
            return Double.NaN;
        }
        if (!lowerTail) {
            p = 1.0 - p;
        }
        if (logP) {
            p = Math.log(p);
        }
        return p;
    }

    private static double q(ContinuousDistribution dist, double p, boolean lowerTail, boolean logP) {
        if (logP) {
            p = Math.exp(p);
        }
        double q = 0.0;
        try {
            q = dist.inverseCumulativeProbability(p);
        }
        catch (IllegalArgumentException e) {
            return Double.NaN;
        }
        catch (MathException e) {
            return Double.NaN;
        }
        catch (MathRuntimeException e) {
            return Double.NaN;
        }
        if (!lowerTail) {
            q = -q;
        }
        return q;
    }

    private static double q(IntegerDistribution dist, double p, boolean lowerTail, boolean logP) {
        if (logP) {
            p = Math.exp(p);
        }
        double q = 0.0;
        try {
            q = dist.inverseCumulativeProbability(p);
        }
        catch (IllegalArgumentException e) {
            return Double.NaN;
        }
        catch (MathException e) {
            return Double.NaN;
        }
        catch (MathRuntimeException e) {
            return Double.NaN;
        }
        if (!lowerTail) {
            q = -q;
        }
        return q;
    }

    @Internal
    @DataParallel
    public static double dnorm(@Recycle double x, @Recycle double mean2, @Recycle double sd, boolean log3) {
        return Distributions.d((AbstractContinuousDistribution)new NormalDistributionImpl(mean2, sd), x, log3);
    }

    @DataParallel
    @Internal
    public static double pnorm(@Recycle double q, @Recycle double mean2, @Recycle double sd, boolean lowerTail, boolean logP) {
        return Distributions.p((Distribution)new NormalDistributionImpl(mean2, sd), q, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double plnorm(@Recycle double q, @Recycle double logmean, @Recycle double logsd, boolean lowerTail, boolean logP) {
        return Distributions.p((Distribution)new NormalDistributionImpl(logmean, logsd), Math.log(q), lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double qnorm(@Recycle double p, @Recycle double mean2, @Recycle double sd, boolean lowerTail, boolean logP) {
        return Distributions.q((ContinuousDistribution)new NormalDistributionImpl(mean2, sd), p, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double qlnorm(@Recycle double p, @Recycle double meanlog, @Recycle double sdlog, boolean lowerTail, boolean logP) {
        return Math.exp(Distributions.q((ContinuousDistribution)new NormalDistributionImpl(meanlog, sdlog), p, lowerTail, logP));
    }

    @DataParallel
    @Internal
    public static double dlnorm(@Recycle double x, @Recycle double meanlog, @Recycle double sdlog, boolean logP) {
        return LNorm.dlnorm(x, meanlog, sdlog, logP);
    }

    @DataParallel
    @Internal
    public static double dbeta(@Recycle double x, @Recycle double shape1, @Recycle double shape2, boolean log3) {
        return Distributions.d((AbstractContinuousDistribution)new BetaDistributionImpl(shape1, shape2), x, log3);
    }

    @DataParallel
    @Internal
    public static double dnbeta(@Recycle double x, @Recycle double shape1, @Recycle double shape2, @Recycle double ncp, boolean log3) {
        return Beta.dnbeta(x, shape1, shape2, ncp, log3);
    }

    @DataParallel
    @Internal
    public static double pbeta(@Recycle double q, @Recycle double shape1, @Recycle double shape2, boolean lowerTail, boolean logP) {
        return Distributions.p((Distribution)new BetaDistributionImpl(shape1, shape2), q, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double pnbeta(@Recycle double q, @Recycle double shape1, @Recycle double shape2, @Recycle double ncp, boolean lowerTail, boolean logP) {
        return Beta.pnbeta(q, shape1, shape2, ncp, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double qbeta(@Recycle double p, @Recycle double shape1, @Recycle double shape2, boolean lowerTail, boolean logP) {
        return Distributions.q((ContinuousDistribution)new BetaDistributionImpl(shape1, shape2), p, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double qnbeta(@Recycle double p, @Recycle double shape1, @Recycle double shape2, @Recycle double ncp, boolean lowerTail, boolean logP) {
        return Beta.qnbeta(p, shape1, shape2, ncp, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double dchisq(@Recycle double x, @Recycle double df2, boolean log3) {
        return Distributions.d((AbstractContinuousDistribution)new ChiSquaredDistributionImpl(df2), x, log3);
    }

    @DataParallel
    @Internal
    public static double dnchisq(@Recycle double x, @Recycle double df2, @Recycle double ncp, boolean log3) {
        return ChiSquare.dnchisq(x, df2, ncp, log3);
    }

    @DataParallel
    @Internal
    public static double pchisq(@Recycle double q, @Recycle double df2, boolean lowerTail, boolean logP) {
        if (df2 == 0.0) {
            return Distributions.p((Distribution)new ChisquareZeroDfDistribution(), q, lowerTail, logP);
        }
        return Distributions.p((Distribution)new ChiSquaredDistributionImpl(df2), q, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double pnchisq(@Recycle double q, @Recycle double df2, @Recycle double ncp, boolean lowerTail, boolean logP) {
        return ChiSquare.pnchisq(q, df2, ncp, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double qchisq(@Recycle double p, @Recycle double df2, boolean lowerTail, boolean logP) {
        if (df2 == 0.0) {
            return Distributions.q(new ChisquareZeroDfDistribution(), p, lowerTail, logP);
        }
        return Distributions.q((ContinuousDistribution)new ChiSquaredDistributionImpl(df2), p, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double qnchisq(@Recycle double p, @Recycle double df2, @Recycle double ncp, boolean lowerTail, boolean logP) {
        return ChiSquare.qnchisq(p, df2, ncp, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double dexp(@Recycle double x, @Recycle double mean2, boolean log3) {
        return Distributions.d((AbstractContinuousDistribution)new ExponentialDistributionImpl(mean2), x, log3);
    }

    @DataParallel
    @Internal
    public static double pexp(@Recycle double q, @Recycle double mean2, boolean lowerTail, boolean logP) {
        return Distributions.p((Distribution)new ExponentialDistributionImpl(mean2), q, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double qexp(@Recycle double p, @Recycle double mean2, boolean lowerTail, boolean logP) {
        return Distributions.q((ContinuousDistribution)new ExponentialDistributionImpl(mean2), p, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double dt(@Recycle double x, @Recycle double df2, boolean log3) {
        return Distributions.d((AbstractContinuousDistribution)new TDistributionImpl(df2), x, log3);
    }

    @DataParallel
    @Internal
    public static double dnt(@Recycle double x, @Recycle double df2, @Recycle double ncp, boolean log3) {
        return StudentsT.dnt(x, df2, ncp, log3);
    }

    @DataParallel
    @Internal
    public static double pt(@Recycle double q, @Recycle double df2, boolean lowerTail, boolean logP) {
        return Distributions.p((Distribution)new TDistributionImpl(df2), q, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double pnt(@Recycle double q, @Recycle double df2, @Recycle double ncp, boolean lowerTail, boolean logP) {
        return StudentsT.pnt(q, df2, ncp, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double qt(@Recycle double p, @Recycle double df2, boolean lowerTail, boolean logP) {
        return Distributions.q((ContinuousDistribution)new TDistributionImpl(df2), p, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double qnt(@Recycle double p, @Recycle double df2, @Recycle double ncp, boolean lowerTail, boolean logP) {
        return StudentsT.qnt(p, df2, ncp, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double dpois(@Recycle double x, @Recycle double lambda, boolean log3) {
        return Distributions.d((IntegerDistribution)new PoissonDistributionImpl(lambda), x, log3);
    }

    @DataParallel
    @Internal
    public static double ppois(@Recycle double q, @Recycle double lambda, boolean lowerTail, boolean logP) {
        return Distributions.p((Distribution)new PoissonDistributionImpl(lambda), q, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double dbinom(@Recycle double x, @Recycle int size, @Recycle double prob, boolean log3) {
        return Distributions.d((IntegerDistribution)new BinomialDistributionImpl(size, prob), x, log3);
    }

    @DataParallel
    @Internal
    public static double dnbinom(@Recycle double x, @Recycle int size, @Recycle double prob, boolean log3) {
        return Distributions.d((IntegerDistribution)new PascalDistributionImpl(size, prob), x, log3);
    }

    @DataParallel
    @Internal
    public static double dnbinom_mu(@Recycle double x, @Recycle int size, @Recycle double mu, boolean log3) {
        return Binom.dnbinom_mu(x, size, mu, log3);
    }

    @DataParallel
    @Internal
    public static double pbinom(@Recycle double x, @Recycle int size, @Recycle double prob, boolean lowerTail, boolean logP) {
        return Distributions.p((Distribution)new BinomialDistributionImpl(size, prob), x, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double pnbinom(@Recycle double x, @Recycle int size, @Recycle double prob, boolean lowerTail, boolean logP) {
        return Distributions.p((Distribution)new PascalDistributionImpl(size, prob), x, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double pnbinom_mu(@Recycle double x, @Recycle int size, @Recycle double mu, boolean lowerTail, boolean logP) {
        if (!logP) {
            return Binom.pnbinom_mu(x, size, mu, !lowerTail, logP);
        }
        return Binom.pnbinom_mu(x, size, mu, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double qbinom(@Recycle double p, @Recycle int size, @Recycle double prob, boolean lowerTail, boolean logP) {
        return Distributions.q((IntegerDistribution)new BinomialDistributionImpl(size, prob), p, lowerTail, logP) + 1.0;
    }

    @DataParallel
    @Internal
    public static double qnbinom(@Recycle double p, @Recycle double size, @Recycle double prob, boolean lower_tail, boolean log_p) {
        return Binom.qnbinom(p, size, prob, lower_tail, log_p);
    }

    @DataParallel
    @Internal
    public static double qnbinom_mu(@Recycle double p, @Recycle double size, @Recycle double mu, boolean lower_tail, boolean log_p) {
        return Binom.qnbinom_mu(p, size, mu, lower_tail, log_p);
    }

    @DataParallel
    @Internal
    public static double dcauchy(@Recycle double x, @Recycle double location, @Recycle double scale, boolean log3) {
        return Distributions.d((AbstractContinuousDistribution)new CauchyDistributionImpl(location, scale), x, log3);
    }

    @DataParallel
    @Internal
    public static double pcauchy(@Recycle double q, @Recycle double location, @Recycle double scale, boolean lowerTail, boolean logP) {
        return Distributions.p((Distribution)new CauchyDistributionImpl(location, scale), q, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double qcauchy(@Recycle double p, @Recycle double location, @Recycle double scale, boolean lowerTail, boolean logP) {
        return Distributions.q((ContinuousDistribution)new CauchyDistributionImpl(location, scale), p, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double df(@Recycle double x, @Recycle double df1, @Recycle double df2, boolean log3) {
        return Distributions.d((AbstractContinuousDistribution)new FDistributionImpl(df1, df2), x, log3);
    }

    @DataParallel
    @Internal
    public static double dnf(@Recycle double x, @Recycle double df1, @Recycle double df2, @Recycle double ncp, boolean log3) {
        return F.dnf(x, df1, df2, ncp, log3);
    }

    @DataParallel
    @Internal
    public static double pf(@Recycle double q, @Recycle double df1, @Recycle double df2, boolean lowerTail, boolean logP) {
        return Distributions.p((Distribution)new FDistributionImpl(df1, df2), q, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double pnf(@Recycle double q, @Recycle double df1, @Recycle double df2, @Recycle double ncp, boolean lowerTail, boolean logP) {
        return F.pnf(q, df1, df2, ncp, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double qf(@Recycle double p, @Recycle double df1, @Recycle double df2, boolean lowerTail, boolean logP) {
        return Distributions.q((ContinuousDistribution)new FDistributionImpl(df1, df2), p, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double qnf(@Recycle double p, @Recycle double df1, @Recycle double df2, @Recycle double ncp, boolean lowerTail, boolean logP) {
        return F.qnf(p, df1, df2, ncp, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double dgamma(@Recycle double x, @Recycle double shape, @Recycle double scale, boolean log3) {
        return Distributions.d((AbstractContinuousDistribution)new GammaDistributionImpl(shape, scale), x, log3);
    }

    @DataParallel
    @Internal
    public static double pgamma(@Recycle double q, @Recycle double shape, @Recycle double scale, boolean lowerTail, boolean logP) {
        return Distributions.p((Distribution)new GammaDistributionImpl(shape, scale), q, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double qgamma(@Recycle double p, @Recycle double shape, @Recycle double scale, boolean lowerTail, boolean logP) {
        return Distributions.q((ContinuousDistribution)new GammaDistributionImpl(shape, scale), p, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double dunif(@Recycle double x, @Recycle double min2, @Recycle double max2, boolean log3) {
        double d = new UniformDistribution(min2, max2).density(x);
        if (log3) {
            d = Math.log(d);
        }
        return d;
    }

    @DataParallel
    @Internal
    public static double punif(@Recycle double q, @Recycle double min2, @Recycle double max2, boolean lowerTail, boolean logP) {
        return Distributions.p((Distribution)new UniformDistribution(min2, max2), q, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double qunif(@Recycle double p, @Recycle double min2, @Recycle double max2, boolean lowerTail, boolean logP) {
        return Distributions.q(new UniformDistribution(min2, max2), p, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double dweibull(@Recycle double x, @Recycle double shape, @Recycle double scale, boolean log3) {
        return Distributions.d((AbstractContinuousDistribution)new WeibullDistributionImpl(shape, scale), x, log3);
    }

    @DataParallel
    @Internal
    public static double pweibull(@Recycle double q, @Recycle double shape, @Recycle double scale, boolean lowerTail, boolean logP) {
        return Distributions.p((Distribution)new WeibullDistributionImpl(shape, scale), q, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double qweibull(@Recycle double p, @Recycle double shape, @Recycle double scale, boolean lowerTail, boolean logP) {
        return Distributions.q((ContinuousDistribution)new WeibullDistributionImpl(shape, scale), p, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double dhyper(@Recycle double x, @Recycle double whiteBalls, @Recycle double blackBalls, @Recycle double sampleSize, boolean log3) {
        return Distributions.d((IntegerDistribution)new HypergeometricDistributionImpl((int)(whiteBalls + blackBalls), (int)whiteBalls, (int)sampleSize), x, log3);
    }

    @DataParallel
    @Internal
    public static double phyper(@Recycle double q, @Recycle double x, @Recycle double whiteBalls, @Recycle double blackBalls, @Recycle double sampleSize, boolean lowerTail, boolean logP) {
        return Distributions.p((Distribution)new HypergeometricDistributionImpl((int)(whiteBalls + blackBalls), (int)whiteBalls, (int)sampleSize), q, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double pgeom(@Recycle double q, @Recycle double prob, boolean lowerTail, boolean log3) {
        return Geometric.pgeom(q, prob, lowerTail, log3);
    }

    @DataParallel
    @Internal
    public static double dgeom(@Recycle double x, @Recycle double prob, boolean log3) {
        return Geometric.dgeom(x, prob, log3);
    }

    @DataParallel
    @Internal
    public static double qgeom(@Recycle double p, @Recycle double prob, boolean lowerTail, boolean log3) {
        return Geometric.qgeom(p, prob, lowerTail, log3);
    }

    @DataParallel
    @Internal
    public static double plogis(@Recycle double p, @Recycle double m, @Recycle double s, boolean lowerTail, boolean logP) {
        return Distributions.p((Distribution)new LogisticDistribution(m, s), p, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double dlogis(@Recycle double x, @Recycle double location, @Recycle double scale, boolean log3) {
        return Distributions.d(new LogisticDistribution(location, scale), x, log3);
    }

    @DataParallel
    @Internal
    public static double qlogis(@Recycle double p, @Recycle double m, @Recycle double s, boolean lowerTail, boolean logP) {
        return Distributions.q(new LogisticDistribution(m, s), p, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double qsignrank(double p, double n, boolean lowerTail, boolean logP) {
        return SignRank.qsignrank(p, n, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double psignrank(double p, double n, boolean lowerTail, boolean logP) {
        return SignRank.psignrank(p, n, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double dsignrank(double x, double n, boolean logP) {
        return SignRank.dsignrank(x, n, logP);
    }

    @DataParallel
    @Internal
    public static double dwilcox(double x, double m, double n, boolean logP) {
        return Wilcox.dwilcox(x, m, n, logP);
    }

    @DataParallel
    @Internal
    public static double pwilcox(double q, double m, double n, boolean lowerTail, boolean logP) {
        return Wilcox.pwilcox(q, m, n, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double qwilcox(double p, double m, double n, boolean lowerTail, boolean logP) {
        return Wilcox.qwilcox(p, m, n, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double ptukey(@Recycle double q, @Recycle double nranges, @Recycle double nmeans, @Recycle double df2, boolean lowerTail, boolean logP) {
        return Tukey.ptukey(q, nranges, nmeans, df2, lowerTail, logP);
    }

    @DataParallel
    @Internal
    public static double qtukey(@Recycle double p, @Recycle double nranges, @Recycle double nmeans, @Recycle double df2, boolean lowerTail, boolean logP) {
        return Tukey.qtukey(p, nranges, nmeans, df2, lowerTail, logP);
    }
}

