/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.array;

import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.basictypeaccess.BooleanAccess;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.img.basictypeaccess.DoubleAccess;
import net.imglib2.img.basictypeaccess.FloatAccess;
import net.imglib2.img.basictypeaccess.IntAccess;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.ShortAccess;
import net.imglib2.img.basictypeaccess.array.BooleanArray;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.logic.NativeBoolType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.complex.ComplexDoubleType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.Unsigned128BitType;
import net.imglib2.type.numeric.integer.Unsigned12BitType;
import net.imglib2.type.numeric.integer.Unsigned2BitType;
import net.imglib2.type.numeric.integer.Unsigned4BitType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.integer.UnsignedVariableBitLengthType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Fraction;

public final class ArrayImgs {
    private ArrayImgs() {
    }

    public static ArrayImg<UnsignedByteType, ByteArray> unsignedBytes(long ... dim) {
        return new ArrayImgFactory<UnsignedByteType>(new UnsignedByteType()).create(dim);
    }

    public static ArrayImg<UnsignedByteType, ByteArray> unsignedBytes(byte[] array, long ... dim) {
        return ArrayImgs.unsignedBytes(new ByteArray(array), dim);
    }

    public static <A extends ByteAccess> ArrayImg<UnsignedByteType, A> unsignedBytes(A access, long ... dim) {
        ArrayImg<UnsignedByteType, A> img = new ArrayImg<UnsignedByteType, A>(access, dim, new Fraction());
        UnsignedByteType t = new UnsignedByteType(img);
        img.setLinkedType(t);
        return img;
    }

    public static ArrayImg<ByteType, ByteArray> bytes(long ... dim) {
        return new ArrayImgFactory<ByteType>(new ByteType()).create(dim);
    }

    public static ArrayImg<ByteType, ByteArray> bytes(byte[] array, long ... dim) {
        return ArrayImgs.bytes(new ByteArray(array), dim);
    }

    public static <A extends ByteAccess> ArrayImg<ByteType, A> bytes(A access, long ... dim) {
        ArrayImg<ByteType, A> img = new ArrayImg<ByteType, A>(access, dim, new Fraction());
        ByteType t = new ByteType(img);
        img.setLinkedType(t);
        return img;
    }

    public static ArrayImg<UnsignedShortType, ShortArray> unsignedShorts(long ... dim) {
        return new ArrayImgFactory<UnsignedShortType>(new UnsignedShortType()).create(dim);
    }

    public static ArrayImg<UnsignedShortType, ShortArray> unsignedShorts(short[] array, long ... dim) {
        return ArrayImgs.unsignedShorts(new ShortArray(array), dim);
    }

    public static <A extends ShortAccess> ArrayImg<UnsignedShortType, A> unsignedShorts(A access, long ... dim) {
        ArrayImg<UnsignedShortType, A> img = new ArrayImg<UnsignedShortType, A>(access, dim, new Fraction());
        UnsignedShortType t = new UnsignedShortType(img);
        img.setLinkedType(t);
        return img;
    }

    public static ArrayImg<ShortType, ShortArray> shorts(long ... dim) {
        return new ArrayImgFactory<ShortType>(new ShortType()).create(dim);
    }

    public static ArrayImg<ShortType, ShortArray> shorts(short[] array, long ... dim) {
        return ArrayImgs.shorts(new ShortArray(array), dim);
    }

    public static <A extends ShortAccess> ArrayImg<ShortType, A> shorts(A access, long ... dim) {
        ArrayImg<ShortType, A> img = new ArrayImg<ShortType, A>(access, dim, new Fraction());
        ShortType t = new ShortType(img);
        img.setLinkedType(t);
        return img;
    }

    public static ArrayImg<UnsignedIntType, IntArray> unsignedInts(long ... dim) {
        return new ArrayImgFactory<UnsignedIntType>(new UnsignedIntType()).create(dim);
    }

    public static ArrayImg<UnsignedIntType, IntArray> unsignedInts(int[] array, long ... dim) {
        return ArrayImgs.unsignedInts(new IntArray(array), dim);
    }

    public static <A extends IntAccess> ArrayImg<UnsignedIntType, A> unsignedInts(A access, long ... dim) {
        ArrayImg<UnsignedIntType, A> img = new ArrayImg<UnsignedIntType, A>(access, dim, new Fraction());
        UnsignedIntType t = new UnsignedIntType(img);
        img.setLinkedType(t);
        return img;
    }

    public static ArrayImg<IntType, IntArray> ints(long ... dim) {
        return new ArrayImgFactory<IntType>(new IntType()).create(dim);
    }

    public static ArrayImg<IntType, IntArray> ints(int[] array, long ... dim) {
        return ArrayImgs.ints(new IntArray(array), dim);
    }

    public static <A extends IntAccess> ArrayImg<IntType, A> ints(A access, long ... dim) {
        ArrayImg<IntType, A> img = new ArrayImg<IntType, A>(access, dim, new Fraction());
        IntType t = new IntType(img);
        img.setLinkedType(t);
        return img;
    }

    public static ArrayImg<UnsignedLongType, LongArray> unsignedLongs(long ... dim) {
        return new ArrayImgFactory<UnsignedLongType>(new UnsignedLongType()).create(dim);
    }

    @Deprecated
    public static ArrayImg<UnsignedLongType, LongArray> unsignedLongss(long[] array, long ... dim) {
        return ArrayImgs.unsignedLongs(array, dim);
    }

    public static ArrayImg<UnsignedLongType, LongArray> unsignedLongs(long[] array, long ... dim) {
        return ArrayImgs.unsignedLongs(new LongArray(array), dim);
    }

    public static <A extends LongAccess> ArrayImg<UnsignedLongType, A> unsignedLongs(A access, long ... dim) {
        ArrayImg<UnsignedLongType, A> img = new ArrayImg<UnsignedLongType, A>(access, dim, new Fraction());
        UnsignedLongType t = new UnsignedLongType(img);
        img.setLinkedType(t);
        return img;
    }

    public static ArrayImg<LongType, LongArray> longs(long ... dim) {
        return new ArrayImgFactory<LongType>(new LongType()).create(dim);
    }

    public static ArrayImg<LongType, LongArray> longs(long[] array, long ... dim) {
        return ArrayImgs.longs(new LongArray(array), dim);
    }

    public static <A extends LongAccess> ArrayImg<LongType, A> longs(A access, long ... dim) {
        ArrayImg<LongType, A> img = new ArrayImg<LongType, A>(access, dim, new Fraction());
        LongType t = new LongType(img);
        img.setLinkedType(t);
        return img;
    }

    public static ArrayImg<NativeBoolType, BooleanArray> booleans(long ... dim) {
        return new ArrayImgFactory<NativeBoolType>(new NativeBoolType()).create(dim);
    }

    public static ArrayImg<NativeBoolType, BooleanArray> booleans(boolean[] array, long ... dim) {
        return ArrayImgs.booleans(new BooleanArray(array), dim);
    }

    public static <A extends BooleanAccess> ArrayImg<NativeBoolType, A> booleans(A access, long ... dim) {
        ArrayImg<NativeBoolType, A> img = new ArrayImg<NativeBoolType, A>(access, dim, new Fraction());
        NativeBoolType t = new NativeBoolType(img);
        img.setLinkedType(t);
        return img;
    }

    public static ArrayImg<BitType, LongArray> bits(long ... dim) {
        return new ArrayImgFactory<BitType>(new BitType()).create(dim);
    }

    @Deprecated
    public static <A extends BooleanAccess> ArrayImg<NativeBoolType, A> bits(A access, long ... dim) {
        return ArrayImgs.booleans(access, dim);
    }

    public static <A extends LongAccess> ArrayImg<BitType, A> bits(A access, long ... dim) {
        ArrayImg<BitType, A> img = new ArrayImg<BitType, A>(access, dim, new Fraction(1L, 64L));
        BitType t = new BitType(img);
        img.setLinkedType(t);
        return img;
    }

    public static ArrayImg<Unsigned2BitType, LongArray> unsigned2Bits(long ... dim) {
        return new ArrayImgFactory<Unsigned2BitType>(new Unsigned2BitType()).create(dim);
    }

    public static <A extends LongAccess> ArrayImg<Unsigned2BitType, A> unsigned2Bits(A access, long ... dim) {
        ArrayImg<Unsigned2BitType, A> img = new ArrayImg<Unsigned2BitType, A>(access, dim, new Fraction(2L, 64L));
        Unsigned2BitType t = new Unsigned2BitType(img);
        img.setLinkedType(t);
        return img;
    }

    public static ArrayImg<Unsigned4BitType, LongArray> unsigned4Bits(long ... dim) {
        return new ArrayImgFactory<Unsigned4BitType>(new Unsigned4BitType()).create(dim);
    }

    public static <A extends LongAccess> ArrayImg<Unsigned4BitType, A> unsigned4Bits(A access, long ... dim) {
        ArrayImg<Unsigned4BitType, A> img = new ArrayImg<Unsigned4BitType, A>(access, dim, new Fraction(4L, 64L));
        Unsigned4BitType t = new Unsigned4BitType(img);
        img.setLinkedType(t);
        return img;
    }

    public static ArrayImg<Unsigned12BitType, LongArray> unsigned12Bits(long ... dim) {
        return new ArrayImgFactory<Unsigned12BitType>(new Unsigned12BitType()).create(dim);
    }

    public static <A extends LongAccess> ArrayImg<Unsigned12BitType, A> unsigned12Bits(A access, long ... dim) {
        ArrayImg<Unsigned12BitType, A> img = new ArrayImg<Unsigned12BitType, A>(access, dim, new Fraction(12L, 64L));
        Unsigned12BitType t = new Unsigned12BitType(img);
        img.setLinkedType(t);
        return img;
    }

    public static ArrayImg<Unsigned128BitType, LongArray> unsigned128Bits(long ... dim) {
        return new ArrayImgFactory<Unsigned128BitType>(new Unsigned128BitType()).create(dim);
    }

    public static <A extends LongAccess> ArrayImg<Unsigned128BitType, A> unsigned128Bits(A access, long ... dim) {
        ArrayImg<Unsigned128BitType, A> img = new ArrayImg<Unsigned128BitType, A>(access, dim, new Fraction(128L, 64L));
        Unsigned128BitType t = new Unsigned128BitType(img);
        img.setLinkedType(t);
        return img;
    }

    public static ArrayImg<UnsignedVariableBitLengthType, LongArray> unsignedVariableBitLengths(int nbits, long ... dim) {
        return new ArrayImgFactory<UnsignedVariableBitLengthType>(new UnsignedVariableBitLengthType(nbits)).create(dim);
    }

    public static <A extends LongAccess> ArrayImg<UnsignedVariableBitLengthType, A> unsignedVariableBitLengths(A access, int nbits, long ... dim) {
        ArrayImg<UnsignedVariableBitLengthType, A> img = new ArrayImg<UnsignedVariableBitLengthType, A>(access, dim, new Fraction(nbits, 64L));
        UnsignedVariableBitLengthType t = new UnsignedVariableBitLengthType(img, nbits);
        img.setLinkedType(t);
        return img;
    }

    public static ArrayImg<FloatType, FloatArray> floats(long ... dim) {
        return new ArrayImgFactory<FloatType>(new FloatType()).create(dim);
    }

    public static ArrayImg<FloatType, FloatArray> floats(float[] array, long ... dim) {
        return ArrayImgs.floats(new FloatArray(array), dim);
    }

    public static <A extends FloatAccess> ArrayImg<FloatType, A> floats(A access, long ... dim) {
        ArrayImg<FloatType, A> img = new ArrayImg<FloatType, A>(access, dim, new Fraction());
        FloatType t = new FloatType(img);
        img.setLinkedType(t);
        return img;
    }

    public static ArrayImg<DoubleType, DoubleArray> doubles(long ... dim) {
        return new ArrayImgFactory<DoubleType>(new DoubleType()).create(dim);
    }

    public static ArrayImg<DoubleType, DoubleArray> doubles(double[] array, long ... dim) {
        return ArrayImgs.doubles(new DoubleArray(array), dim);
    }

    public static <A extends DoubleAccess> ArrayImg<DoubleType, A> doubles(A access, long ... dim) {
        ArrayImg<DoubleType, A> img = new ArrayImg<DoubleType, A>(access, dim, new Fraction());
        DoubleType t = new DoubleType(img);
        img.setLinkedType(t);
        return img;
    }

    public static ArrayImg<ARGBType, IntArray> argbs(long ... dim) {
        return new ArrayImgFactory<ARGBType>(new ARGBType()).create(dim);
    }

    public static ArrayImg<ARGBType, IntArray> argbs(int[] array, long ... dim) {
        return ArrayImgs.argbs(new IntArray(array), dim);
    }

    public static <A extends IntAccess> ArrayImg<ARGBType, A> argbs(A access, long ... dim) {
        ArrayImg<ARGBType, A> img = new ArrayImg<ARGBType, A>(access, dim, new Fraction());
        ARGBType t = new ARGBType(img);
        img.setLinkedType(t);
        return img;
    }

    public static ArrayImg<ComplexFloatType, FloatArray> complexFloats(long ... dim) {
        return new ArrayImgFactory<ComplexFloatType>(new ComplexFloatType()).create(dim);
    }

    public static ArrayImg<ComplexFloatType, FloatArray> complexFloats(float[] array, long ... dim) {
        return ArrayImgs.complexFloats(new FloatArray(array), dim);
    }

    public static <A extends FloatAccess> ArrayImg<ComplexFloatType, A> complexFloats(A access, long ... dim) {
        ArrayImg<ComplexFloatType, A> img = new ArrayImg<ComplexFloatType, A>(access, dim, new Fraction(2L, 1L));
        ComplexFloatType t = new ComplexFloatType(img);
        img.setLinkedType(t);
        return img;
    }

    public static ArrayImg<ComplexDoubleType, DoubleArray> complexDoubles(long ... dim) {
        return new ArrayImgFactory<ComplexDoubleType>(new ComplexDoubleType()).create(dim);
    }

    public static ArrayImg<ComplexDoubleType, DoubleArray> complexDoubles(double[] array, long ... dim) {
        return ArrayImgs.complexDoubles(new DoubleArray(array), dim);
    }

    public static <A extends DoubleAccess> ArrayImg<ComplexDoubleType, A> complexDoubles(A access, long ... dim) {
        ArrayImg<ComplexDoubleType, A> img = new ArrayImg<ComplexDoubleType, A>(access, dim, new Fraction(2L, 1L));
        ComplexDoubleType t = new ComplexDoubleType(img);
        img.setLinkedType(t);
        return img;
    }
}

