/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.kdtree;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.imglib2.RandomAccess;
import net.imglib2.RealLocalizable;
import net.imglib2.img.Img;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;

final class KDTreeUtils {
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    static int leftChildIndex(int i) {
        return 2 * i + 1;
    }

    static int rightChildIndex(int i) {
        return 2 * i + 2;
    }

    static int parentIndex(int i) {
        return (i - 1) / 2;
    }

    static double[][] initPositions(int numDimensions, int numPoints, Iterable<? extends RealLocalizable> points) {
        double[][] positions = new double[numDimensions][numPoints];
        Iterator<? extends RealLocalizable> ipos = points.iterator();
        for (int i = 0; i < numPoints; ++i) {
            if (!ipos.hasNext()) {
                throw new IllegalArgumentException("positions Iterable is empty");
            }
            RealLocalizable pos = ipos.next();
            for (int d = 0; d < numDimensions; ++d) {
                positions[d][i] = pos.getDoublePosition(d);
            }
        }
        return positions;
    }

    static int[] makeTree(double[][] positions) {
        return new MakeTree(positions).tree;
    }

    static double[][] reorder(double[][] positions, int[] tree) {
        int numDimensions = positions.length;
        int numPoints = positions[0].length;
        assert (tree.length == numPoints);
        double[][] reordered = new double[numDimensions][];
        Arrays.setAll(reordered, d -> KDTreeUtils.reorder(positions[d], tree));
        return reordered;
    }

    static double[] reorder(double[] values, int[] order) {
        int size = order.length;
        double[] reordered = new double[size];
        Arrays.setAll(reordered, i -> values[order[i]]);
        return reordered;
    }

    static int[] reorder(int[] values, int[] order) {
        int size = order.length;
        int[] reordered = new int[size];
        Arrays.setAll(reordered, i -> values[order[i]]);
        return reordered;
    }

    static double[] reorderToFlatLayout(double[][] positions, int[] tree) {
        int numDimensions = positions.length;
        int numPoints = positions[0].length;
        assert (tree.length == numPoints);
        if ((long)numDimensions * (long)numPoints > 0x7FFFFFF7L) {
            throw new IllegalArgumentException("positions[][] is too large to be stored in a flat array");
        }
        double[] reordered = new double[numDimensions * numPoints];
        for (int i = 0; i < numPoints; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                reordered[numDimensions * i + d] = positions[d][tree[i]];
            }
        }
        return reordered;
    }

    static double[] flatten(double[][] positions) {
        int numDimensions = positions.length;
        int numPoints = positions[0].length;
        double[] flattened = new double[numDimensions * numPoints];
        for (int i = 0; i < numPoints; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                flattened[numDimensions * i + d] = positions[d][i];
            }
        }
        return flattened;
    }

    static double[][] unflatten(double[] positions, int n) {
        int numPoints = positions.length / n;
        double[][] unflattened = new double[n][numPoints];
        for (int i = 0; i < positions.length; ++i) {
            int d = i % n;
            unflattened[d][i / n] = positions[i];
        }
        return unflattened;
    }

    static void computeMinMax(double[][] positions, double[] min, double[] max) {
        int n = min.length;
        for (int d = 0; d < n; ++d) {
            double maxd = Double.NEGATIVE_INFINITY;
            double mind = Double.POSITIVE_INFINITY;
            for (double v : positions[d]) {
                if (v < mind) {
                    mind = v;
                }
                if (!(v > maxd)) continue;
                maxd = v;
            }
            min[d] = mind;
            max[d] = maxd;
        }
    }

    static void computeMinMax(double[] flatPositions, double[] min, double[] max) {
        int n = min.length;
        Arrays.fill(max, Double.NEGATIVE_INFINITY);
        Arrays.fill(min, Double.POSITIVE_INFINITY);
        int d = 0;
        for (double v : flatPositions) {
            if (v < min[d]) {
                min[d] = v;
            }
            if (v > max[d]) {
                max[d] = v;
            }
            d = (d + 1) % n;
        }
    }

    static int[] invert(int[] tree) {
        int[] inv = new int[tree.length];
        for (int i = 0; i < tree.length; ++i) {
            inv[tree[i]] = i;
        }
        return inv;
    }

    static <T> List<T> orderValuesList(int[] invtree, Iterable<T> values) {
        int size = invtree.length;
        Object[] orderedValues = new Object[size];
        Iterator<T> ival = values.iterator();
        for (int i : invtree) {
            if (!ival.hasNext()) {
                throw new IllegalArgumentException("provided values Iterable has fewer elements than required");
            }
            orderedValues[i] = ival.next();
        }
        return Arrays.asList(orderedValues);
    }

    static <T extends NativeType<T>> Img<T> orderValuesImg(int[] invtree, Iterable<T> values) {
        int size = invtree.length;
        NativeImg img = new ArrayImgFactory<NativeType>((NativeType)KDTreeUtils.getType(values)).create(new long[]{size});
        RandomAccess orderedValues = img.randomAccess();
        Iterator<T> ival = values.iterator();
        for (int i : invtree) {
            if (!ival.hasNext()) {
                throw new IllegalArgumentException("provided values Iterable has fewer elements than required");
            }
            ((NativeType)orderedValues.setPositionAndGet(i)).set((Type)ival.next());
        }
        return img;
    }

    static <T> T getType(Iterable<T> values) {
        Iterator<T> ival = values.iterator();
        if (!ival.hasNext()) {
            throw new IllegalArgumentException("values Iterable is empty");
        }
        return ival.next();
    }

    static int getNumDimensions(Iterable<? extends RealLocalizable> positions) {
        Iterator<? extends RealLocalizable> ipos = positions.iterator();
        return ipos.hasNext() ? ipos.next().numDimensions() : 0;
    }

    private static void swap(int i, int j, int[] order) {
        int tmp = order[i];
        order[i] = order[j];
        order[j] = tmp;
    }

    static int partition(int i, int j, double[] values, int[] order) {
        int len = j - i + 1;
        if (len <= 2) {
            if (len <= 0) {
                throw new IllegalArgumentException();
            }
            if (values[order[i]] > values[order[j]]) {
                KDTreeUtils.swap(i, j, order);
            }
            return i;
        }
        int m = (i + j) / 2;
        if (values[order[i]] > values[order[m]]) {
            KDTreeUtils.swap(i, m, order);
        }
        if (values[order[i]] > values[order[j]]) {
            KDTreeUtils.swap(i, j, order);
        }
        if (values[order[m]] > values[order[j]]) {
            KDTreeUtils.swap(m, j, order);
        }
        KDTreeUtils.swap(m, i + 1, order);
        int p = ++i;
        double pivot = values[order[p]];
        while (true) {
            if (values[order[++i]] < pivot) {
                continue;
            }
            while (values[order[--j]] > pivot) {
            }
            if (j < i) break;
            KDTreeUtils.swap(i, j, order);
        }
        KDTreeUtils.swap(p, j, order);
        return j;
    }

    static void quicksort(int i, int j, double[] values, int[] order) {
        if (0 <= i && i < j) {
            int p = KDTreeUtils.partition(i, j, values, order);
            KDTreeUtils.quicksort(i, p - 1, values, order);
            KDTreeUtils.quicksort(p + 1, j, values, order);
        }
    }

    private KDTreeUtils() {
    }

    private static final class MakeTree {
        private final int numDimensions;
        private final int numPoints;
        private final double[][] positions;
        private final int[] indices;
        private final int[] tree;

        private MakeTree(double[][] positions) {
            this.positions = positions;
            this.numDimensions = positions.length;
            this.numPoints = positions[0].length;
            this.indices = new int[this.numPoints];
            this.tree = new int[this.numPoints];
            Arrays.setAll(this.indices, j -> j);
            this.makeNode(0, this.numPoints - 1, 0, 0);
        }

        private static int pivot(int len) {
            int h2;
            int h = Integer.highestOneBit(len);
            return len - h >= (h2 = h >> 1) ? h - 1 : len - h2;
        }

        private void makeNode(int i, int j, int d, int nodeIndex) {
            if (j > i) {
                int k = i + MakeTree.pivot(j - i + 1);
                this.kthElement(i, j, k, d);
                this.tree[nodeIndex] = this.indices[k];
                int dChild = (d + 1) % this.numDimensions;
                this.makeNode(i, k - 1, dChild, KDTreeUtils.leftChildIndex(nodeIndex));
                this.makeNode(k + 1, j, dChild, KDTreeUtils.rightChildIndex(nodeIndex));
            } else if (j == i) {
                this.tree[nodeIndex] = this.indices[i];
            }
        }

        private void kthElement(int i, int j, int k, int compare_d) {
            while (true) {
                int pivotpos;
                if ((pivotpos = KDTreeUtils.partition(i, j, this.positions[compare_d], this.indices)) > k) {
                    j = pivotpos - 1;
                    continue;
                }
                if (pivotpos >= k) break;
                i = pivotpos + 1;
            }
        }
    }
}

