/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.util.Fraction;
import net.imglib2.util.Util;

public abstract class GenericLongType<T extends GenericLongType<T>>
extends AbstractIntegerType<T>
implements NativeType<T> {
    final Index i = new Index();
    protected final NativeImg<?, ? extends LongAccess> img;
    protected LongAccess dataAccess;

    public GenericLongType(NativeImg<?, ? extends LongAccess> longStorage) {
        this.img = longStorage;
    }

    public GenericLongType(long value) {
        this.img = null;
        this.dataAccess = new LongArray(1);
        this.setLong(value);
    }

    public GenericLongType(LongAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public GenericLongType() {
        this(0L);
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction();
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public Index index() {
        return this.i;
    }

    @Override
    public abstract NativeTypeFactory<T, LongAccess> getNativeTypeFactory();

    @Deprecated
    protected long getValue() {
        return this.dataAccess.getValue(this.i.get());
    }

    @Deprecated
    protected void setValue(long f) {
        this.dataAccess.setValue(this.i.get(), f);
    }

    public long getLong() {
        return this.dataAccess.getValue(this.i.get());
    }

    public void setLong(long f) {
        this.dataAccess.setValue(this.i.get(), f);
    }

    @Override
    public void mul(float c) {
        this.setLong(Util.round((float)this.getLong() * c));
    }

    @Override
    public void mul(double c) {
        this.setLong(Util.round((double)this.getLong() * c));
    }

    @Override
    public void add(T c) {
        this.setLong(this.getLong() + ((GenericLongType)c).getLong());
    }

    @Override
    public void div(T c) {
        this.setLong(this.getLong() / ((GenericLongType)c).getLong());
    }

    @Override
    public void mul(T c) {
        this.setLong(this.getLong() * ((GenericLongType)c).getLong());
    }

    @Override
    public void sub(T c) {
        this.setLong(this.getLong() - ((GenericLongType)c).getLong());
    }

    @Override
    public void set(T c) {
        this.setLong(((GenericLongType)c).getLong());
    }

    @Override
    public void setOne() {
        this.setLong(1L);
    }

    @Override
    public void setZero() {
        this.setLong(0L);
    }

    @Override
    public void inc() {
        long a = this.getLong();
        this.setLong(++a);
    }

    @Override
    public void dec() {
        long a = this.getLong();
        this.setLong(--a);
    }

    @Override
    public String toString() {
        return "" + this.getLong();
    }

    @Override
    public int getBitsPerPixel() {
        return 64;
    }

    @Override
    public int compareTo(T other) {
        return Long.compare(this.getLong(), ((GenericLongType)other).getLong());
    }

    @Override
    public boolean valueEquals(T other) {
        return this.getLong() == ((GenericLongType)other).getLong();
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        GenericLongType t = (GenericLongType)obj;
        return this.valueEquals((T)t);
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.getLong());
    }
}

