/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.Context;
import org.jogamp.java3d.FogRetained;
import org.jogamp.java3d.GroupRetained;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.SetLiveState;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.vecmath.Color3f;

class ExponentialFogRetained
extends FogRetained {
    private float density = 1.0f;
    private float densityInEc;
    static final int DENSITY_CHANGED = 64;

    ExponentialFogRetained() {
        this.nodeType = 4;
    }

    void initDensity(float density) {
        this.density = density;
    }

    void setDensity(float density) {
        this.density = density;
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4224;
        createMessage.type = 22;
        createMessage.universe = this.universe;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(64);
        createMessage.args[2] = new Float(density);
        VirtualUniverse.mc.processMessage(createMessage);
    }

    float getDensity() {
        return this.density;
    }

    @Override
    void setLive(SetLiveState s) {
        super.setLive(s);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 4096;
        createMessage.universe = this.universe;
        createMessage.type = 22;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(16);
        ArrayList addScopeList = new ArrayList();
        for (int i = 0; i < this.scopes.size(); ++i) {
            GroupRetained group = (GroupRetained)this.scopes.get(i);
            this.tempKey.reset();
            group.addAllNodesForScopedFog(this.mirrorFog, addScopeList, this.tempKey);
        }
        Object[] scopeInfo = new Object[]{this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE, addScopeList};
        createMessage.args[2] = scopeInfo;
        Color3f clr = new Color3f(this.color);
        createMessage.args[3] = clr;
        Object[] obj = new Object[]{this.boundingLeaf, this.regionOfInfluence != null ? this.regionOfInfluence.clone() : null, this.inBackgroundGroup ? Boolean.TRUE : Boolean.FALSE, this.geometryBackground, new Float(this.density)};
        createMessage.args[4] = obj;
        VirtualUniverse.mc.processMessage(createMessage);
    }

    @Override
    void update(Context ctx, double scale) {
        this.validateDistancesInEc(scale);
        Pipeline.getPipeline().updateExponentialFog(ctx, this.color.x, this.color.y, this.color.z, this.densityInEc);
    }

    @Override
    void updateMirrorObject(Object[] objs) {
        int component = (Integer)objs[1];
        if ((component & 0x40) != 0) {
            ((ExponentialFogRetained)this.mirrorFog).density = ((Float)objs[2]).floatValue();
        }
        if ((component & 0x10) != 0) {
            ((ExponentialFogRetained)this.mirrorFog).density = ((Float)((Object[])objs[4])[4]).floatValue();
        }
        ((ExponentialFogRetained)this.mirrorFog).setLocalToVworldScale(this.getLastLocalToVworld().getDistanceScale());
        super.updateMirrorObject(objs);
    }

    @Override
    protected Object clone() {
        ExponentialFogRetained efr = (ExponentialFogRetained)super.clone();
        efr.initDensity(this.getDensity());
        return efr;
    }

    @Override
    protected void validateDistancesInEc(double vworldToCoexistenceScale) {
        double localToEcScale = this.getLocalToVworldScale() * vworldToCoexistenceScale;
        this.densityInEc = (float)((double)this.density / localToEcScale);
    }
}

