/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.builder;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apposed.appose.builder.Tool;
import org.apposed.appose.util.Downloads;
import org.apposed.appose.util.Environments;
import org.apposed.appose.util.Platforms;
import org.apposed.appose.util.Processes;

class Uv
extends Tool {
    private static final Path UV_RELATIVE_PATH = Platforms.isWindows() ? Paths.get(".uv", "bin", "uv.exe") : Paths.get(".uv", "bin", "uv");
    public static final String BASE_PATH = Environments.apposeEnvsDir();
    private static final String UV_VERSION = "0.9.5";
    private static final String UV_BINARY = Uv.uvBinary();
    public static final String UV_URL = UV_BINARY == null ? null : "https://github.com/astral-sh/uv/releases/download/0.9.5/" + UV_BINARY;

    private static String uvBinary() {
        switch (Platforms.PLATFORM) {
            case "MACOS|ARM64": {
                return "uv-aarch64-apple-darwin.tar.gz";
            }
            case "MACOS|X64": {
                return "uv-x86_64-apple-darwin.tar.gz";
            }
            case "WINDOWS|ARM64": {
                return "uv-aarch64-pc-windows-msvc.zip";
            }
            case "WINDOWS|X32": {
                return "uv-i686-pc-windows-msvc.zip";
            }
            case "WINDOWS|X64": {
                return "uv-x86_64-pc-windows-msvc.zip";
            }
            case "LINUX|ARM64": {
                return "uv-aarch64-unknown-linux-gnu.tar.gz";
            }
            case "LINUX|X32": {
                return "uv-i686-unknown-linux-gnu.tar.gz";
            }
            case "LINUX|PPC64": {
                return "uv-powerpc64-unknown-linux-gnu.tar.gz";
            }
            case "LINUX|PPC64LE": {
                return "uv-powerpc64le-unknown-linux-gnu.tar.gz";
            }
            case "LINUX|RV64GC": {
                return "uv-riscv64gc-unknown-linux-gnu.tar.gz";
            }
            case "LINUX|S390X": {
                return "uv-s390x-unknown-linux-gnu.tar.gz";
            }
            case "LINUX|X64": {
                return "uv-x86_64-unknown-linux-gnu.tar.gz";
            }
            case "LINUX|ARMV7": {
                return "uv-armv7-unknown-linux-gnueabihf.tar.gz";
            }
            case "LINUX|ARMV6": {
                return "uv-arm-unknown-linux-musleabihf.tar.gz";
            }
        }
        return null;
    }

    public Uv() {
        this(null);
    }

    public Uv(String rootdir) {
        super("uv", UV_URL, Paths.get(rootdir == null ? BASE_PATH : rootdir, new String[0]).resolve(UV_RELATIVE_PATH).toAbsolutePath().toString(), rootdir == null ? BASE_PATH : rootdir);
    }

    @Override
    protected void decompress(File archive) throws IOException, InterruptedException {
        boolean executableSet;
        File uvBaseDir = new File(this.rootdir);
        if (!uvBaseDir.isDirectory() && !uvBaseDir.mkdirs()) {
            throw new IOException("Failed to create UV default directory " + uvBaseDir.getParentFile().getAbsolutePath() + ". Please try installing it in another directory.");
        }
        File uvBinDir = Paths.get(this.rootdir, new String[0]).resolve(".uv").resolve("bin").toFile();
        if (!uvBinDir.exists() && !uvBinDir.mkdirs()) {
            throw new IOException("Failed to create UV bin directory: " + uvBinDir);
        }
        Downloads.unpack(archive, uvBinDir);
        String uvBinaryName = Platforms.isWindows() ? "uv.exe" : "uv";
        File uvDest = new File(this.command);
        File uvDirectly = new File(uvBinDir, uvBinaryName);
        if (uvDirectly.exists()) {
            if (!uvDirectly.equals(uvDest) && !uvDirectly.renameTo(uvDest)) {
                throw new IOException("Failed to move uv binary from " + uvDirectly + " to " + uvDest);
            }
        } else {
            File[] platformDirs = uvBinDir.listFiles(f -> f.isDirectory() && f.getName().startsWith("uv-"));
            if (platformDirs == null || platformDirs.length == 0) {
                throw new IOException("Expected uv binary or uv-<platform> directory not found in: " + uvBinDir);
            }
            File platformDir = platformDirs[0];
            File[] binaries = platformDir.listFiles();
            if (binaries != null) {
                for (File binary : binaries) {
                    File dest = new File(uvBinDir, binary.getName());
                    if (!binary.renameTo(dest)) {
                        throw new IOException("Failed to move " + binary.getName() + " from " + binary + " to " + dest);
                    }
                    if (dest.canExecute()) continue;
                    dest.setExecutable(true);
                }
            }
            if (!platformDir.delete()) {
                throw new IOException("Failed to delete platform directory: " + platformDir);
            }
        }
        if (!uvDest.exists()) {
            throw new IOException("Expected uv binary is missing: " + this.command);
        }
        if (!uvDest.canExecute() && !(executableSet = uvDest.setExecutable(true))) {
            throw new IOException("Cannot set file as executable due to missing permissions, please do it manually: " + this.command);
        }
    }

    public void createVenv(File envDir, String pythonVersion) throws IOException, InterruptedException {
        this.checkInstalled();
        ArrayList<String> args = new ArrayList<String>();
        args.add("venv");
        if (pythonVersion != null && !pythonVersion.isEmpty()) {
            args.add("--python");
            args.add(pythonVersion);
        }
        args.add(envDir.getAbsolutePath());
        this.exec(args.toArray(new String[0]));
    }

    public void pipInstall(File envDir, String ... packages) throws IOException, InterruptedException {
        this.checkInstalled();
        ArrayList<String> args = new ArrayList<String>();
        args.add("pip");
        args.add("install");
        args.add("--python");
        args.add(envDir.getAbsolutePath());
        args.addAll(Arrays.asList(packages));
        this.exec(args.toArray(new String[0]));
    }

    public void pipInstallFromRequirements(File envDir, String requirementsFile) throws IOException, InterruptedException {
        this.checkInstalled();
        this.exec("pip", "install", "--python", envDir.getAbsolutePath(), "-r", requirementsFile);
    }

    public void sync(File projectDir, String pythonVersion) throws IOException, InterruptedException {
        this.checkInstalled();
        ArrayList<String> args = new ArrayList<String>();
        args.add("sync");
        if (pythonVersion != null && !pythonVersion.isEmpty()) {
            args.add("--python");
            args.add(pythonVersion);
        }
        this.runUvInDirectory(projectDir, args.toArray(new String[0]));
    }

    public void runUvInDirectory(File workingDir, String ... args) throws IOException, InterruptedException {
        this.checkInstalled();
        List<String> cmd = Platforms.baseCommand();
        cmd.add(this.command);
        cmd.addAll(this.flags);
        cmd.addAll(Arrays.asList(args));
        ProcessBuilder builder = Processes.builder(workingDir, this.envVars, false, new String[0]);
        builder.command(cmd);
        Process process = builder.start();
        Thread mainThread = Thread.currentThread();
        Thread outputThread = new Thread(() -> {
            try {
                this.readStreams(process, mainThread);
            }
            catch (IOException | InterruptedException e) {
                this.error("Error reading streams: " + e.getMessage());
            }
        });
        outputThread.start();
        int exitCode = process.waitFor();
        outputThread.join();
        if (exitCode != 0) {
            throw new IOException("UV command failed with exit code " + exitCode + ": " + String.join((CharSequence)" ", args));
        }
    }

    @Override
    public String version() throws IOException, InterruptedException {
        String version;
        List<String> cmd = Platforms.baseCommand();
        cmd.add(this.command);
        cmd.add("--version");
        ProcessBuilder builder = this.processBuilder(this.rootdir, false);
        builder.command(cmd);
        Process process = builder.start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            version = reader.lines().collect(Collectors.joining("\n"));
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw new IOException("Failed to get UV version");
        }
        return version.trim();
    }
}

