/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.math.BigDecimal;
import net.imagej.types.BigComplex;
import net.imagej.types.DataType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import org.scijava.AbstractContextual;
import org.scijava.plugin.Plugin;

@Plugin(type=DataType.class)
public class DataType16BitUnsignedInteger
extends AbstractContextual
implements DataType<UnsignedShortType> {
    private final UnsignedShortType type = new UnsignedShortType();

    @Override
    public UnsignedShortType getType() {
        return this.type;
    }

    @Override
    public String shortName() {
        return "16-bit uint";
    }

    @Override
    public String longName() {
        return "16-bit unsigned integer";
    }

    @Override
    public String description() {
        return "An integer data type ranging between 0 and 65535";
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public void lowerBound(UnsignedShortType dest) {
        dest.set(0);
    }

    @Override
    public void upperBound(UnsignedShortType dest) {
        dest.set(65535);
    }

    @Override
    public int bitCount() {
        return 16;
    }

    @Override
    public UnsignedShortType createVariable() {
        return new UnsignedShortType();
    }

    @Override
    public void cast(UnsignedShortType val, BigComplex dest) {
        dest.setReal(val.get());
        dest.setImag(BigDecimal.ZERO);
    }

    @Override
    public void cast(BigComplex val, UnsignedShortType dest) {
        this.setLong(dest, val.getReal().longValue());
    }

    @Override
    public boolean hasDoubleRepresentation() {
        return true;
    }

    @Override
    public boolean hasLongRepresentation() {
        return true;
    }

    @Override
    public double asDouble(UnsignedShortType val) {
        return val.get();
    }

    @Override
    public long asLong(UnsignedShortType val) {
        return val.get();
    }

    @Override
    public void setDouble(UnsignedShortType val, double v) {
        this.setLong(val, (long)v);
    }

    @Override
    public void setLong(UnsignedShortType val, long v) {
        if (v < 0L) {
            val.set(0);
        } else if (v > 65535L) {
            val.set(65535);
        } else {
            val.set((int)v);
        }
    }
}

