/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.basictypecontainer.array;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import mpicbg.imglib.container.basictypecontainer.CharAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;

public class NIOCharArray
implements ArrayDataAccess<NIOCharArray>,
CharAccess {
    protected CharBuffer data;

    public NIOCharArray(int numEntities) {
        this.data = ByteBuffer.allocateDirect(numEntities * 4).order(ByteOrder.nativeOrder()).asCharBuffer();
    }

    public NIOCharArray(char[] data) {
        CharBuffer bufferIn = CharBuffer.wrap(data);
        CharBuffer copy = ByteBuffer.allocateDirect(bufferIn.capacity()).order(ByteOrder.nativeOrder()).asCharBuffer();
        this.data = copy.put(bufferIn);
    }

    @Override
    public void close() {
        this.data = null;
    }

    @Override
    public char getValue(int index) {
        return this.data.get(index);
    }

    @Override
    public void setValue(int index, char value) {
        this.data.put(index, value);
    }

    public char[] getCurrentStorageArray() {
        char[] outData = new char[this.data.capacity()];
        this.data.get(outData);
        return outData;
    }

    @Override
    public NIOCharArray createArray(int numEntities) {
        return new NIOCharArray(numEntities);
    }
}

