/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.shapelist;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import mpicbg.imglib.container.shapelist.ShapeListCached;
import mpicbg.imglib.cursor.shapelist.ShapeListCache;
import mpicbg.imglib.type.Type;

public class ShapeListCacheFIFO<T extends Type<T>>
extends ShapeListCache<T> {
    final Map<Integer, T> cache;
    final LinkedList<Integer> queue;

    public ShapeListCacheFIFO(int cacheSize, ShapeListCached<T> container) {
        super(cacheSize, container);
        this.cache = new HashMap<Integer, T>(cacheSize);
        this.queue = new LinkedList();
        for (int i = 0; i < cacheSize; ++i) {
            this.queue.add(Integer.MIN_VALUE);
        }
    }

    @Override
    public T lookUp(int[] position) {
        int index = this.fakeArray.getPos(position);
        Type value = (Type)this.cache.get(index);
        if (value == null) {
            Object t = this.container.getShapeType(position);
            this.queue.add(index);
            this.cache.put(index, t);
            this.cache.remove(this.queue.removeFirst());
            return t;
        }
        return (T)value;
    }

    @Override
    public ShapeListCache<T> getCursorCacheInstance() {
        return new ShapeListCacheFIFO<T>(this.cacheSize, this.container);
    }
}

