/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.image.display.imagej;

import ij.VirtualStack;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import mpicbg.imglib.cursor.LocalizablePlaneCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.Display;
import mpicbg.imglib.type.Type;

public class ImageJVirtualStack<T extends Type<T>>
extends VirtualStack {
    final Display<T> display;
    final Image<T> img;
    final int type;
    final int dimX;
    final int dimY;
    final int dimZ;
    final int sizeX;
    final int sizeY;
    final int sizeZ;
    final int[] dimensionPositions;
    private final int size;

    public ImageJVirtualStack(Image<T> img, int type, int[] dim, int[] dimensionPositions) {
        super(img.getDimension(dim[0]), img.getDimension(dim[1]), null, null);
        this.img = img;
        this.type = type;
        this.display = img.getDisplay();
        this.size = img.getDimension(dim[2]);
        this.dimX = dim[0];
        this.dimY = dim[1];
        this.dimZ = dim[2];
        this.dimensionPositions = dimensionPositions;
        this.sizeX = img.getDimension(dim[0]);
        this.sizeY = img.getDimension(dim[1]);
        this.sizeZ = img.getDimension(dim[2]);
    }

    public ImageJVirtualStack(Image<T> img, int[] dim, int[] dimensionPositions) {
        this(img, 2, dim, dimensionPositions);
    }

    public ImageProcessor getProcessor(int n) {
        ColorProcessor ip;
        if (this.sizeZ == 0) {
            return null;
        }
        if (n < 1 || n > this.sizeZ) {
            throw new IllegalArgumentException("no slice " + n);
        }
        int[] dimPos = (int[])this.dimensionPositions.clone();
        if (this.dimZ < this.img.getNumDimensions()) {
            dimPos[this.dimZ] = n - 1;
        }
        switch (this.type) {
            case 0: {
                ip = new ByteProcessor(this.sizeX, this.sizeY, ImageJVirtualStack.extractSliceByte(this.img, this.display, this.dimX, this.dimY, dimPos), null);
                break;
            }
            case 4: {
                ip = new ColorProcessor(this.sizeX, this.sizeY, ImageJVirtualStack.extractSliceRGB(this.img, this.display, this.dimX, this.dimY, dimPos));
                break;
            }
            default: {
                ip = new FloatProcessor(this.sizeX, this.sizeY, ImageJVirtualStack.extractSliceFloat(this.img, this.display, this.dimX, this.dimY, dimPos), null);
                ip.setMinAndMax(this.display.getMin(), this.display.getMax());
            }
        }
        return ip;
    }

    public static <T extends Type<T>> float[] extractSliceFloat(Image<T> img, Display<T> display, int dimX, int dimY, int[] dimensionPositions) {
        int sizeX = img.getDimension(dimX);
        int sizeY = img.getDimension(dimY);
        LocalizablePlaneCursor<T> cursor = img.createLocalizablePlaneCursor();
        cursor.reset(dimX, dimY, dimensionPositions);
        float[] sliceImg = new float[sizeX * sizeY];
        if (dimY < img.getNumDimensions()) {
            while (cursor.hasNext()) {
                cursor.fwd();
                sliceImg[cursor.getPosition((int)dimX) + cursor.getPosition((int)dimY) * sizeX] = display.get32Bit(cursor.getType());
            }
        } else {
            while (cursor.hasNext()) {
                cursor.fwd();
                sliceImg[cursor.getPosition((int)dimX)] = display.get32Bit(cursor.getType());
            }
        }
        cursor.close();
        return sliceImg;
    }

    public static <T extends Type<T>> int[] extractSliceRGB(Image<T> img, Display<T> display, int dimX, int dimY, int[] dimensionPositions) {
        int sizeX = img.getDimension(dimX);
        int sizeY = img.getDimension(dimY);
        LocalizablePlaneCursor<T> cursor = img.createLocalizablePlaneCursor();
        cursor.reset(dimX, dimY, dimensionPositions);
        int[] sliceImg = new int[sizeX * sizeY];
        if (dimY < img.getNumDimensions()) {
            while (cursor.hasNext()) {
                cursor.fwd();
                sliceImg[cursor.getPosition((int)dimX) + cursor.getPosition((int)dimY) * sizeX] = display.get8BitARGB(cursor.getType());
            }
        } else {
            while (cursor.hasNext()) {
                cursor.fwd();
                sliceImg[cursor.getPosition((int)dimX)] = display.get8BitARGB(cursor.getType());
            }
        }
        return sliceImg;
    }

    public static <T extends Type<T>> byte[] extractSliceByte(Image<T> img, Display<T> display, int dimX, int dimY, int[] dimensionPositions) {
        int sizeX = img.getDimension(dimX);
        int sizeY = img.getDimension(dimY);
        LocalizablePlaneCursor<T> cursor = img.createLocalizablePlaneCursor();
        cursor.reset(dimX, dimY, dimensionPositions);
        byte[] sliceImg = new byte[sizeX * sizeY];
        if (dimY < img.getNumDimensions()) {
            while (cursor.hasNext()) {
                cursor.fwd();
                sliceImg[cursor.getPosition((int)dimX) + cursor.getPosition((int)dimY) * sizeX] = display.get8BitSigned(cursor.getType());
            }
        } else {
            while (cursor.hasNext()) {
                cursor.fwd();
                sliceImg[cursor.getPosition((int)dimX)] = display.get8BitSigned(cursor.getType());
            }
        }
        return sliceImg;
    }

    public void addUnsignedShortSlice(String sliceLabel, Object pixels) {
    }

    public void addSlice(String sliceLabel, ImageProcessor ip) {
    }

    public void addSlice(String sliceLabel, ImageProcessor ip, int n) {
    }

    public void deleteSlice(int n) {
    }

    public void deleteLastSlice() {
    }

    public void update(ImageProcessor ip) {
    }

    public Object getPixels(int n) {
        return this.getProcessor(n).getPixels();
    }

    public void setPixels(Object pixels, int n) {
    }

    public Object[] getImageArray() {
        return null;
    }

    public String[] getSliceLabels() {
        return null;
    }

    public String getSliceLabel(int n) {
        return "" + n;
    }

    public String getShortSliceLabel(int n) {
        return this.getSliceLabel(n);
    }

    public void setSliceLabel(String label, int n) {
    }

    public boolean isRGB() {
        return false;
    }

    public boolean isHSB() {
        return false;
    }

    public boolean isVirtual() {
        return true;
    }

    public void trim() {
    }

    public String toString() {
        return "Virtual Stack of " + this.img;
    }

    public int getSize() {
        return this.size;
    }

    public void setBitDepth(int bitDepth) {
    }

    public int getBitDepth() {
        switch (this.type) {
            case 0: 
            case 3: {
                return 8;
            }
            case 1: {
                return 16;
            }
            case 2: {
                return 32;
            }
            case 4: {
                return 24;
            }
        }
        return 0;
    }

    public String getDirectory() {
        return null;
    }

    public String getFileName(int n) {
        return null;
    }
}

