/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.tools;

import net.imagej.display.ImageDisplay;
import org.scijava.display.Display;
import org.scijava.display.event.input.MsMovedEvent;
import org.scijava.display.event.input.MsPressedEvent;
import org.scijava.display.event.input.MsReleasedEvent;
import org.scijava.display.event.input.MsWheelEvent;
import org.scijava.plugin.Plugin;
import org.scijava.tool.AbstractTool;
import org.scijava.tool.Tool;
import org.scijava.util.IntCoords;
import org.scijava.util.IntRect;

@Plugin(type=Tool.class, name="Zoom", description="Magnifying glass (or use \"+\" and \"-\" keys)", iconPath="/icons/tools/zoom.png", priority=-200.0)
public class ZoomTool
extends AbstractTool {
    public static final double PRIORITY = -200.0;
    private static final int DRAG_THRESHOLD = 8;
    private final IntCoords mousePos = new IntCoords(0, 0);
    private final IntCoords mouseDown = new IntCoords(0, 0);
    private final IntCoords mouseUp = new IntCoords(0, 0);

    public void onMouseDown(MsPressedEvent evt) {
        this.mouseDown.x = evt.getX();
        this.mouseDown.y = evt.getY();
        evt.consume();
    }

    public void onMouseUp(MsReleasedEvent evt) {
        Display display = evt.getDisplay();
        if (!(display instanceof ImageDisplay)) {
            return;
        }
        ImageDisplay imageDisplay = (ImageDisplay)display;
        this.mouseUp.x = evt.getX();
        this.mouseUp.y = evt.getY();
        int xDist = Math.abs(this.mouseUp.x - this.mouseDown.x);
        int yDist = Math.abs(this.mouseUp.y - this.mouseDown.y);
        if (xDist > 8 || yDist > 8) {
            if (this.mouseUp.x < this.mouseDown.x) {
                int x = this.mouseUp.x;
                this.mouseUp.x = this.mouseDown.x;
                this.mouseDown.x = x;
            }
            if (this.mouseUp.y < this.mouseDown.y) {
                int y = this.mouseUp.y;
                this.mouseUp.y = this.mouseDown.y;
                this.mouseDown.y = y;
            }
            int width = this.mouseUp.x - this.mouseDown.x;
            int height = this.mouseUp.y - this.mouseDown.y;
            IntRect bounds = new IntRect(this.mouseDown.x, this.mouseDown.y, width, height);
            imageDisplay.getCanvas().zoomToFit(bounds);
        } else {
            boolean zoomOut;
            boolean bl = zoomOut = evt.getButton() != 0 || evt.getModifiers().isCtrlDown();
            if (zoomOut) {
                imageDisplay.getCanvas().zoomOut(this.mouseDown);
            } else {
                imageDisplay.getCanvas().zoomIn(this.mouseDown);
            }
        }
        evt.consume();
    }

    public void onMouseMove(MsMovedEvent evt) {
        this.mousePos.x = evt.getX();
        this.mousePos.y = evt.getY();
    }

    public void onMouseWheel(MsWheelEvent evt) {
        Display display = evt.getDisplay();
        if (!(display instanceof ImageDisplay)) {
            return;
        }
        ImageDisplay imageDisplay = (ImageDisplay)display;
        IntCoords center = new IntCoords(evt.getX(), evt.getY());
        if (evt.getWheelRotation() < 0) {
            imageDisplay.getCanvas().zoomIn(center);
        } else {
            imageDisplay.getCanvas().zoomOut(center);
        }
        evt.consume();
    }
}

