/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import java.util.Arrays;
import java.util.function.Supplier;
import net.imglib2.AbstractRealLocalizable;
import net.imglib2.Localizable;
import net.imglib2.RealLocalizable;
import net.imglib2.RealRandomAccess;
import net.imglib2.util.Localizables;

public class RealPointSample<T>
extends AbstractRealLocalizable
implements RealRandomAccess<T> {
    protected final Supplier<T> sampleSupplier;

    protected RealPointSample(Supplier<T> sampleSupplier, double[] position, boolean copyPosition) {
        super(copyPosition ? (double[])position.clone() : position);
        this.sampleSupplier = sampleSupplier;
    }

    public RealPointSample(Supplier<T> sampleSupplier, int n) {
        super(n);
        this.sampleSupplier = sampleSupplier;
    }

    public RealPointSample(Supplier<T> sampleSupplier, double ... position) {
        this(sampleSupplier, position, true);
    }

    public RealPointSample(Supplier<T> sampleSupplier, float ... position) {
        this(sampleSupplier, position.length);
        this.setPosition(position);
    }

    public RealPointSample(Supplier<T> sampleSupplier, RealLocalizable localizable) {
        this(sampleSupplier, localizable.numDimensions());
        localizable.localize(this.position);
    }

    @Override
    public void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1.0;
    }

    @Override
    public void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] - 1.0;
    }

    @Override
    public void move(int distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    @Override
    public void move(long distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    @Override
    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + localizable.getDoublePosition(d);
        }
    }

    @Override
    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    @Override
    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    @Override
    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = localizable.getDoublePosition(d);
        }
    }

    @Override
    public void setPosition(int[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
    }

    @Override
    public void setPosition(long[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
    }

    @Override
    public void setPosition(int position, int d) {
        this.position[d] = position;
    }

    @Override
    public void setPosition(long position, int d) {
        this.position[d] = position;
    }

    @Override
    public void move(float distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    @Override
    public void move(double distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + distance;
    }

    @Override
    public void move(RealLocalizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + localizable.getDoublePosition(d);
        }
    }

    @Override
    public void move(float[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    @Override
    public void move(double[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
        }
    }

    @Override
    public void setPosition(RealLocalizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = localizable.getDoublePosition(d);
        }
    }

    @Override
    public void setPosition(float[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
    }

    @Override
    public void setPosition(double[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
    }

    @Override
    public void setPosition(float position, int d) {
        this.position[d] = position;
    }

    @Override
    public void setPosition(double position, int d) {
        this.position[d] = position;
    }

    public String toString() {
        return Localizables.toString(this) + " -> " + this.get().toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            RealPointSample other = (RealPointSample)obj;
            return Localizables.equals(this, other) && this.get().equals(other.get());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.position) ^ this.get().hashCode();
    }

    public static <T> RealPointSample<T> wrap(T sample, double[] position) {
        return new RealPointSample<Object>(() -> sample, position, false);
    }

    public static <T> RealPointSample<T> wrapSupplier(Supplier<T> sampleSupplier, double[] position) {
        return new RealPointSample<T>(sampleSupplier, position, false);
    }

    @Override
    public T get() {
        return this.sampleSupplier.get();
    }

    @Override
    public T getType() {
        return this.get();
    }

    @Override
    public RealPointSample<T> copy() {
        return new RealPointSample<T>(this.sampleSupplier, this.position, true);
    }
}

