/*
 * Decompiled with CFR 0.152.
 */
import fiji.util.gui.GenericDialogPlus;
import ij.gui.MultiLineLabel;
import ij.plugin.PlugIn;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import stitching.CommonFunctions;
import stitching.utils.Log;

public class DeltaVision_Converter
implements PlugIn {
    private final String myURL = "http://fly.mpi-cbg.de/~preibisch/contact.html";
    protected String dvLogFileStatic = "";

    public void run(String args) {
        GenericDialogPlus gd = new GenericDialogPlus("Delta Vision Log File Converter");
        gd.addFileField("DeltaVision log file", this.dvLogFileStatic, 50);
        gd.addMessage("");
        gd.addMessage("This Plugin is developed by Stephan Preibisch\nhttp://fly.mpi-cbg.de/~preibisch/contact.html");
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        CommonFunctions.addHyperLinkListener(text, "http://fly.mpi-cbg.de/~preibisch/contact.html");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String dvLogFile = this.dvLogFileStatic = gd.getNextString();
        int dim = -1;
        int z = -1;
        int w = -1;
        int t = -1;
        int sizeX = -1;
        int sizeY = -1;
        double xRes = -1.0;
        double yRes = -1.0;
        double zRes = -1.0;
        try {
            BufferedReader in = DeltaVision_Converter.openFileReadEx(dvLogFile);
            boolean foundExperimentRecord = false;
            while (in.ready() && !foundExperimentRecord) {
                String[] content;
                String info;
                String line = in.readLine().trim();
                if (line.contains("ZWT Dimensions")) {
                    info = line.substring(line.indexOf(58) + 1, line.length());
                    content = info.split("x");
                    z = Integer.parseInt(content[0].trim());
                    w = Integer.parseInt(content[1].trim());
                    t = Integer.parseInt(content[2].trim());
                }
                if (line.contains("Pixel Size")) {
                    info = line.substring(line.indexOf(58) + 1, line.length()).trim();
                    content = info.split(" ");
                    xRes = Double.parseDouble(content[0].trim());
                    yRes = Double.parseDouble(content[1].trim());
                    zRes = Double.parseDouble(content[2].trim());
                }
                if (line.contains("XY Dimensions")) {
                    info = line.substring(line.indexOf(58) + 1, line.length());
                    content = info.split("x");
                    sizeX = Integer.parseInt(content[0].trim());
                    sizeY = Integer.parseInt(content[1].trim());
                }
                if (!line.contains("Experiment Record:")) continue;
                foundExperimentRecord = true;
            }
            dim = z > 1 ? 3 : 2;
            Log.info("slices: " + z + ", dimensionality = " + dim);
            Log.info("channels: " + w);
            Log.info("timepoints: " + t);
            Log.info("x-resolution: " + xRes);
            Log.info("y-resolution: " + yRes);
            Log.info("z-resolution: " + zRes);
            Log.info("image size x: " + sizeX);
            Log.info("image size y: " + sizeY);
            if (t > 1) {
                Log.error("Cannot handle more than one timepoint");
                return;
            }
            PrintWriter out = DeltaVision_Converter.openFileWriteEx(dvLogFile + ".tileconfiguration.txt");
            out.println("# Define the number of dimensions we are working on");
            out.println("dim = " + dim);
            out.println("");
            out.println("# Define the image coordinates");
            int countChannel = 0;
            int countImages = 0;
            while (in.ready()) {
                String line = in.readLine().trim();
                if (!line.contains("Stage coordinates:") || countChannel++ % w != 0) continue;
                String coordinates = line.substring(line.indexOf(40) + 1, line.indexOf(41));
                String[] content = coordinates.split(",");
                double xPos = Double.parseDouble(content[0].trim()) / xRes;
                double yPos = Double.parseDouble(content[1].trim()) / yRes;
                double zPos = Double.parseDouble(content[2].trim()) / zRes;
                if (dim == 3) {
                    out.println("image_" + Stitch_Image_Grid.getLeadingZeros(8, countImages) + "; ; (" + xPos + ", " + yPos + ", " + zPos + ")");
                } else {
                    out.println("image_" + Stitch_Image_Grid.getLeadingZeros(8, countImages) + "; ; (" + xPos + ", " + yPos + ")");
                }
                ++countImages;
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            Log.error("Cannot open file '" + dvLogFile + "': " + e);
            return;
        }
    }

    public static void main(String[] args) {
        DeltaVision_Converter dv = new DeltaVision_Converter();
        dv.run("");
    }

    public static PrintWriter openFileWriteEx(String fileName) throws IOException {
        return new PrintWriter(new FileWriter(fileName));
    }

    public static BufferedReader openFileReadEx(String fileName) throws IOException {
        return new BufferedReader(new FileReader(fileName));
    }
}

