/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.IJ;
import ini.trakem2.display.DLabel;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Patch;
import ini.trakem2.display.SnapshotPanel;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public final class DisplayablePanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    public static final int HEIGHT = 52;
    private static ImageIcon LOCKED = new ImageIcon(DisplayablePanel.class.getResource("/img/locked.png"));
    private static ImageIcon UNLOCKED = new ImageIcon(DisplayablePanel.class.getResource("/img/unlocked.png"));
    private static ImageIcon VISIBLE = new ImageIcon(DisplayablePanel.class.getResource("/img/visible.png"));
    private static ImageIcon INVISIBLE = new ImageIcon(DisplayablePanel.class.getResource("/img/invisible.png"));
    private static ImageIcon LINKED = new ImageIcon(DisplayablePanel.class.getResource("/img/linked.png"));
    private static ImageIcon UNLINKED = new ImageIcon(DisplayablePanel.class.getResource("/img/unlinked.png"));
    private static final Font SMALL = new Font("Courier", 2, 11);
    private static final Color GRAYISH = new Color(50, 50, 50);
    private JCheckBox c;
    private JCheckBox c_locked;
    private JCheckBox c_linked;
    private JLabel title;
    private JLabel title2;
    private JLabel idlabel;
    private JPanel titles;
    private SnapshotPanel sp;
    private Display display;
    private Displayable d;
    private final ML listener = new ML();
    private static int MAX_CHARS = 20;
    public static final int LOCK_STATE = 1;
    public static final int VISIBILITY_STATE = 2;
    public static final int LINK_STATE = 4;

    public DisplayablePanel(Display display, Displayable d) {
        this.display = display;
        this.d = d;
        this.c = new JCheckBox();
        this.c.setSelected(d.isVisible());
        this.c.addMouseListener(this.listener);
        this.c.setIcon(INVISIBLE);
        this.c.setSelectedIcon(VISIBLE);
        this.c.setBackground(Color.white);
        Dimension maxdim = new Dimension(26, 14);
        this.c.setPreferredSize(maxdim);
        this.c.setMaximumSize(maxdim);
        this.c_locked = new JCheckBox();
        this.c_locked.setIcon(UNLOCKED);
        this.c_locked.setSelectedIcon(LOCKED);
        this.c_locked.setSelected(d.isLocked2());
        this.c_locked.addMouseListener(this.listener);
        this.c_locked.setBackground(Color.white);
        Dimension maxdim10 = new Dimension(26, 10);
        this.c_locked.setPreferredSize(maxdim10);
        this.c_locked.setMaximumSize(maxdim10);
        this.c_linked = new JCheckBox();
        this.c_linked.setIcon(UNLINKED);
        this.c_linked.setSelectedIcon(LINKED);
        this.c_linked.setSelected(d.isLinked());
        this.c_linked.addMouseListener(this.listener);
        this.c_linked.setBackground(Color.white);
        this.c_linked.setPreferredSize(maxdim10);
        this.c_linked.setMaximumSize(maxdim10);
        this.sp = new SnapshotPanel(display, d);
        this.title = new JLabel();
        this.title.addMouseListener(this);
        this.title2 = new JLabel();
        this.title2.addMouseListener(this);
        this.idlabel = new JLabel("#" + d.getId());
        this.idlabel.setFont(SMALL);
        this.idlabel.setForeground(GRAYISH);
        this.titles = new JPanel();
        this.updateTitle();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints co = new GridBagConstraints();
        this.setLayout(gb);
        co.anchor = 18;
        co.fill = 0;
        co.gridx = 0;
        co.gridy = 0;
        gb.setConstraints(this.c, co);
        this.add(this.c);
        co.gridy = 1;
        co.anchor = 17;
        co.fill = 3;
        co.weighty = 1.0;
        gb.setConstraints(this.c_locked, co);
        this.add(this.c_locked);
        co.gridy = 2;
        co.anchor = 16;
        co.weighty = 0.0;
        gb.setConstraints(this.c_linked, co);
        this.add(this.c_linked);
        co.anchor = 18;
        co.fill = 0;
        co.gridx = 1;
        co.gridy = 0;
        co.gridheight = 3;
        gb.setConstraints(this.sp, co);
        this.add(this.sp);
        co.gridheight = 1;
        co.weightx = 1.0;
        co.fill = 2;
        co.gridx = 2;
        co.gridy = 0;
        gb.setConstraints(this.title, co);
        this.add(this.title);
        co.gridy = 1;
        co.anchor = 17;
        co.fill = 1;
        co.weighty = 1.0;
        gb.setConstraints(this.title2, co);
        this.add(this.title2);
        co.gridy = 2;
        co.anchor = 16;
        co.fill = 2;
        co.weighty = 0.0;
        gb.setConstraints(this.idlabel, co);
        this.add(this.idlabel);
        this.setMinimumSize(new Dimension(230, 52));
        this.setPreferredSize(new Dimension(248, 52));
        this.addMouseListener(this);
        this.setBackground(Color.white);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    public void set(Displayable d) {
        this.d = d;
        this.c.setSelected(d.isVisible());
        this.c_locked.setSelected(d.isLocked2());
        this.c_linked.setSelected(d.isLinked());
        this.updateTitle();
        this.sp.set(d);
    }

    @Override
    public void paint(Graphics g) {
        if (null == g) {
            return;
        }
        if (this.display.getSelection().contains(this.d)) {
            if (null != this.display.getActive() && this.display.getActive() == this.d) {
                this.setBackground(Color.cyan);
            } else {
                this.setBackground(Color.pink);
            }
        } else {
            this.setBackground(Color.white);
        }
        super.paint(g);
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (null != this.titles) {
            this.titles.setBackground(c);
            this.title.setBackground(c);
            this.title2.setBackground(c);
        }
    }

    private String makeUpdatedTitle() {
        if (null == this.d) {
            Utils.log2("null d ");
            return "";
        }
        if (null == this.d.getTitle()) {
            Utils.log2("null title for " + this.d);
            return "";
        }
        Class<?> c = this.d.getClass();
        if (c == Patch.class) {
            return this.d.getTitle();
        }
        if (c == DLabel.class) {
            return this.d.getTitle().replace('\n', ' ');
        }
        return this.d.getProject().getMeaningfulTitle2(this.d);
    }

    public void updateTitle() {
        this.idlabel.setText("#" + this.d.getId());
        String t = this.makeUpdatedTitle();
        if (t.length() <= MAX_CHARS) {
            this.title.setText(t);
            this.title2.setText("");
            return;
        }
        int lastbracket = t.lastIndexOf(91);
        int end = -1;
        int start = -1;
        if (lastbracket - 1 <= MAX_CHARS && -1 != lastbracket) {
            end = lastbracket - 1;
            start = lastbracket;
        } else {
            end = start = MAX_CHARS;
        }
        this.title.setText(t.substring(0, end));
        if (t.length() - start - 1 > MAX_CHARS) {
            this.title2.setText(t.substring(start, start + 7) + "..." + t.substring(t.length() - 10));
        } else {
            this.title2.setText(t.substring(start));
        }
        this.title.setToolTipText(t);
        this.title2.setToolTipText(t);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (this.display.isTransforming()) {
            return;
        }
        this.display.select(this.d, me.isShiftDown());
        if (me.isPopupTrigger() || IJ.isMacOSX() && me.isControlDown() || 2 == me.getButton() || 0 != (me.getModifiers() & 4)) {
            this.display.getPopupMenu().show(this, me.getX(), me.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public String toString() {
        return "Displayable panel for " + this.d.toString();
    }

    protected void updateCheckbox(int cb, boolean state) {
        switch (cb) {
            case 1: {
                this.c_locked.setSelected(state);
                break;
            }
            case 2: {
                this.c.setSelected(state);
                this.d.getLayerSet().clearScreenshots();
                break;
            }
            case 4: {
                this.c_linked.setSelected(state);
                break;
            }
            default: {
                Utils.log2("Ooops: don't know what to do with checkbox code " + cb);
            }
        }
    }

    protected void updateCheckbox(int cb) {
        switch (cb) {
            case 1: {
                this.c_locked.setSelected(this.d.isLocked2());
                break;
            }
            case 2: {
                this.c.setSelected(this.d.isVisible());
                this.d.getLayerSet().clearScreenshots();
                break;
            }
            case 4: {
                this.c_linked.setSelected(this.d.isLinked());
                break;
            }
            default: {
                Utils.log2("Ooops: don't know what to do with checkbox code " + cb);
            }
        }
    }

    private class ML
    extends MouseAdapter {
        private ML() {
        }

        @Override
        public void mousePressed(final MouseEvent me) {
            ((DisplayablePanel)DisplayablePanel.this).display.dispatcher.exec(new Runnable(){

                @Override
                public void run() {
                    JCheckBox source = (JCheckBox)me.getSource();
                    if (source == DisplayablePanel.this.c) {
                        if (!source.isSelected()) {
                            DisplayablePanel.this.d.setVisible(true);
                        } else {
                            if (Display.isTransforming(DisplayablePanel.this.d)) {
                                Utils.showStatus("Transforming! Can't change visibility.", false);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DisplayablePanel.this.c.setSelected(true);
                                    }
                                });
                                return;
                            }
                            DisplayablePanel.this.d.setVisible(false);
                        }
                    } else if (source == DisplayablePanel.this.c_locked) {
                        String[] members = new String[]{"locked"};
                        if (!source.isSelected()) {
                            if (Display.isTransforming(DisplayablePanel.this.d)) {
                                Utils.logAll("Transforming! Can't lock.");
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DisplayablePanel.this.c_locked.setSelected(false);
                                    }
                                });
                                return;
                            }
                            DisplayablePanel.this.d.getLayerSet().addDataEditStep(DisplayablePanel.this.d, members);
                            DisplayablePanel.this.d.setLocked(true);
                            DisplayablePanel.this.d.getLayerSet().addDataEditStep(DisplayablePanel.this.d, members);
                        } else {
                            DisplayablePanel.this.d.getLayerSet().addDataEditStep(DisplayablePanel.this.d, members);
                            DisplayablePanel.this.d.setLocked(false);
                            DisplayablePanel.this.d.getLayerSet().addDataEditStep(DisplayablePanel.this.d, members);
                        }
                        HashSet<Displayable> lg = DisplayablePanel.this.d.getLinkedGroup(null);
                        if (null != lg) {
                            lg.remove(DisplayablePanel.this.d);
                            Display.updateCheckboxes(lg, 1, DisplayablePanel.this.d.isLocked2());
                        }
                    } else if (source == DisplayablePanel.this.c_linked) {
                        HashSet<Displayable> hs;
                        if (Display.isTransforming(DisplayablePanel.this.d)) {
                            Utils.logAll("Transforming! Can't modify linking state.");
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DisplayablePanel.this.c_linked.setSelected(DisplayablePanel.this.d.isLinked());
                                }
                            });
                            return;
                        }
                        if (!source.isSelected()) {
                            Rectangle box = DisplayablePanel.this.d.getBoundingBox();
                            hs = new HashSet<Displayable>(DisplayablePanel.this.d.getLayer().find(box, true));
                            hs.addAll(DisplayablePanel.this.d.getLayerSet().findZDisplayables(DisplayablePanel.this.d.getLayer(), box, true));
                            if (hs.size() > 1) {
                                DisplayablePanel.this.d.getLayerSet().addDataEditStep(hs, new String[]{"data"});
                                for (Displayable other : hs) {
                                    if (other == DisplayablePanel.this.d) continue;
                                    DisplayablePanel.this.d.link(other);
                                }
                                DisplayablePanel.this.d.getLayerSet().addDataEditStep(hs, new String[]{"data"});
                            } else {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DisplayablePanel.this.c_linked.setSelected(false);
                                    }
                                });
                            }
                        } else {
                            hs = DisplayablePanel.this.d.getLinkedGroup(null);
                            DisplayablePanel.this.d.getLayerSet().addDataEditStep(hs, new String[]{"data"});
                            DisplayablePanel.this.d.unlink();
                            DisplayablePanel.this.d.getLayerSet().addDataEditStep(hs, new String[]{"data"});
                        }
                        if (null != hs) {
                            hs.remove(DisplayablePanel.this.d);
                            if (hs.size() > 0) {
                                Display.updateCheckboxes(hs, 4);
                                Display.updateCheckboxes(hs, 1);
                            }
                        }
                        Display.updateSelection(Display.getFront());
                    }
                }
            });
        }
    }
}

